/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SIZE
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)SIZE.class);

    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        session.resetState();
        String fileName = request.getArgument();
        if (fileName == null) {
            out.write(FtpReplyUtil.translate(session, 501, "SIZE", null));
            return;
        }
        FileObject file = null;
        try {
            file = session.getFileSystemView().getFileObject(fileName);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception getting file object", (Throwable)ex);
        }
        if (file == null) {
            out.write(FtpReplyUtil.translate(session, 550, "SIZE.missing", fileName));
            return;
        }
        fileName = file.getFullName();
        if (!file.doesExist()) {
            out.write(FtpReplyUtil.translate(session, 550, "SIZE.missing", fileName));
        } else if (!file.isFile()) {
            out.write(FtpReplyUtil.translate(session, 550, "SIZE.invalid", fileName));
        } else {
            String fileLen = String.valueOf(file.getSize());
            out.write(FtpReplyUtil.translate(session, 213, "SIZE", fileLen));
        }
    }
}

