/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.transport;

import java.net.URI;
import java.net.URL;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.management.ServerConfig;

public class AddressRewritingEndpointInfo
extends EndpointInfo {
    private static Logger log = Logger.getLogger(AddressRewritingEndpointInfo.class);
    private ServerConfig serverConfig;
    SoapAddress saddress;

    AddressRewritingEndpointInfo(ServiceInfo serv, String trans, ServerConfig serverConfig) {
        super(serv, trans);
        this.serverConfig = serverConfig;
    }

    public void setAddress(String s) {
        String previousAddress = super.getAddress();
        super.setAddress(s);
        boolean setNewAddress = false;
        if (previousAddress == null) {
            setNewAddress = true;
        } else if (this.isRewriteAllowed(s) && this.isRewriteRequired(s, previousAddress)) {
            String uriScheme = AddressRewritingEndpointInfo.getUriScheme(s);
            if ("https".equalsIgnoreCase(AddressRewritingEndpointInfo.getUriScheme(previousAddress))) {
                uriScheme = "https";
            }
            if (uriScheme == null) {
                uriScheme = "http";
            }
            s = this.rewriteSoapAddress(s, uriScheme);
            setNewAddress = true;
        }
        if (setNewAddress && this.saddress != null) {
            log.info((Object)("Setting new service endpoint address in wsdl: " + s));
            this.saddress.setLocationURI(s);
        }
    }

    public void addExtensor(Object el) {
        super.addExtensor(el);
        if (el instanceof SoapAddress) {
            this.saddress = (SoapAddress)el;
        }
    }

    protected boolean isRewriteAllowed(String address) {
        return address != null && address.trim().toLowerCase().startsWith("http");
    }

    protected boolean isRewriteRequired(String address, String previousAddress) {
        if (this.serverConfig.isModifySOAPAddress()) {
            log.debug((Object)"Rewrite required because of configuration");
            return true;
        }
        if (this.isInvalidAddress(previousAddress)) {
            log.debug((Object)"Rewrite required because of invalid url");
            return true;
        }
        log.debug((Object)"Rewrite not required");
        return false;
    }

    protected boolean isInvalidAddress(String address) {
        if (address == null) {
            return true;
        }
        String s = address.trim();
        if (s.length() == 0 || s.contains("REPLACE_WITH_ACTUAL_URL")) {
            return true;
        }
        try {
            new URL(s);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    protected String rewriteSoapAddress(String s, String uriScheme) {
        try {
            int portNo;
            URL url = new URL(s);
            String path = url.getPath();
            String host = this.serverConfig.getWebServiceHost();
            String port = "";
            if ("https".equals(uriScheme)) {
                portNo = this.serverConfig.getWebServiceSecurePort();
                if (portNo != 443) {
                    port = ":" + portNo;
                }
            } else {
                portNo = this.serverConfig.getWebServicePort();
                if (portNo != 80) {
                    port = ":" + portNo;
                }
            }
            String urlStr = uriScheme + "://" + host + port + path;
            log.debug((Object)("Rewritten new candidate service endpoint address '" + s + "' to '" + urlStr + "'"));
            return urlStr;
        }
        catch (Exception e) {
            log.debug((Object)("Invalid url provided, using it without rewriting: " + s));
            return s;
        }
    }

    private static String getUriScheme(String address) {
        try {
            URI addrURI = new URI(address);
            String scheme = addrURI.getScheme();
            return scheme;
        }
        catch (Exception e) {
            return null;
        }
    }
}

