/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.strategy;

import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTestRunner;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.AbstractLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyFactory;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.apache.xmlbeans.XmlObject;

public class BurstLoadStrategy
extends AbstractLoadStrategy {
    private static final String BURST_DURATION_ELEMENT = "burstDuration";
    private static final String BURST_DELAY_ELEMENT = "burstDelay";
    private static final int DEFAULT_BURST_DURATION = 10000;
    private static final int DEFAULT_BURST_DELAY = 60000;
    private static final int SLEEP_DELAY = 500;
    public static final String STRATEGY_TYPE = "Burst";
    private JPanel configPanel;
    private int burstDelay = 60000;
    private int burstDuration = 10000;
    private long startTime;
    private JTextField delayField;
    private JTextField durationField;
    private JLabel infoLabel = new JLabel();

    public BurstLoadStrategy() {
        super(STRATEGY_TYPE);
        this.burstDelay = 60000;
        this.burstDuration = 10000;
    }

    public BurstLoadStrategy(XmlObject config) {
        super(STRATEGY_TYPE);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(config);
        this.burstDelay = reader.readInt(BURST_DELAY_ELEMENT, 60000);
        this.burstDuration = reader.readInt(BURST_DURATION_ELEMENT, 10000);
    }

    public void beforeLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
        this.startTime = System.currentTimeMillis();
        this.infoLabel.setText("starting..");
    }

    public void beforeTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestRunner testRunner, TestRunContext runContext) {
        String label;
        long timePassed = System.currentTimeMillis() - this.startTime;
        long mod = timePassed % (long)(this.burstDelay + this.burstDuration);
        while (mod < (long)this.burstDelay && (testRunner.getStatus() == TestRunner.Status.RUNNING || testRunner.getStatus() == TestRunner.Status.INITIALIZED)) {
            try {
                label = ((long)this.burstDelay - mod) / 1000L + "s delay left";
                if (!this.infoLabel.getText().equals(label)) {
                    this.infoLabel.setText(label);
                }
                Thread.sleep(500L);
                if (((WsdlLoadTestRunner)loadTestRunner).getProgress() >= 1.0f) {
                    this.infoLabel.setText("");
                    return;
                }
                timePassed = System.currentTimeMillis() - this.startTime;
                mod = timePassed % (long)(this.burstDelay + this.burstDuration);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (testRunner.getStatus() == TestRunner.Status.RUNNING) {
            label = ((long)(this.burstDelay + this.burstDuration) - mod) / 1000L + "s burst left";
            if (!this.infoLabel.getText().equals(label)) {
                this.infoLabel.setText(label);
            }
        }
    }

    public void afterLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
        this.infoLabel.setText("");
    }

    public JComponent getConfigurationPanel() {
        if (this.configPanel == null) {
            ButtonBarBuilder builder = new ButtonBarBuilder();
            this.delayField = new JTextField(4);
            UISupport.setPreferredHeight(this.delayField, 18);
            this.delayField.setHorizontalAlignment(4);
            this.delayField.setText(String.valueOf(this.burstDelay / 1000));
            this.delayField.setToolTipText("Sets the delay before each burst run in seconds");
            this.delayField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

                public void update(Document doc) {
                    try {
                        BurstLoadStrategy.this.burstDelay = Integer.parseInt(BurstLoadStrategy.this.delayField.getText()) * 1000;
                        BurstLoadStrategy.this.notifyConfigurationChanged();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            builder.addFixed((JComponent)new JLabel("Burst Delay"));
            builder.addRelatedGap();
            builder.addFixed((JComponent)this.delayField);
            builder.addRelatedGap();
            this.durationField = new JTextField(4);
            UISupport.setPreferredHeight(this.durationField, 18);
            this.durationField.setHorizontalAlignment(4);
            this.durationField.setText(String.valueOf(this.burstDuration / 1000));
            this.durationField.setToolTipText("Specifies the duration of a burst run in seconds");
            this.durationField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

                public void update(Document doc) {
                    try {
                        BurstLoadStrategy.this.burstDuration = Integer.parseInt(BurstLoadStrategy.this.durationField.getText()) * 1000;
                        BurstLoadStrategy.this.notifyConfigurationChanged();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            builder.addFixed((JComponent)new JLabel("Burst Duration"));
            builder.addRelatedGap();
            builder.addFixed((JComponent)this.durationField);
            builder.addRelatedGap();
            builder.addFixed((JComponent)this.infoLabel);
            this.configPanel = builder.getPanel();
        }
        return this.configPanel;
    }

    public XmlObject getConfig() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(BURST_DELAY_ELEMENT, this.burstDelay);
        builder.add(BURST_DURATION_ELEMENT, this.burstDuration);
        return builder.finish();
    }

    public static class Factory
    implements LoadStrategyFactory {
        public String getType() {
            return BurstLoadStrategy.STRATEGY_TYPE;
        }

        public LoadStrategy build(XmlObject config) {
            return new BurstLoadStrategy(config);
        }

        public LoadStrategy create() {
            return new BurstLoadStrategy();
        }
    }
}

