/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.support;

import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.components.JEditorStatusBar;
import com.eviware.soapui.support.xml.JXEditTextArea;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.tokenmarker.CTokenMarker;
import org.syntax.jedit.tokenmarker.GroovyTokenMarker;

public class GroovyEditor
extends JPanel
implements JEditorStatusBar.JEditorStatusBarTarget {
    private JXEditTextArea editArea;
    private final GroovyEditorModel model;
    private InternalSettingsListener settingsListener;

    public GroovyEditor(GroovyEditorModel model) {
        super(new BorderLayout());
        this.model = model;
        this.editArea = new JXEditTextArea(new CTokenMarker(false, this.initKeywords()));
        Settings settings = model.getSettings();
        String editorFont = settings.getString(UISettings.EDITOR_FONT, "Courier plain 11");
        if (editorFont != null && editorFont.length() > 0) {
            this.editArea.setFont(Font.decode(editorFont));
        } else {
            this.editArea.setFont(Font.decode("Courier plain 11"));
        }
        this.editArea.setText(model.getScript());
        this.editArea.setCaretPosition(0);
        Action runAction = model.getRunAction();
        if (runAction != null) {
            this.editArea.getInputHandler().addKeyBinding("A+ENTER", runAction);
        }
        this.editArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                GroovyEditor.this.model.setScript(GroovyEditor.this.editArea.getText());
            }
        });
        this.settingsListener = new InternalSettingsListener();
        settings.addSettingsListener(this.settingsListener);
        this.add(this.editArea);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                GroovyEditor.this.editArea.requestFocusInWindow();
            }
        });
    }

    public JXEditTextArea getEditArea() {
        return this.editArea;
    }

    public void release() {
        this.model.getSettings().removeSettingsListener(this.settingsListener);
    }

    public void selectError(String message) {
        int ix;
        int n = ix = message == null ? -1 : message.indexOf("@ line ");
        if (ix >= 0) {
            try {
                int ix2 = message.indexOf(44, ix);
                int line = ix2 == -1 ? Integer.parseInt(message.substring(ix + 6).trim()) : Integer.parseInt(message.substring(ix + 6, ix2).trim());
                int column = 0;
                if (ix2 != -1 && (ix = message.indexOf("column ", ix2)) >= 0) {
                    ix2 = message.indexOf(46, ix);
                    column = ix2 == -1 ? Integer.parseInt(message.substring(ix + 7).trim()) : Integer.parseInt(message.substring(ix + 7, ix2).trim());
                }
                this.editArea.setCaretPosition(this.editArea.getLineStartOffset(line - 1) + column - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.editArea.requestFocus();
        }
    }

    private KeywordMap initKeywords() {
        KeywordMap keywords = GroovyTokenMarker.getKeywords();
        for (String keyword : this.model.getKeywords()) {
            keywords.add(keyword, (byte)7);
        }
        return keywords;
    }

    public void addCaretListener(CaretListener listener) {
        this.editArea.addCaretListener(listener);
    }

    public int getCaretPosition() {
        return this.editArea.getCaretPosition();
    }

    public int getLineOfOffset(int offset) throws Exception {
        return this.editArea.getLineOfOffset(offset);
    }

    public int getLineStartOffset(int line) throws Exception {
        return this.editArea.getLineStartOffset(line);
    }

    public void removeCaretListener(CaretListener listener) {
        this.editArea.removeCaretListener(listener);
    }

    private final class InternalSettingsListener
    implements SettingsListener {
        private InternalSettingsListener() {
        }

        public void settingChanged(String name, String newValue, String oldValue) {
            if (name.equals(UISettings.EDITOR_FONT)) {
                GroovyEditor.this.editArea.setFont(Font.decode(newValue));
                GroovyEditor.this.invalidate();
            }
        }
    }
}

