/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.RequestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.AssertionsListener;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.WsdlAssertionRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionsSupport
implements PropertyChangeListener {
    private List<AssertionsListener> assertionsListeners = new ArrayList<AssertionsListener>();
    private List<WsdlMessageAssertion> assertions = new ArrayList<WsdlMessageAssertion>();
    private final Assertable assertable;

    public AssertionsSupport(Assertable assertable, List<RequestAssertionConfig> assertionList) {
        this.assertable = assertable;
        for (RequestAssertionConfig rac : assertionList) {
            this.addWsdlAssertion(rac);
        }
    }

    public WsdlMessageAssertion addWsdlAssertion(RequestAssertionConfig config) {
        try {
            WsdlMessageAssertion assertion = WsdlAssertionRegistry.getInstance().buildAssertion(config, this.assertable);
            if (assertion == null) {
                return null;
            }
            this.assertions.add(assertion);
            assertion.addPropertyChangeListener(this);
            return assertion;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.assertable instanceof PropertyChangeListener) {
            ((PropertyChangeListener)((Object)this.assertable)).propertyChange(arg0);
        }
    }

    public int getAssertionCount() {
        return this.assertions.size();
    }

    public WsdlMessageAssertion getAssertionAt(int c) {
        return this.assertions.get(c);
    }

    public void addAssertionsListener(AssertionsListener listener) {
        this.assertionsListeners.add(listener);
    }

    public void removeAssertionsListener(AssertionsListener listener) {
        this.assertionsListeners.remove(listener);
    }

    public int removeAssertion(WsdlMessageAssertion assertion) {
        int ix = this.assertions.indexOf(assertion);
        if (ix == -1) {
            throw new RuntimeException("assertion [" + assertion.getName() + "] not available ");
        }
        assertion.removePropertyChangeListener(this);
        this.assertions.remove(ix);
        this.fireAssertionRemoved(assertion);
        return ix;
    }

    public void release() {
        for (WsdlMessageAssertion assertion : this.assertions) {
            assertion.release();
        }
    }

    public Iterator<WsdlMessageAssertion> iterator() {
        return this.assertions.iterator();
    }

    public void fireAssertionAdded(WsdlMessageAssertion assertion) {
        AssertionsListener[] listeners = this.assertionsListeners.toArray(new AssertionsListener[this.assertionsListeners.size()]);
        for (int c = 0; c < listeners.length; ++c) {
            listeners[c].assertionAdded(assertion);
        }
    }

    public void fireAssertionRemoved(WsdlMessageAssertion assertion) {
        AssertionsListener[] listeners = this.assertionsListeners.toArray(new AssertionsListener[this.assertionsListeners.size()]);
        for (int c = 0; c < listeners.length; ++c) {
            listeners[c].assertionRemoved(assertion);
        }
    }

    public void updateConfig(List<RequestAssertionConfig> assertionList) {
        for (int i = 0; i < assertionList.size(); ++i) {
            RequestAssertionConfig config = assertionList.get(i);
            this.assertions.get(i).updateConfig(config);
        }
    }
}

