/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.gui.AnalysisErrorDialog;
import edu.umd.cs.findbugs.gui.AnalysisRun;
import java.awt.Frame;

public class SwingGUIBugReporter
extends TextUIBugReporter {
    private final AnalysisRun analysisRun;
    private SortedBugCollection bugCollection;
    private AnalysisErrorDialog errorDialog;
    private int errorCount;

    public SwingGUIBugReporter(AnalysisRun analysisRun) {
        this.analysisRun = analysisRun;
        this.bugCollection = new SortedBugCollection(this.getProjectStats());
    }

    public SortedBugCollection getBugCollection() {
        return this.bugCollection;
    }

    public boolean errorsOccurred() {
        return this.errorCount > 0;
    }

    public AnalysisErrorDialog getErrorDialog() {
        return this.errorDialog;
    }

    public void observeClass(ClassDescriptor classDescriptor) {
    }

    public void reportMissingClass(ClassNotFoundException ex) {
        ++this.errorCount;
        super.reportMissingClass(ex);
        String message = SwingGUIBugReporter.getMissingClassName(ex);
        this.bugCollection.addMissingClass(message);
    }

    public void logError(String message) {
        ++this.errorCount;
        this.analysisRun.getFrame().getLogger().logMessage(1, message);
        super.logError(message);
        this.bugCollection.addError(message);
    }

    public void finish() {
    }

    public void doReportBug(BugInstance bugInstance) {
        this.checkBugInstance(bugInstance);
        if (this.bugCollection.add(bugInstance)) {
            this.notifyObservers(bugInstance);
        }
    }

    private void createDialog() {
        if (this.errorDialog == null) {
            this.errorDialog = new AnalysisErrorDialog((Frame)this.analysisRun.getFrame(), true, this);
        }
    }

    public void reportQueuedErrors() {
        this.createDialog();
        this.errorDialog.clear();
        super.reportQueuedErrors();
        this.errorDialog.finish();
    }

    protected void emitLine(String line) {
        line = line.replaceAll("\t", "  ");
        this.errorDialog.addLine(line);
    }
}

