/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.dependencies;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import javax.management.ObjectName;
import org.jboss.internal.soa.esb.dependencies.HypersonicDatabaseMBean;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigImplMBean;

public class HypersonicDatabase
extends ServiceMBeanSupport
implements HypersonicDatabaseMBean {
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_USER = "sa";
    private static final String JDBC_DRIVER_CLASS = "org.hsqldb.jdbcDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:hsqldb:";
    private static final String DEFAULT_REMOTE_SHUTDOWN_COMMAND = "SHUTDOWN COMPACT";
    private static final String DEFAULT_IN_PROCESS_SHUTDOWN_COMMAND = "SHUTDOWN COMPACT";
    private static final String DEFAULT_IN_MEMORY_SHUTDOWN_COMMAND = "SHUTDOWN IMMEDIATELY";
    private static final String HYPERSONIC_DATA_DIR = "hypersonic";
    private static final int DEFAULT_PORT = 1701;
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private static final String DEFAULT_DATABASE_NAME = "default";
    private static final String IN_MEMORY_DATABASE = ".";
    private static final String DEFAULT_DATABASE_MANAGER_CLASS = "org.hsqldb.util.DatabaseManagerSwing";
    private static final String DEFAULT_SERVER_CLASS = "org.hsqldb.Server";
    private static final long DEFAULT_DELAY = 5000L;
    private File dbPath;
    private String name = "default";
    private int port = 1701;
    private String address = "0.0.0.0";
    private boolean silent = true;
    private boolean trace = false;
    private boolean no_system_exit = true;
    private boolean persist = true;
    private String shutdownCommand;
    private boolean inProcessMode = false;
    private String user = "sa";
    private String password = "";
    private String databaseManagerClass = "org.hsqldb.util.DatabaseManagerSwing";
    private String serverClass = "org.hsqldb.Server";
    private long delay = 5000L;
    private Thread serverThread;
    private Connection connection;
    private String datadir;

    public void setDatabase(String name) {
        if (name == null) {
            name = DEFAULT_DATABASE_NAME;
        }
        this.name = name;
    }

    public String getDatabase() {
        return this.name;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String address) {
        this.address = address;
    }

    public String getBindAddress() {
        return this.address;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean getSilent() {
        return this.silent;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setNo_system_exit(boolean no_system_exit) {
        this.no_system_exit = no_system_exit;
    }

    public boolean getNo_system_exit() {
        return this.no_system_exit;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    public boolean getPersist() {
        return this.persist;
    }

    public String getDatabasePath() {
        if (this.dbPath != null) {
            return this.dbPath.toString();
        }
        return null;
    }

    public boolean isInProcessMode() {
        return this.inProcessMode;
    }

    public String getShutdownCommand() {
        return this.shutdownCommand;
    }

    public void setInProcessMode(boolean b) {
        this.inProcessMode = b;
    }

    public void setShutdownCommand(String string) {
        this.shutdownCommand = string;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        if (password == null) {
            password = DEFAULT_PASSWORD;
        }
        this.password = password;
    }

    public void setUser(String user) {
        if (user == null) {
            user = DEFAULT_USER;
        }
        this.user = user;
    }

    public String getDatabaseManagerClass() {
        return this.databaseManagerClass;
    }

    public void setDatabaseManagerClass(String databaseManagerClass) {
        if (databaseManagerClass == null) {
            databaseManagerClass = DEFAULT_DATABASE_MANAGER_CLASS;
        }
        this.databaseManagerClass = databaseManagerClass;
    }

    public String getServerClass() {
        return this.serverClass;
    }

    public void setServerClass(String serverClass) {
        if (serverClass == null) {
            serverClass = DEFAULT_SERVER_CLASS;
        }
        this.serverClass = serverClass;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void startDatabaseManager() {
        new Thread(){

            public void run() {
                try {
                    String connectHost = HypersonicDatabase.DEFAULT_ADDRESS.equals(HypersonicDatabase.this.address) ? "localhost" : HypersonicDatabase.this.address;
                    String driver = HypersonicDatabase.JDBC_DRIVER_CLASS;
                    String[] args = !HypersonicDatabase.this.inProcessMode ? new String[]{"-noexit", "-driver", driver, "-url", "jdbc:hsqldb:hsql://" + connectHost + ":" + HypersonicDatabase.this.port, "-user", HypersonicDatabase.this.user, "-password", HypersonicDatabase.this.password, "-dir", HypersonicDatabase.this.getDatabasePath()} : (HypersonicDatabase.IN_MEMORY_DATABASE.equals(HypersonicDatabase.this.name) ? new String[]{"-noexit", "-driver", driver, "-url", "jdbc:hsqldb:.", "-user", HypersonicDatabase.this.user, "-password", HypersonicDatabase.this.password} : new String[]{"-noexit", "-driver", driver, "-url", HypersonicDatabase.JDBC_URL_PREFIX + HypersonicDatabase.this.getDatabasePath(), "-user", HypersonicDatabase.this.user, "-password", HypersonicDatabase.this.password, "-dir", HypersonicDatabase.this.getDatabasePath()});
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(HypersonicDatabase.this.databaseManagerClass, true, cl);
                    Method main = clazz.getMethod("main", args.getClass());
                    main.invoke(null, new Object[]{args});
                }
                catch (HeadlessException e) {
                    HypersonicDatabase.this.log.error((Object)"Failed to start database manager because this is an headless configuration (no display, mouse or keyword)");
                }
                catch (Exception e) {
                    HypersonicDatabase.this.log.error((Object)"Failed to start database manager", (Throwable)e);
                }
            }
        }.start();
    }

    protected void startService() throws Exception {
        if (!this.persist) {
            this.inProcessMode = true;
            this.name = IN_MEMORY_DATABASE;
        }
        if (!this.inProcessMode) {
            this.startRemoteDatabase();
        } else if (IN_MEMORY_DATABASE.equals(this.name)) {
            this.startInMemoryDatabase();
        } else {
            this.startStandaloneDatabase();
        }
    }

    protected void stopService() throws Exception {
        if (!this.inProcessMode) {
            this.stopRemoteDatabase();
        } else if (IN_MEMORY_DATABASE.equals(this.name)) {
            this.stopInMemoryDatabase();
        } else {
            this.stopStandaloneDatabase();
        }
    }

    private void startStandaloneDatabase() throws Exception {
        File hypersonicDir = this.checkDataDir();
        this.dbPath = new File(hypersonicDir, this.name);
        String dbURL = JDBC_URL_PREFIX + this.getDatabasePath();
        this.connection = this.getConnection(dbURL);
    }

    private void startInMemoryDatabase() throws Exception {
        String dbURL = "jdbc:hsqldb:.";
        this.connection = this.getConnection(dbURL);
    }

    private void startRemoteDatabase() throws Exception {
        File hypersonicDir = this.checkDataDir();
        this.dbPath = new File(hypersonicDir, this.name);
        this.serverThread = new Thread("hypersonic-" + this.name){

            public void run() {
                try {
                    String[] args = new String[]{"-database", HypersonicDatabase.this.dbPath.getAbsolutePath(), "-port", String.valueOf(HypersonicDatabase.this.port), "-address", HypersonicDatabase.this.address, "-silent", String.valueOf(HypersonicDatabase.this.silent), "-trace", String.valueOf(HypersonicDatabase.this.trace), "-no_system_exit", String.valueOf(HypersonicDatabase.this.no_system_exit)};
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(HypersonicDatabase.this.serverClass, true, cl);
                    Method main = clazz.getMethod("main", args.getClass());
                    main.invoke(null, new Object[]{args});
                }
                catch (Exception e) {
                    HypersonicDatabase.this.log.error((Object)"Failed to start database", (Throwable)e);
                }
            }
        };
        this.serverThread.start();
        if (this.delay > 0L) {
            this.log.debug((Object)("Waiting for Database initialisation: maximum " + this.delay + " milliseconds"));
            try {
                this.serverThread.join(this.delay);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            if (this.serverThread.isAlive()) {
                this.log.warn((Object)"Database initialisation is still active");
            } else {
                this.log.debug((Object)"Database initialisation completed");
            }
        }
    }

    private void stopStandaloneDatabase() throws Exception {
        String dbURL = JDBC_URL_PREFIX + this.getDatabasePath();
        Connection connection = this.getConnection(dbURL);
        Statement statement = connection.createStatement();
        String shutdownCommand = this.shutdownCommand;
        if (shutdownCommand == null) {
            shutdownCommand = "SHUTDOWN COMPACT";
        }
        statement.executeQuery(shutdownCommand);
        this.connection = null;
        this.log.info((Object)"Database standalone closed clean");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInMemoryDatabase() throws Exception {
        String dbURL = "jdbc:hsqldb:.";
        Connection connection = this.getConnection(dbURL);
        Statement statement = connection.createStatement();
        String shutdownCommand = this.shutdownCommand;
        if (shutdownCommand == null) {
            shutdownCommand = DEFAULT_IN_MEMORY_SHUTDOWN_COMMAND;
        }
        try {
            try {
                statement.executeQuery(shutdownCommand);
            }
            finally {
                statement.close();
            }
        }
        finally {
            this.connection = null;
        }
        this.log.info((Object)"Database in memory closed clean");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRemoteDatabase() throws Exception {
        String connectHost = DEFAULT_ADDRESS.equals(this.address) ? "localhost" : this.address;
        String dbURL = "jdbc:hsqldb:hsql://" + connectHost + ":" + this.port;
        Connection connection = this.getConnection(dbURL);
        Statement statement = connection.createStatement();
        String shutdownCommand = this.shutdownCommand;
        if (shutdownCommand == null) {
            shutdownCommand = "SHUTDOWN COMPACT";
        }
        try {
            try {
                statement.executeQuery(shutdownCommand);
            }
            finally {
                statement.close();
            }
        }
        finally {
            this.serverThread = null;
            this.connection = null;
        }
        this.log.info((Object)"Database remote closed clean");
    }

    private synchronized Connection getConnection(String dbURL) throws Exception {
        if (this.connection == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class.forName(JDBC_DRIVER_CLASS, true, cl).newInstance();
            this.connection = DriverManager.getConnection(dbURL, this.user, this.password);
        }
        return this.connection;
    }

    private File checkDataDir() throws IOException {
        File dataDir = this.getDataDir();
        File hypersonicDir = new File(dataDir, HYPERSONIC_DATA_DIR);
        if (!hypersonicDir.exists()) {
            hypersonicDir.mkdirs();
        } else if (!hypersonicDir.isDirectory()) {
            throw new IOException("Failed to create directory: " + hypersonicDir);
        }
        return hypersonicDir;
    }

    File getDataDir() {
        if (this.datadir == null) {
            ServerConfig serverConfig = (ServerConfig)MBeanProxyExt.create(ServerConfig.class, (ObjectName)ServerConfigImplMBean.OBJECT_NAME);
            return serverConfig.getServerDataDir();
        }
        return new File(this.datadir);
    }

    public void setDataDir(String datadir) {
        this.datadir = datadir;
    }
}

