/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.message.format.xml.SerializedValueImpl;
import org.jboss.internal.soa.esb.message.format.xml.XMLUtil;
import org.jboss.internal.soa.esb.util.stax.ElementContent;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.internal.soa.esb.util.stax.TextElement;
import org.jboss.soa.esb.message.Attachment;

public class AttachmentImpl
extends ElementContent
implements Attachment {
    private ArrayList<SerializedValueImpl> _list = new ArrayList();
    private HashMap<String, SerializedValueImpl> _table = new HashMap();

    public AttachmentImpl() {
    }

    public AttachmentImpl(XMLStreamReader in) throws XMLStreamException {
        this.parse(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name) {
        HashMap<String, SerializedValueImpl> hashMap = this._table;
        synchronized (hashMap) {
            return this.unwrap(this._table.get(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(String name, Object value) {
        this.assertValidAttachment(value);
        HashMap<String, SerializedValueImpl> hashMap = this._table;
        synchronized (hashMap) {
            return this.unwrap(this._table.put(name, new SerializedValueImpl((Serializable)value)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        HashMap<String, SerializedValueImpl> hashMap = this._table;
        synchronized (hashMap) {
            return this.unwrap(this._table.remove(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNames() {
        HashMap<String, SerializedValueImpl> hashMap = this._table;
        synchronized (hashMap) {
            return this._table.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object itemAt(int index) throws IndexOutOfBoundsException {
        ArrayList<SerializedValueImpl> arrayList = this._list;
        synchronized (arrayList) {
            return this.unwrap(this._list.get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeItemAt(int index) throws IndexOutOfBoundsException {
        ArrayList<SerializedValueImpl> arrayList = this._list;
        synchronized (arrayList) {
            return this.unwrap(this._list.remove(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object replaceItemAt(int index, Object value) throws IndexOutOfBoundsException {
        this.assertValidAttachment(value);
        ArrayList<SerializedValueImpl> arrayList = this._list;
        synchronized (arrayList) {
            return this.unwrap(this._list.set(index, new SerializedValueImpl((Serializable)value)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Object value) {
        this.assertValidAttachment(value);
        ArrayList<SerializedValueImpl> arrayList = this._list;
        synchronized (arrayList) {
            this._list.add(new SerializedValueImpl((Serializable)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemAt(int index, Object value) throws IndexOutOfBoundsException {
        this.assertValidAttachment(value);
        ArrayList<SerializedValueImpl> arrayList = this._list;
        synchronized (arrayList) {
            this._list.add(index, new SerializedValueImpl((Serializable)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNamedCount() {
        HashMap<String, SerializedValueImpl> hashMap = this._table;
        synchronized (hashMap) {
            return this._table.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnnamedCount() {
        ArrayList<SerializedValueImpl> arrayList = this._list;
        synchronized (arrayList) {
            return this._list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String listVal;
        String tableVal;
        HashMap<String, SerializedValueImpl> hashMap = this._table;
        synchronized (hashMap) {
            tableVal = this._table.toString();
        }
        ArrayList<SerializedValueImpl> arrayList = this._list;
        synchronized (arrayList) {
            listVal = this._list.toString();
        }
        return "attachments: [ Named:" + tableVal + ", Unnamed:" + listVal + " ]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeChildContent(XMLStreamWriter out) throws XMLStreamException {
        Cloneable cloneable = this._list;
        synchronized (cloneable) {
            for (SerializedValueImpl serializedValueImpl : this._list) {
                TextElement unnamed = new TextElement(serializedValueImpl.getSerialisedForm());
                StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_ATTACHMENT_UNNAMED, unnamed);
            }
        }
        cloneable = this._table;
        synchronized (cloneable) {
            for (Map.Entry entry : this._table.entrySet()) {
                TextElement named = new TextElement(((SerializedValueImpl)entry.getValue()).getSerialisedForm());
                String origNamedURI = StreamHelper.writeStartElement(out, XMLUtil.ESB_QNAME_ATTACHMENT_NAMED);
                StreamHelper.writeAttribute(out, XMLUtil.ESB_QNAME_ATTRIBUTE_ATTACHMENT_NAMED_NAME, (String)entry.getKey());
                named.writeContent(out);
                StreamHelper.writeEndElement(out, XMLUtil.ESB_QNAME_ATTACHMENT_NAMED.getPrefix(), origNamedURI);
            }
        }
    }

    protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
        if (XMLUtil.ESB_QNAME_ATTACHMENT_UNNAMED.equals(elementName)) {
            TextElement unnamed = new TextElement(in);
            SerializedValueImpl value = new SerializedValueImpl(unnamed.getText());
            this._list.add(value);
        } else if (XMLUtil.ESB_QNAME_ATTACHMENT_NAMED.equals(elementName)) {
            String name = StreamHelper.getAttributeValue(in, XMLUtil.ESB_QNAME_ATTRIBUTE_ATTACHMENT_NAMED_NAME);
            TextElement valueElement = new TextElement(in);
            SerializedValueImpl value = new SerializedValueImpl(valueElement.getText());
            this._table.put(name, value);
        } else {
            throw new XMLStreamException("Unexpected element name: " + elementName);
        }
    }

    private void assertValidAttachment(Object attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("Cannot set null object as a message attachment.  Attachment objects must be non-null and Serializable.");
        }
        if (!(attachment instanceof Serializable)) {
            throw new IllegalArgumentException("Cannot set an Object of type '" + attachment.getClass().getName() + "' as a message attachment.  Attachment objects must be Serializable.");
        }
    }

    private Object unwrap(SerializedValueImpl value) {
        return value == null ? null : value.getValue();
    }
}

