/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters.xstream.conf;

import com.thoughtworks.xstream.converters.Converter;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.util.ClassUtil;

public class ConverterConf {
    private Converter converter;
    private int priority = -1;

    public ConverterConf(String converterClassName, String priority) {
        AssertArgument.isNotNullAndNotEmpty(converterClassName, "converterClassName");
        this.converter = this.initialize(converterClassName);
        if (priority != null) {
            this.priority = Integer.parseInt(priority);
        }
    }

    public Converter getConverter() {
        return this.converter;
    }

    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        return "ConverterConf [converter=" + this.converter + ", priority=" + this.priority + "]";
    }

    private Converter initialize(String className) {
        try {
            Class converterClass = ClassUtil.forName(className, this.getClass());
            Object newInstance = converterClass.newInstance();
            if (newInstance instanceof Converter) {
                return (Converter)newInstance;
            }
            throw new IllegalStateException("Converter '" + className + " does not implement '" + Converter.class.getName() + "'");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class '" + className + "'", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not load class '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not load class '" + className + "'", e);
        }
    }
}

