/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Initializable;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.schedule.SchedulingException;
import org.jboss.soa.esb.util.ClassUtil;

public interface ScheduledEventMessageComposer
extends Initializable {
    public Message composeMessage() throws SchedulingException;

    public Message onProcessingComplete(Message var1) throws SchedulingException;

    public static class Factory {
        public static ScheduledEventMessageComposer createInstance(String className) throws ConfigurationException {
            AssertArgument.isNotNullAndNotEmpty(className, "className");
            try {
                return (ScheduledEventMessageComposer)ClassUtil.forName(className, Factory.class).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Composer class [" + className + "] not found in classpath.", e);
            }
            catch (InstantiationException e) {
                throw new ConfigurationException("Failed to instantiate composer class [" + className + "].", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to instantiate composer class [" + className + "].", e);
            }
        }
    }
}

