/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers120;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers120.FsListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers120.FtpListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers120.GroovyListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers120.HibernateListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers120.HttpGatewayMapper;
import org.jboss.soa.esb.listeners.config.mappers120.JbrListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers120.JcaGatewayMapper;
import org.jboss.soa.esb.listeners.config.mappers120.JmsListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers120.ScheduleMapper;
import org.jboss.soa.esb.listeners.config.mappers120.SqlListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers120.UdpListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers120.UntypedListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers120.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.AbstractScheduledListener;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.DualListener;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.FsListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.FtpListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.GroovyListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.HibernateListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.HttpGatewayDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.JbrListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.JcaGatewayDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.JmsListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.ServiceDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.SqlListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.UdpListenerDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GatewayGenerator {
    private static final Logger logger = Logger.getLogger(GatewayGenerator.class);
    private XMLBeansModel model;

    public GatewayGenerator(XMLBeansModel model) {
        this.model = model;
    }

    public Document generate() throws ConfigurationException {
        Document doc = YADOMUtil.createDocument();
        doc.appendChild(doc.createComment("\n\tNOTE: DO NOT MODIFY\n\tThis file was auto-generated.\n"));
        Element root = YADOMUtil.addElement(doc, "jbossesb-gateways");
        root.setAttribute("parameterReloadSecs", this.model.getParameterReloadSecs());
        List<ServiceDocument.Service> services = this.model.getServices();
        HashMap<String, HashMap> hm = new HashMap<String, HashMap>();
        for (ServiceDocument.Service service : services) {
            HashMap hc;
            if (hm.containsKey(service.getCategory())) {
                hc = (HashMap)hm.get(service.getCategory());
                if (hc.containsKey(service.getName())) {
                    throw new ConfigurationException("Service names must be unique within a category.  The service name " + service.getName() + " is already defined within the " + service.getCategory() + " category.");
                }
                hc.put(service.getName(), service.getName());
                continue;
            }
            hc = new HashMap();
            hc.put(service.getName(), service.getName());
            hm.put(service.getCategory(), hc);
        }
        List<Listener> gateways = this.model.getGatewayListeners();
        for (Listener gateway : gateways) {
            this.addGatewayConfig(root, gateway);
        }
        return doc;
    }

    private void addGatewayConfig(Element root, Listener gateway) throws ConfigurationException {
        Element listenerConfig;
        if (gateway instanceof JmsListenerDocument.JmsListener) {
            listenerConfig = JmsListenerMapper.map(root, (JmsListenerDocument.JmsListener)gateway, this.model);
        } else if (gateway instanceof FsListenerDocument.FsListener) {
            listenerConfig = FsListenerMapper.map(root, (FsListenerDocument.FsListener)gateway, this.model);
        } else if (gateway instanceof JcaGatewayDocument.JcaGateway) {
            listenerConfig = JcaGatewayMapper.map(root, (JcaGatewayDocument.JcaGateway)gateway, this.model);
        } else if (gateway instanceof FtpListenerDocument.FtpListener) {
            listenerConfig = FtpListenerMapper.map(root, (FtpListenerDocument.FtpListener)gateway, this.model);
        } else if (gateway instanceof SqlListenerDocument.SqlListener) {
            listenerConfig = SqlListenerMapper.map(root, (SqlListenerDocument.SqlListener)gateway, this.model);
        } else if (gateway instanceof JbrListenerDocument.JbrListener) {
            listenerConfig = JbrListenerMapper.map(root, (JbrListenerDocument.JbrListener)gateway, this.model);
        } else if (gateway instanceof HttpGatewayDocument.HttpGateway) {
            listenerConfig = HttpGatewayMapper.map(root, (HttpGatewayDocument.HttpGateway)gateway, this.model);
        } else if (gateway instanceof GroovyListenerDocument.GroovyListener) {
            listenerConfig = GroovyListenerMapper.map(root, (GroovyListenerDocument.GroovyListener)gateway, this.model);
        } else if (gateway instanceof HibernateListenerDocument.HibernateListener) {
            listenerConfig = HibernateListenerMapper.map(root, (HibernateListenerDocument.HibernateListener)gateway, this.model);
        } else if (gateway instanceof UdpListenerDocument.UdpListener) {
            listenerConfig = UdpListenerMapper.map(root, (UdpListenerDocument.UdpListener)gateway, this.model);
        } else if (gateway instanceof DualListener) {
            listenerConfig = UntypedListenerMapper.map(root, (DualListener)gateway, this.model);
        } else {
            throw new ConfigurationException("Unexpected gateway type encountered: " + gateway);
        }
        if (gateway instanceof AbstractScheduledListener) {
            ScheduleMapper.map(listenerConfig, (AbstractScheduledListener)gateway, this.model);
        }
    }
}

