/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.format.MessageType;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotificationTarget;
import org.jboss.soa.esb.notification.NotifyUtil;

public class NotifyTcp
extends NotificationTarget {
    private Logger log = Logger.getLogger(NotifyTcp.class);
    public static final String DESTINATIONS_TAG = "destination";
    public static final String ATT_URI = "URI";
    public static final String PROTOCOL_TAG = "tcp";
    public static final int DEFAULT_PORT = 9090;
    private URI[] _destinations = null;
    private MessagePayloadProxy payloadProxy;
    private Logger _logger = Logger.getLogger(NotifyTcp.class);

    public NotifyTcp(ConfigTree configTree) {
        super(configTree);
        this.setDestinations(configTree.getChildren(DESTINATIONS_TAG));
        this.payloadProxy = new MessagePayloadProxy(configTree, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Message message) throws NotificationException {
        StringBuilder exceptions = new StringBuilder();
        for (URI destination : this._destinations) {
            Socket sender = null;
            try {
                int port = destination.getPort();
                if (port == -1) {
                    port = 9090;
                    this._logger.debug((Object)("No port specified for " + destination + " so will use default " + 9090));
                }
                sender = new Socket(destination.getHost(), port);
                if (MessageType.JAVA_SERIALIZED.equals(message.getType())) {
                    this.objectNotification(new ObjectOutputStream(sender.getOutputStream()), this.payloadProxy.getPayload(message));
                    continue;
                }
                Object obj = this.payloadProxy.getPayload(message);
                String content = null;
                content = obj instanceof byte[] ? new String((byte[])obj) : obj.toString();
                this.stringNotification(sender.getOutputStream(), content);
            }
            catch (IOException e) {
                this.handleException(destination, e, exceptions);
            }
            catch (MessageDeliverException e) {
                this.handleException(destination, e, exceptions);
            }
            finally {
                try {
                    if (sender != null) {
                        sender.close();
                    }
                }
                catch (IOException eCl) {
                    this.log.error((Object)"IOException while closing socket: ", (Throwable)eCl);
                }
            }
        }
        if (exceptions.length() > 0) {
            throw new NotificationException(exceptions.toString());
        }
    }

    private void handleException(URI destination, Exception e, StringBuilder exceptions) {
        String msg = "[Exception while notifying destination : " + destination;
        this.log.error((Object)msg, (Throwable)e);
        exceptions.append(NotifyUtil.createExceptionErrorString(msg, e));
    }

    protected void stringNotification(OutputStream sender, String p_s) throws IOException {
        sender.write(p_s.getBytes());
        if (!p_s.endsWith("\n")) {
            sender.write("\n".getBytes());
        }
        sender.flush();
        sender.close();
    }

    protected void objectNotification(ObjectOutputStream sender, Object p_o) throws IOException {
        sender.writeObject(p_o);
        sender.flush();
        sender.close();
    }

    private void setDestinations(ConfigTree[] dests) {
        if (dests != null) {
            this._destinations = new URI[dests.length];
            for (int i = 0; i < dests.length; ++i) {
                try {
                    this._destinations[i] = new URI(dests[i].getAttribute(ATT_URI));
                    if (this._destinations[i].getScheme().equals(PROTOCOL_TAG)) continue;
                    throw new IllegalArgumentException("Destination is not a tcp socket! " + this._destinations[i]);
                }
                catch (URISyntaxException ex) {
                    this._logger.warn((Object)"Could not create notify destination: ", (Throwable)ex);
                    throw new IllegalArgumentException("Could not create notify destination", ex);
                }
                catch (Exception ex) {
                    this._logger.warn((Object)"Problem creating notify destination: ", (Throwable)ex);
                    throw new IllegalArgumentException("Problem creating notify destination", ex);
                }
            }
        }
    }
}

