/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.schedule;

import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.schedule.SchedulerJobListener;
import org.jboss.soa.esb.schedule.SchedulerResource;
import org.jboss.soa.esb.schedule.SchedulingException;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SimpleTrigger;
import org.quartz.StatefulJob;
import org.quartz.Trigger;

public class SchedulerJob {
    private static Logger LOGGER = Logger.getLogger(SchedulerJob.class);
    private static final String JOB_GROUP = "ESBScheduler";
    private static final String JOB_NAME = "ESBJob";
    private static long jobCounter;
    private final String name;
    private final JobDetail jobDetail;
    private final Trigger trigger;
    private final Properties properties;

    private SchedulerJob(String name, SchedulerJobListener listener, Trigger trigger, Properties properties) {
        this.name = name;
        this.jobDetail = new JobDetail(trigger.getName(), JOB_GROUP, ESBScheduledJob.class);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)SchedulerJobListener.class.getName(), (Object)listener);
        jobDataMap.put((Object)ClassLoader.class.getName(), (Object)Thread.currentThread().getContextClassLoader());
        this.jobDetail.setJobDataMap(jobDataMap);
        this.trigger = trigger;
        this.properties = properties;
    }

    public void start() throws SchedulingException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Starting SchedulerJob " + this.getName()));
        }
        SchedulerResource.getSchedulerResource().start(this.trigger, this.jobDetail, this.properties);
    }

    public void pause() throws SchedulingException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Pausing SchedulerJob " + this.getName()));
        }
        SchedulerResource.getSchedulerResource().pause(this.trigger);
    }

    public void destroy() throws SchedulingException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Destroying SchedulerJob " + this.getName()));
        }
        SchedulerResource.getSchedulerResource().destroy(this.trigger);
    }

    private String getName() {
        if (this.name != null) {
            return this.name + '/' + this.trigger.getName();
        }
        return this.trigger.getName();
    }

    public static SchedulerJob createIntervalSchedulerJob(String name, SchedulerJobListener listener, long interval, Properties properties) {
        SimpleTrigger trigger = new SimpleTrigger(SchedulerJob.getJobName(), JOB_GROUP, SimpleTrigger.REPEAT_INDEFINITELY, interval);
        trigger.setMisfireInstruction(2);
        return new SchedulerJob(name, listener, (Trigger)trigger, properties);
    }

    public static SchedulerJob createIntervalSchedulerJob(String name, SchedulerJobListener listener, long interval, Date startDate, Date endDate, Properties properties) {
        SimpleTrigger trigger = new SimpleTrigger(SchedulerJob.getJobName(), JOB_GROUP, SimpleTrigger.REPEAT_INDEFINITELY, interval);
        trigger.setMisfireInstruction(2);
        if (startDate != null) {
            trigger.setStartTime(startDate);
        }
        if (endDate != null) {
            trigger.setEndTime(endDate);
        }
        return new SchedulerJob(name, listener, (Trigger)trigger, properties);
    }

    public static SchedulerJob createIntervalSchedulerJob(String name, SchedulerJobListener listener, long interval, int execCount, Date startDate, Date endDate, Properties properties) {
        SimpleTrigger trigger = new SimpleTrigger(SchedulerJob.getJobName(), JOB_GROUP, execCount - 1, interval);
        trigger.setMisfireInstruction(2);
        if (startDate != null) {
            trigger.setStartTime(startDate);
        }
        if (endDate != null) {
            trigger.setEndTime(endDate);
        }
        return new SchedulerJob(name, listener, (Trigger)trigger, properties);
    }

    public static SchedulerJob createCronSchedulerJob(String name, SchedulerJobListener listener, String cronExpression, Date startDate, Date endDate, Properties properties) throws ParseException {
        CronTrigger trigger = new CronTrigger(SchedulerJob.getJobName(), JOB_GROUP, cronExpression);
        trigger.setMisfireInstruction(1);
        if (startDate != null) {
            trigger.setStartTime(startDate);
        }
        if (endDate != null) {
            trigger.setEndTime(endDate);
        }
        return new SchedulerJob(name, listener, (Trigger)trigger, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getJobName() {
        Class<SchedulerJob> clazz = SchedulerJob.class;
        synchronized (SchedulerJob.class) {
            long id = ++jobCounter;
            // ** MonitorExit[var2] (shouldn't be in output)
            return JOB_NAME + id;
        }
    }

    public static class ESBScheduledJob
    implements StatefulJob {
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
            SchedulerJobListener listener = (SchedulerJobListener)jobDataMap.get((Object)SchedulerJobListener.class.getName());
            ClassLoader tcc = (ClassLoader)jobDataMap.get((Object)ClassLoader.class.getName());
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(tcc);
            try {
                listener.onSchedule();
            }
            catch (SchedulingException se) {
                JobExecutionException jobException = new JobExecutionException("Scheduling exception on " + jobExecutionContext.getTrigger().getName());
                jobException.initCause((Throwable)se);
                throw jobException;
            }
            catch (Throwable th) {
                JobExecutionException jobException = new JobExecutionException("Unexpected exception on " + jobExecutionContext.getTrigger().getName());
                jobException.initCause(th);
                throw jobException;
            }
            finally {
                thread.setContextClassLoader(currentClassLoader);
            }
        }
    }
}

