/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XPathUtil {
    private static Logger log = Logger.getLogger(XPathUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(String xml) throws SAXException, IOException, ParserConfigurationException {
        Document document;
        if (xml == null) {
            throw new IllegalArgumentException("xml must not be null");
        }
        ByteArrayInputStream inputStream = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            document = documentBuilder.parse(inputStream);
        }
        catch (Throwable throwable) {
            XPathUtil.close(inputStream);
            throw throwable;
        }
        XPathUtil.close(inputStream);
        return document;
    }

    public static Element getNodeFromXPathExpression(Document document, String xPathExpression) throws XPathExpressionException {
        if (document == null) {
            throw new IllegalArgumentException("document must not be null");
        }
        if (xPathExpression == null) {
            return document.getDocumentElement();
        }
        Node rootNode = (Node)XPathUtil.getQNameFromXPathExpression(document, xPathExpression, XPathConstants.NODE);
        return (Element)rootNode;
    }

    public static Element getNodeFromXPathExpression(String xml, String xPathExpression) throws XPathExpressionException, SAXException, IOException, ParserConfigurationException {
        return XPathUtil.getNodeFromXPathExpression(XPathUtil.getDocument(xml), xPathExpression);
    }

    private static Object getQNameFromXPathExpression(Document document, String xPathExpression, QName type) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expression = xpath.compile(xPathExpression);
        return expression.evaluate(document.getDocumentElement(), type);
    }

    private static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Error when closing IOStream", (Throwable)e);
        }
    }
}

