/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.management;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

/**
 * Test case for Retire process test case
 */
public class RiftSaw238TestCase extends RiftSawTest {

	private static final String TEST_NAME = "RiftSaw_238";
	
	private RiftSawTestSetup firstArtifact;
	
	private RiftSawTestSetup secondArtifact;
	
	public RiftSaw238TestCase() {
		super(TEST_NAME);
	}
	
	public void setUp() throws Exception {
		firstArtifact = new RiftSawTestSetup(RiftSaw238TestCase.class, TEST_NAME, "RiftSaw_238-1.jar");
		secondArtifact = new RiftSawTestSetup(RiftSaw238TestCase.class, TEST_NAME, "RiftSaw_238-2.jar");
	}
	
	public void testSendHello() throws Exception {
		
		firstArtifact.setUp();
		
		synchronized(this) {
			wait(2 * 60 * 1000);
		}
	
		String result=sendSOAPMessage("hello_request1.xml", "http://localhost:8080/RiftSaw_238WS");
		
		result = processResult(result);		
		assertMessageFromFile(result, "hello_response1.xml");
		
		secondArtifact.setUp();
		
		synchronized(this) {
			wait(2 * 60 * 1000);
		}	
		
		secondArtifact.tearDown();
		
		synchronized(this) {
			wait(1 * 60 * 1000);
		}
		
		String result2 = sendSOAPMessage("goodbye_request1.xml", "http://localhost:8080/RiftSaw_238WS");
		result2 = processResult(result2);		
		assertMessageFromFile(result2, "goodbye_response1.xml");				
		
		firstArtifact.tearDown();
		
	}
	
}
