/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.samples;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;

import junit.framework.Test;

/**
 * Test case for running the Quickstart_bpel_secure_service_native sample.
 */
public class QuickstartBPELSecureServiceNativeTestCase extends RiftSawTest {

	private static final String TEST_NAME = "Quickstart_bpel_secure_service_native";
    private static final QName SERVICE_NAME = new QName("http://www.jboss.org/bpel/examples/wsdl", "SecureHelloService");

	public QuickstartBPELSecureServiceNativeTestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		if (System.getProperty("ws.stack","native").equals("native")) {
			return(new RiftSawTestSetup(QuickstartBPELSecureServiceNativeTestCase.class,
						TEST_NAME, "Quickstart_bpel_secure_service_native-1.jar"));
		} else {
			return(new junit.framework.TestSuite());
		}
	}

	public void testSendSecureHello() throws Exception {
        QName portName=new QName("http://www.jboss.org/bpel/examples/wsdl", "SecureHelloPort");
        
		String wsdlpath=System.getProperty("test.dir")+java.io.File.separator+getTestSuiteName()+
				java.io.File.separator+"client"+java.io.File.separator+"HelloWorld.wsdl";

		URL wsdlURL=(new java.io.File(wsdlpath)).toURI().toURL();
		
		System.out.println(">>> WSDL PATH="+wsdlpath);
		System.out.println(">>> WSDL URL="+wsdlURL);
		
	      Service service = Service.create(wsdlURL, SERVICE_NAME);
	      Dispatch<SOAPMessage> dispatcher = service.createDispatch(
	          portName,
	          SOAPMessage.class,
	          Service.Mode.MESSAGE
	      );
       
			String filename=System.getProperty("test.dir")+java.io.File.separator+getTestSuiteName()+
					java.io.File.separator+"client"+java.io.File.separator+"jboss-wsse-client.xml";
		      
			URL configFile = (new java.io.File(filename)).toURI().toURL();
			
			System.out.println("Web Stack initialization file: name="+filename+" file="+configFile);

			if (dispatcher instanceof org.jboss.ws.core.jaxws.client.DispatchImpl) {
				((org.jboss.ws.core.jaxws.client.DispatchImpl<?>)dispatcher).setSecurityConfig(configFile.toExternalForm());
				((org.jboss.ws.core.jaxws.client.DispatchImpl<?>)dispatcher).setConfigName("Standard WSSecurity Client");
			}

	      MessageFactory factory = MessageFactory.newInstance();
	      
	      String str=getMessage("hello_request1.xml");
	      
	      java.io.InputStream is=new java.io.ByteArrayInputStream(str.getBytes());
	      
	      SOAPMessage soapReq1 = factory.createMessage(null, is);
        
	        System.out.println("Invoking server through Dispatch interface using SOAPMessage");
	        SOAPMessage soapResp = dispatcher.invoke(soapReq1);
	        System.out.println("Response from server: " + soapResp.getSOAPBody().getFirstChild().getNodeName());

			//result = processResult(result);
			
			//assertMessageFromFile(result, "hello_response1.xml");
	}
}
