/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2009
 */
package org.jboss.soa.esb.message;

import org.jboss.remoting.transport.http.HTTPMetadataConstants;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.http.HttpConfiguration;
import org.jboss.soa.esb.listeners.gateway.HttpMessageComposer;

/**
 * Utility class for use by SOAPClient, SOAPProducer, SOAPProxy and HttpRouter. The default is
 * now that these actions will set the http response status back into the Message Properties,
 * which will then get returned in the http response of a synchronous invocation of the
 * &lt;jbr-provider/&gt; ({@link org.jboss.soa.esb.listeners.gateway.JBossRemotingGatewayListener JBossRemotingGatewayListener}) or &lt;http-provider/&gt; ({@link org.jboss.soa.esb.listeners.gateway.HttpGatewayListener HttpGatewayListener}).<p/>
 *
 * If you want the legacy behavior, you can override this at an action level (META-INF/jboss-esb.xml):<br/>
 * &lt;action name="..." class="..."&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;property name="http.responseStatusEnabled" value="false"/&gt;<br/>
 * &lt;/action&gt;<p/>
 *
 * or at a global level (jbossesb-properties.xml):<br/>
 * &lt;esb&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;properties name="transports"&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;property name="org.jboss.soa.esb.http.responseStatusEnabled" value="false"/&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/properties&gt;<br/>
 * &lt;/esb&gt;
 *
 * @author dward at jboss.org
 */
@SuppressWarnings("deprecation")
public class ResponseStatus
{

	private ResponseStatus() {}

	// JBESB-2761
	public static boolean isHttpEnabled(ConfigTree actionConfig) {
		return actionConfig.getBooleanAttribute(
				"http.responseStatusEnabled", HttpConfiguration.isResponseStatusEnabled() );
	}

	// JBESB-2761
	public static void setHttpProperties(Properties properties, int statusCode, String statusMessage) {
		if (statusCode > 0) {
			properties.setProperty(HTTPMetadataConstants.RESPONSE_CODE, statusCode); // <jbr-provider/>
			properties.setProperty(HttpMessageComposer.HTTP_RESPONSE_STATUS, statusCode); // <http-provider/>
			properties.setProperty(org.jboss.soa.esb.listeners.gateway.http.HttpMessageComposer.HTTP_RESPONSE_STATUS, statusCode); // <http-gateway/>
		}
		if (statusMessage != null) {
			properties.setProperty(HTTPMetadataConstants.RESPONSE_CODE_MESSAGE, statusMessage); // <jbr-provider/>
			// unnecessary to set status message for <http-provider/>
		}
	}

}
