package org.jboss.soa.esb.actions;

import java.io.IOException;

import org.jboss.soa.esb.actions.annotation.Process;
import org.jboss.soa.esb.message.Message;

/**
 * Action which sniffs messages to verify them later in unit tests.
 */
public class MessageSpyAction {
	private static Message message;

	public static void cleanup() {
		message = null;
	}

	@Process
	public Message process(final Message message) {
		try {
			MessageSpyAction.message = message.copy();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return message;
	}

	public static Message getMessage() {
		return message;
	}
}
