/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jbpm.ant;

import static org.junit.Assert.*;

import org.apache.tools.ant.BuildException;
import org.junit.Before;
import org.junit.Test;

/**
 * Unit test for {@link DeployProcessToServerTask}
 * <p/>
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 * 
 */
public class DeployProcessToServerTaskUnitTest
{
	private DeployProcessToServerTask task;
	
	private final String userName = "testuser";
	private final String password = "testpasswd";
	
	@Test ( expected = BuildException.class )
	public void showThrowIfPasswordIsNotSet()
	{
		task.setUsername( userName );
		task.verifySecurityProperties();
		
	}
	
	@Test ( expected = BuildException.class )
	public void showThrowIfUserNameIsNotSet()
	{
		task.setPassword( password );
		task.verifySecurityProperties();
	}
	
	@Test
	public void noSecurityPropeties()
	{
		boolean useSecurity = task.verifySecurityProperties();
		assertFalse ( useSecurity );
	}
	
	@Test
	public void emptyStringsSecurityPropeties()
	{
		task.setUsername( "" );
		task.setPassword( "" );
		boolean useSecurity = task.verifySecurityProperties();
		assertFalse ( useSecurity );
	}
	
	//	lifecycle 
	
	@Before
	public void setup()
	{
		task = new DeployProcessToServerTask();
	}
		
}
