/*
 * JBoss, Home of Professinal Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.workitem.esb;

import java.util.Map;
import java.util.Map.Entry;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

public class ESBServiceWorkItemHandler implements WorkItemHandler {
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        Message message = MessageFactory.getInstance().getMessage();
        Body body = message.getBody();
        body.add("");

        Map<String,Object> parameters = (Map<String,Object>)workItem.getParameters();
        if (parameters != null) {
            for (Map.Entry<String,Object> entry : parameters.entrySet()) {
                body.add((String)entry.getKey(), entry.getValue());
            }
        }
        String category = (String)workItem.getParameter("ServiceCategory");
        String service = (String)workItem.getParameter("ServiceName");
        try {
            System.setProperty("javax.xml.registry.ConnectionFactoryClass","org.apache.ws.scout.registry.ConnectionFactoryImpl");

            ServiceInvoker invoker = new ServiceInvoker(category, service);
            invoker.deliverAsync(message);
            manager.completeWorkItem(workItem.getId(), null);
        } catch (MessageDeliverException e) {
            e.printStackTrace();
            manager.abortWorkItem(workItem.getId());
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}
