/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.soap;

import java.net.URL;
import java.util.Set;

import javax.management.ObjectName;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;

import org.jboss.soa.esb.actions.soap.adapter.JBossWSFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;

/**
 * Holds reusable utilities and constants needed by SOAP services.
 * 
 * @author <a href="mageshbk@jboss.com">Magesh Kumar B</a>
 */
public class WebServiceUtils
{
    public static final String JBOSSWS_CONTEXT = "jbossws-context";
    public static final String JBOSSWS_ENDPOINT = "jbossws-endpoint";

    /**
     * Get the Service Endpoint based on the endpoint's short name.
     * An optional Deployment Context name can also be specified for uniqueness.
     *
     * @param endpointName Service Endpoint name.
     * @param contextName Service's Deployment Context name.
     * @return The service endpoint, or null if the endpoint is not found.
     */
    public static Endpoint getServiceEndpoint(String endpointName, String contextName) {
        SPIProvider spiProv = SPIProviderResolver.getInstance().getProvider();
        EndpointRegistryFactory factory =  spiProv.getSPI(EndpointRegistryFactory.class);
        EndpointRegistry registry = factory.getEndpointRegistry();
        Set<ObjectName> objectNames = registry.getEndpoints();

        for (ObjectName objectName : objectNames) {
            String context = objectName.getKeyProperty(Endpoint.SEPID_PROPERTY_CONTEXT);
            String endpoint = objectName.getKeyProperty(Endpoint.SEPID_PROPERTY_ENDPOINT);

            if ((contextName != null
                && context != null && context.equals(contextName)
                && endpoint != null && endpoint.equals(endpointName))
                || (contextName == null
                    && endpoint != null && endpoint.equals(endpointName))) {
                return registry.getEndpoint(objectName);
            }
        }
        return null;
    }

    /**
     * Get the Service Endpoint based on the endpoint's deployment name.
     *
     * @param endpointName The deployment name.
     * @return The service endpoint, or null if the endpoint is not found.
     */
    public static Endpoint getDeploymentEndpoint(String endpointName) {
        SPIProvider spiProv = SPIProviderResolver.getInstance().getProvider();
        EndpointRegistryFactory factory =  spiProv.getSPI(EndpointRegistryFactory.class);
        EndpointRegistry registry = factory.getEndpointRegistry();
        Set<ObjectName> objectNames = registry.getEndpoints();

        for (ObjectName objectName : objectNames) {
            if (objectName.toString().equals(endpointName)) {
                return registry.getEndpoint(objectName);
            }
        }
        return null;
    }

    /**
     * Parse and create wsdl4j Definition from a given WSDL URL.
     *
     * @param wsdlURL The URL to WSDL.
     * @return If found, the wsdl4j Definition.
     */
    public static Definition readWSDL(URL wsdlURL) throws WSDLException
    {
        return JBossWSFactory.getFactory().readWSDL(wsdlURL) ;
    }
}