/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.runtime;

/**
 *  @author Kurt T Stam <kurt.stam@jboss.com>
 */

public class ClassUtil {
    @SuppressWarnings("unchecked")
	public static Class forName(String name, Class caller)
    	throws ClassNotFoundException
    {
	    ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
	    if (threadClassLoader != null) {
	        try {
	            return Class.forName(name, true, threadClassLoader) ;
	        } catch (ClassNotFoundException cnfe) {
	        	if (cnfe.getException() != null) {
	        		throw cnfe;
	        	}
	        }
	    }
    
	    ClassLoader callerClassLoader = caller.getClassLoader();
	    if (callerClassLoader != null) {
	        try {
	            return Class.forName(name, true, callerClassLoader) ;
	        } catch (final ClassNotFoundException cnfe) {
	            if (cnfe.getException() != null) {
	                throw cnfe ;
	            }
	        }
	    }
	    
	    return Class.forName(name, true, ClassLoader.getSystemClassLoader()) ;
    }
}
