/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Document;
import org.jboss.soa.dsp.ServiceEndpointReference;

/**
 * References webservice endpoint deployment properties.
 *  
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public final class ODEServiceEndpointReference extends ServiceEndpointReference implements EndpointReference
{
  public ODEServiceEndpointReference(String endpointId, java.net.URL location, String deploymentName,
		  				String archiveLocation)
  {
	  super(endpointId, location, deploymentName, archiveLocation);
  }

  public Document toXML() {
    Document ret=null;

    try {
      ret = javax.xml.parsers.DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

      org.w3c.dom.Element elem=ret.createElementNS(Namespaces.SOAP_NS, "address");
      elem.setAttribute("location", getServiceUrl().toExternalForm());
      elem.setAttribute("endpointId", getEndpointId());
      elem.setAttribute("deploymentName", getDeploymentName());

      ret.appendChild(elem);
    } catch(Exception e) {
      e.printStackTrace();
    }

    return(ret);
  }

  public static ODEServiceEndpointReference toODE(ServiceEndpointReference ref) {
	  if (ref == null) {
		  return(null);
	  } else if (ref instanceof ODEServiceEndpointReference) {
		  return((ODEServiceEndpointReference)ref);
	  } else {
		  return(new ODEServiceEndpointReference(ref.getEndpointId(), 
				  ref.getServiceUrl(), ref.getDeploymentName(), ref.getArchiveLocation()));
	  }
  }
}
