
package org.jboss.soa.bpel.examples.jaxws;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;


public final class JAXWSDispatcherClient {

    private static final QName SERVICE_NAME = new QName("http://www.jboss.org/bpel/examples/wsdl", "SecureHelloService");

    private JAXWSDispatcherClient() {
    }

    public static void main(String args[]) throws Exception {
        URL wsdlURL = null;
        
        if (args.length != 2) {
        	System.err.println("Usage: JAXWSDispatcherClient wsdlURL messageFile");
        	System.exit(1);
        }
        
        File wsdlFile = new File(args[0]);
        try {
            if (wsdlFile.exists()) {
                wsdlURL = wsdlFile.toURI().toURL();
            } else {
                wsdlURL = new URL(args[0]);
            }
        } catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(2);
        }
      
        QName portName=new QName("http://www.jboss.org/bpel/examples/wsdl", "SecureHelloPort");
        
        
	      Service service = Service.create(wsdlURL, SERVICE_NAME);
	      Dispatch<SOAPMessage> dispatcher = service.createDispatch(
	          portName,
	          SOAPMessage.class,
	          Service.Mode.MESSAGE
	      );
       
			String filename="jboss-wsse-client.xml";
		      
			URL configFile = ClassLoader.getSystemResource(filename);
			
			System.out.println("Web Stack initialization file: name="+filename+" file="+configFile);

			if (dispatcher instanceof org.jboss.ws.core.jaxws.client.DispatchImpl) {
				((org.jboss.ws.core.jaxws.client.DispatchImpl)dispatcher).setSecurityConfig(configFile.toExternalForm());
				((org.jboss.ws.core.jaxws.client.DispatchImpl)dispatcher).setConfigName("Standard WSSecurity Client");
			}

	      MessageFactory factory = MessageFactory.newInstance();
	      
	      String str="<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wsdl=\"http://www.jboss.org/bpel/examples/wsdl\">"+
	      		"<soapenv:Header/><soapenv:Body><wsdl:hello><TestPart>Hello</TestPart></wsdl:hello></soapenv:Body></soapenv:Envelope>";
	      java.io.InputStream is=new java.io.ByteArrayInputStream(str.getBytes());
	      
	      SOAPMessage soapReq1 = factory.createMessage(null, is);
        
	        System.out.println("Invoking server through Dispatch interface using SOAPMessage");
	        SOAPMessage soapResp = dispatcher.invoke(soapReq1);
	        System.out.println("Response from server: " + soapResp.getSOAPBody().getFirstChild().getNodeName());
	        
        System.exit(0);
    }

}
