<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" doctype-system="http://hibernate.sourceforge.net/hibernate-configuration-3.0.dtd" doctype-public="-//Hibernate/Hibernate Configuration DTD 3.0//EN" />

    <!-- Comment out memory cache (part 1 of 2) -->
    <xsl:template match="hibernate-configuration/session-factory/property[@name='hibernate.cache.provider_class']">
        <xsl:text disable-output-escaping="yes">&lt;!-- Memory cache (begin) ===
    </xsl:text>
            <xsl:copy>
                <xsl:apply-templates select="@*|node()" />
            </xsl:copy>
        <xsl:text disable-output-escaping="yes">
    ==== Memory cache (end) --&gt;</xsl:text>
    </xsl:template>

    <xsl:template match="comment()" priority="1" >
        <xsl:choose>
            <!-- Comment out memory cache (part 2 of 2) -->
            <xsl:when test="contains(current(), 'Memory cache (begin)')" >
            </xsl:when>
            <xsl:when test="contains(current(), 'Memory cache (end)')" >
            </xsl:when>

            <!-- Uncomment clustered cache -->
            <xsl:when test="contains(current(), 'Clustered cache (begin) ===')" >
                <xsl:comment> Clustered cache (begin) </xsl:comment>
                    <xsl:value-of select="substring-before(substring-after(.,'==='),'====')" disable-output-escaping="yes" />
                <xsl:comment> Clustered cache (end) </xsl:comment>
                <!-- SOA-3084 Use MVCC locking scheme for jBPM -->
                <xsl:element name="property">
                    <xsl:attribute name="name">hibernate.cache.region.jbc2.cfg.entity</xsl:attribute>
                    <xsl:text>mvcc-entity</xsl:text>
                </xsl:element>
                <xsl:element name="property">
                    <xsl:attribute name="name">hibernate.cache.region.jbc2.cfg.query</xsl:attribute>
                    <xsl:text>local-query</xsl:text>
                </xsl:element>
            </xsl:when>

            <xsl:otherwise>
                <xsl:copy-of select="current()" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Replace "nonstrict-read-write" with "transactional" -->
    <xsl:template match="@usage[parent::class-cache]|@usage[parent::collection-cache]" >
        <xsl:attribute name='usage' >
            <xsl:text>transactional</xsl:text>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="*|@*|node()" >
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
