/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.classes.CharacterStream;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheIOException;
import com.intersys.objects.Streams;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public class CacheWriter
extends Writer
implements Serializable {
    private CharacterStream mStream;
    private Boolean mStreamIOSupported = null;

    public CacheWriter(CharacterStream characterStream) {
        this.mStream = characterStream;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        this.write(cArray2);
    }

    public void write(char[] cArray) throws IOException {
        try {
            if (this.isStreamIOSupported()) {
                String string = Streams.getOref(this.mStream);
                JBindDatabase jBindDatabase = (JBindDatabase)this.mStream.getDatabase();
                jBindDatabase.sendCharacterStream(string, new CharArrayReader(cArray), cArray.length);
            } else {
                this.mStream._write(new String(cArray));
            }
        }
        catch (CacheException cacheException) {
            throw new CacheIOException(cacheException);
        }
    }

    private boolean isStreamIOSupported() throws IOException {
        if (this.mStreamIOSupported == null) {
            if (this.mStream == null) {
                return false;
            }
            this.mStreamIOSupported = Streams.isStreamIOSupported(this.mStream);
        }
        return this.mStreamIOSupported;
    }

    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray);
    }

    public void flush() throws IOException {
        try {
            this.mStream._flush();
        }
        catch (CacheException cacheException) {
            throw new CacheIOException(cacheException);
        }
    }

    public void rewind() throws CacheException {
        this.mStream._rewind();
    }

    public void close() throws IOException {
        this.flush();
        try {
            this.rewind();
        }
        catch (CacheException cacheException) {
            throw new IOException(cacheException.toString());
        }
    }
}

