/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.DBAdapter;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.StreamHelper;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import java.io.InputStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

class CustomMsgDBAdapter
extends JDBCAdapter
implements DBAdapter {
    private static final int TYPE_LIT = 4;
    private static final int TYPE_VOID = -1;
    private static final int TYPE_OBJ = 0;
    private static final int TYPE_LVC = 12;
    private final boolean mDebugServer;
    private double mVersion;
    static final double mVersionStable = 2.09;
    static final double mVersionNewProt = 3.02;
    static final double mVersionNoOid = 3.02;
    static final double mVersionWithOid = 2.16;
    boolean mNewServer = false;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final byte[] MSG_INIT_DB = new byte[]{66, 48};
    private static final byte[] MSG_DESTROY_DB = new byte[]{66, 49};
    private static final byte[] MSG_INC_REF_CNT = new byte[]{66, 53};
    private static final byte[] MSG_DEC_REF_CNT = new byte[]{66, 54};
    private static final byte[] MSG_RUN_FUNC = new byte[]{66, 55};
    private static final byte[] MSG_RUN_PROC = new byte[]{66, 56};
    private static final byte[] MSG_OPEN_OBJ = new byte[]{66, 57};
    private static final byte[] MSG_OPENID_OBJ = new byte[]{66, 71};
    private static final byte[] MSG_DEL_OBJ = new byte[]{66, 65};
    private static final byte[] MSG_TRANSACTION = new byte[]{66, 66};
    private static final byte[] MSG_INIT_P_LST = new byte[]{66, 67};
    private static final byte[] MSG_INIT_P_ARR = new byte[]{66, 68};
    private static final byte[] MSG_INIT_O_LST = new byte[]{66, 69};
    private static final byte[] MSG_INIT_O_ARR = new byte[]{66, 70};
    private static final byte[] MSG_GET_PROP = new byte[]{66, 72};
    private static final byte[] MSG_SET_PROP = new byte[]{66, 73};
    private static final byte[] MSG_DEC_STATUS = new byte[]{66, 74};
    private static final byte[] MSG_SYNC = new byte[]{66, 77};
    private static final byte[] MSG_GET_P_LST = new byte[]{77, 49};
    private static final byte[] MSG_GET_P_ARR = new byte[]{77, 50};
    private static final byte[] MSG_GET_O_LST = new byte[]{77, 51};
    private static final byte[] MSG_GET_O_ARR = new byte[]{77, 52};
    private static final byte[] MSG_PUT_P_LST = new byte[]{77, 53};
    private static final byte[] MSG_PUT_P_ARR = new byte[]{77, 54};
    private static final byte[] MSG_PUT_O_LST = new byte[]{77, 55};
    private static final byte[] MSG_PUT_O_ARR = new byte[]{77, 56};
    private static final byte[] MSG_BULK_LOAD = new byte[]{77, 57};
    private static final byte[] MSG_LOAD_RO_ID = new byte[]{76, 73};
    private static final byte[] MSG_LOAD_RO_OID = new byte[]{76, 79};
    private static final byte[] MSG_LOAD_RO_Q = new byte[]{76, 81};
    private static final byte[] MSG_LOAD_RO_EX = new byte[]{76, 69};
    private static final byte[] MSG_EXP_DDL = new byte[]{69, 68};
    private static final byte[] MSG_GET_ZOBJVAL = new byte[]{77, 90};

    public CustomMsgDBAdapter(Connection connection) throws CacheException {
        super(connection);
        this.mDebugServer = true;
        this.mConnectionInfo = this.myConnection().getConnectionInfo();
        if (this.myConnection().getProtocolVersion() < 32) {
            this.mVersion = 2.16;
            this.mNewServer = false;
        } else {
            this.mVersion = 3.02;
            this.mNewServer = true;
        }
    }

    public boolean isNewServer() {
        return this.mNewServer;
    }

    public final double getVersion() {
        return this.mVersion;
    }

    public Connection getConnection() {
        return this.mConnection;
    }

    private CacheConnection myConnection() throws CacheServerException {
        try {
            return (CacheConnection)this.mConnection;
        }
        catch (ClassCastException classCastException) {
            throw new CacheServerException(classCastException, "Unrecognized JDBC driver");
        }
    }

    public CallableStatement prepareCall(String string) throws CacheServerException {
        return CustomMsgDBAdapter.prepareCall(this.mConnection, string);
    }

    public Statement createStatement() throws CacheException {
        try {
            return this.mConnection.createStatement();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to create SQL statement.");
        }
    }

    public PreparedStatement prepareStatement(String string) throws CacheServerException {
        try {
            return this.mConnection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, CustomMsgDBAdapter.sqlErrorText("Failed to prepare SQL statement: " + string, sQLException));
        }
    }

    public byte[] initDb(boolean bl, int n) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setDouble(object, this.mVersion + 0.001);
            SysListProxy.setInteger(object, n);
            SysListProxy.setBoolean(object, true);
            SysListProxy.setBoolean(object, this.mDebugServer);
            return this.sendCustomMessage(MSG_INIT_DB, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to initialize database connection");
        }
    }

    public byte[] destroyDb(boolean bl, int n, byte[] byArray) throws CacheServerException {
        try {
            return this.sendCustomMessage(MSG_DESTROY_DB, byArray);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to close database connection");
        }
    }

    public byte[] runMethod(int n, String string, String string2, int[] nArray, Dataholder[] dataholderArray, boolean bl, byte[] byArray, boolean bl2, int n2) throws CacheException {
        byte[] byArray2 = bl ? MSG_RUN_FUNC : MSG_RUN_PROC;
        try {
            Object object = SysListProxy.createSysList(byArray, false, this.mConnectionInfo);
            SysListProxy.skipAll(object);
            SysListProxy.setInteger(object, n);
            SysListProxy.setString(object, string);
            SysListProxy.setString(object, string2);
            switch (n2) {
                case 1: {
                    CustomMsgDBAdapter.stuffArgs1(object, dataholderArray, nArray, bl2);
                    break;
                }
                case 2: {
                    CustomMsgDBAdapter.stuffArgs2(object, dataholderArray, nArray, bl2, bl);
                    break;
                }
                default: {
                    throw new SystemError("Uknown protocol for arguments: " + n2);
                }
            }
            return this.sendCustomMessage(byArray2, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to run method " + string2 + " on object <" + string + ">." + n);
        }
    }

    public byte[] runMethodRO(String string, String string2, int[] nArray, Dataholder[] dataholderArray, boolean bl) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setDouble(object, this.mVersion + 0.001);
            SysListProxy.setBoolean(object, true);
            SysListProxy.setBoolean(object, this.mDebugServer);
            SysListProxy.setInteger(object, -1);
            SysListProxy.setString(object, string);
            SysListProxy.setString(object, string2);
            CustomMsgDBAdapter.stuffArgs2(object, dataholderArray, nArray, bl, true);
            return this.sendCustomMessage(MSG_LOAD_RO_EX, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to run class method " + string2 + " on class " + string);
        }
    }

    private static void stuffArgs1(Object object, Dataholder[] dataholderArray, int[] nArray, boolean bl) throws SQLException, CacheException {
        int n;
        int n2;
        SysListProxy.setBoolean(object, bl);
        SysListProxy.setInteger(object, dataholderArray.length);
        for (n2 = 0; n2 < dataholderArray.length; ++n2) {
            dataholderArray[n2].stuff(object);
        }
        SysListProxy.setInteger(object, nArray.length);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            SysListProxy.setInteger(object, nArray[n2]);
        }
        n2 = 0;
        for (n = 0; n < dataholderArray.length; ++n) {
            if (dataholderArray[n].getType() != 512 && dataholderArray[n].getType() != 1026) continue;
            ++n2;
        }
        SysListProxy.setInteger(object, n2);
        for (n = 0; n < dataholderArray.length; ++n) {
            if (dataholderArray[n].getType() != 512 && dataholderArray[n].getType() != 1026) continue;
            SysListProxy.setInteger(object, n + 1);
        }
    }

    private static void stuffArgs2(Object object, Dataholder[] dataholderArray, int[] nArray, boolean bl, boolean bl2) throws SQLException, CacheException {
        int n;
        int n2 = bl2 ? (bl ? 0 : 4) : -1;
        SysListProxy.setInteger(object, n2);
        SysListProxy.setInteger(object, dataholderArray.length);
        for (n = 0; n < dataholderArray.length; ++n) {
            int n3 = dataholderArray[n].getType() == 512 || dataholderArray[n].getType() == 1026 ? 0 : 4;
            SysListProxy.setInteger(object, n3);
            dataholderArray[n].stuff(object);
        }
        SysListProxy.setInteger(object, nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            SysListProxy.setInteger(object, nArray[n]);
        }
    }

    public byte[] deleteObj(byte[] byArray, int n) throws CacheException {
        if (n < 0) {
            n = 1;
        }
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setByte(object, byArray);
            SysListProxy.setInteger(object, n);
            return this.sendCustomMessage(MSG_DEL_OBJ, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            Oid oid = new Oid(byArray);
            throw new CacheServerException(sQLException, "Failed to delete object of class " + oid.getClass() + " with id " + oid.getId());
        }
    }

    public byte[] openObj(byte[] byArray, int n, int n2, byte[] byArray2) throws CacheException {
        if (n < 0) {
            n = 1;
        }
        try {
            Object object = SysListProxy.createSysList(byArray2, this.mConnectionInfo);
            SysListProxy.skipAll(object);
            SysListProxy.setByte(object, byArray);
            SysListProxy.setInteger(object, n);
            SysListProxy.setInteger(object, n2);
            return this.sendCustomMessage(MSG_OPEN_OBJ, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            Oid oid = new Oid(byArray);
            throw new CacheServerException(sQLException, "Failed to open object of class " + oid.getClassName() + " with id " + oid.getId());
        }
    }

    public byte[] sync(byte[] byArray) throws CacheServerException {
        Object object = SysListProxy.createSysList(byArray, this.mConnectionInfo);
        try {
            return this.sendCustomMessage(MSG_SYNC, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to synchronize with server");
        }
    }

    public byte[] openIdObj(String string, String string2, int n, int n2, byte[] byArray) throws CacheException {
        if (n < 0) {
            n = 1;
        }
        try {
            Object object = SysListProxy.createSysList(byArray, this.mConnectionInfo);
            SysListProxy.skipAll(object);
            SysListProxy.setString(object, string);
            SysListProxy.setString(object, string2);
            SysListProxy.setInteger(object, n);
            SysListProxy.setInteger(object, n2);
            return this.sendCustomMessage(MSG_OPENID_OBJ, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to open object by id of class " + string + " with id " + string2);
        }
    }

    public byte[] getProperty(byte[] byArray, int n, String string, boolean bl) throws CacheException {
        if (byArray == null) {
            throw new SystemError("Data is null!");
        }
        try {
            Object object = SysListProxy.createSysList(byArray, this.mConnectionInfo);
            SysListProxy.skipAll(object);
            SysListProxy.setInteger(object, n);
            SysListProxy.setString(object, string);
            SysListProxy.setBoolean(object, bl);
            return this.sendCustomMessage(MSG_GET_PROP, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to get property " + string + " of oref " + n);
        }
    }

    public byte[] exportDDL(Object object, Object object2, Object object3) throws CacheException {
        Object object4 = SysListProxy.createSysList(this.mConnectionInfo);
        try {
            SysListProxy.setSysList(object4, object);
            SysListProxy.setSysList(object4, object2);
            SysListProxy.setSysList(object4, object3);
            return this.sendCustomMessage(MSG_EXP_DDL, SysListProxy.getBinaryData(object4));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to export DDL. ");
        }
    }

    public byte[] setProperty(byte[] byArray, int n, String string, boolean bl, Dataholder dataholder) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(byArray, this.mConnectionInfo);
            SysListProxy.skipAll(object);
            SysListProxy.setInteger(object, n);
            SysListProxy.setString(object, string);
            SysListProxy.setBoolean(object, bl);
            dataholder.stuff(object);
            return this.sendCustomMessage(MSG_SET_PROP, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to set property " + string + " of oref " + n);
        }
    }

    public void increaseServerReferenceCount(int n) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setInteger(object, n);
            this.sendCustomMessage(MSG_INC_REF_CNT, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to increase reference count for oref " + n);
        }
    }

    public void decreaseServerReferenceCount(int n, int n2) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setInteger(object, n);
            SysListProxy.setInteger(object, n2);
            this.sendCustomMessage(MSG_DEC_REF_CNT, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to decrease reference count for oref " + n + " by " + n2);
        }
    }

    public byte[] getListElements(int n, int n2, int n3) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setInteger(object, n);
            SysListProxy.setInteger(object, n2);
            SysListProxy.setInteger(object, n3);
            return this.sendCustomMessage(MSG_GET_P_LST, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to get elements of list with oref " + n);
        }
    }

    public void putListElements(int n, Collection collection) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setInteger(object, n);
            SysListProxy.setInteger(object, collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Dataholder dataholder = Dataholder.create(iterator.next());
                dataholder.stuff(object);
            }
            this.sendCustomMessage(MSG_PUT_P_LST, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to add elements to list with oref " + n);
        }
    }

    public byte[] putObjListElements(Object object) throws CacheException {
        try {
            return this.sendCustomMessage(MSG_PUT_O_LST, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to add elements to list.");
        }
    }

    public byte[] getArrayElements(int n, String string, int n2, int n3) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setInteger(object, n);
            SysListProxy.setString(object, string);
            SysListProxy.setInteger(object, n2);
            SysListProxy.setInteger(object, n3);
            byte[] byArray = this.sendCustomMessage(MSG_GET_P_ARR, SysListProxy.getBinaryData(object));
            Object object2 = SysListProxy.createSysList(byArray, this.mConnectionInfo);
            return SysListProxy.getByte(object2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to get elements of array with oref " + n);
        }
    }

    public byte[] getObjectListElements(byte[] byArray, int n, int n2, int n3) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(byArray, this.mConnectionInfo);
            SysListProxy.skipAll(object);
            SysListProxy.setInteger(object, n);
            SysListProxy.setInteger(object, n2);
            SysListProxy.setInteger(object, n3);
            return this.sendCustomMessage(MSG_GET_O_LST, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to get elements of list with oref " + n);
        }
    }

    public byte[] getObjectArrayElements(byte[] byArray, int n, String string, int n2, int n3) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(byArray, this.mConnectionInfo);
            SysListProxy.skipAll(object);
            SysListProxy.setInteger(object, n);
            SysListProxy.setString(object, string);
            SysListProxy.setInteger(object, n2);
            SysListProxy.setInteger(object, n3);
            return this.sendCustomMessage(MSG_GET_O_ARR, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to get elements of array with oref " + n);
        }
    }

    public void putArrElements(int n, Map map) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setInteger(object, n);
            SysListProxy.setInteger(object, map.size());
            for (Map.Entry entry : map.entrySet()) {
                Dataholder dataholder = Dataholder.create(entry.getValue());
                dataholder.stuff(object);
                dataholder = Dataholder.create(entry.getKey());
                dataholder.stuff(object);
            }
            this.sendCustomMessage(MSG_PUT_P_ARR, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to put elements into array with oref " + n);
        }
    }

    public byte[] putObjArrElements(Object object) throws CacheException {
        try {
            return this.sendCustomMessage(MSG_PUT_O_ARR, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to add elements to list.");
        }
    }

    public byte[] transactionControl(byte[] byArray, int n) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(byArray, this.mConnectionInfo);
            SysListProxy.skipAll(object);
            SysListProxy.setInteger(object, n);
            return this.sendCustomMessage(MSG_TRANSACTION, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to issue transaction control command");
        }
    }

    public byte[] decomposeStatus(byte[] byArray) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setByte(object, byArray);
            SysListProxy.setString(object, "");
            return this.sendCustomMessage(MSG_DEC_STATUS, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to decompose status");
        }
    }

    public void sendBinaryStream(String string, InputStream inputStream, int n) throws CacheException {
        try {
            StreamHelper.sendBinaryStream(this.myConnection(), string, inputStream, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to write binary stream with oref " + string);
        }
    }

    public void sendCharacterStream(String string, Reader reader, int n) throws CacheException {
        try {
            StreamHelper.sendCharacterStream(this.myConnection(), string, reader, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to write binary stream with oref " + string);
        }
    }

    public byte[] bulkLoad(byte[] byArray, String string, String string2, Object[] objectArray) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(byArray, this.mConnectionInfo);
            SysListProxy.skipAll(object);
            SysListProxy.setString(object, string);
            SysListProxy.setString(object, string2);
            if (objectArray != null) {
                SysListProxy.setInteger(object, objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    SysListProxy.setObject(object, objectArray[i]);
                }
            } else {
                SysListProxy.setInteger(object, 0);
            }
            return this.sendCustomMessage(MSG_BULK_LOAD, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to load objects of class " + string + " by query \"" + string2 + "\"");
        }
    }

    public byte[] bulkLoadRO(String string, String string2, Object[] objectArray) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setString(object, string);
            SysListProxy.setString(object, string2);
            if (objectArray != null) {
                SysListProxy.setInteger(object, objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    SysListProxy.setObject(object, objectArray[i]);
                }
            } else {
                SysListProxy.setInteger(object, 0);
            }
            return this.sendCustomMessage(MSG_LOAD_RO_Q, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to load objects of class " + string + " by query \"" + string2 + "\"");
        }
    }

    public byte[] loadReadOnly(String string, String string2) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setString(object, string);
            SysListProxy.setString(object, string2);
            return this.sendCustomMessage(MSG_LOAD_RO_ID, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to load object of class " + string + " and id = " + string2);
        }
    }

    public byte[] loadReadOnly(String string, byte[] byArray) throws CacheException {
        try {
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setString(object, string);
            SysListProxy.setByte(object, byArray);
            return this.sendCustomMessage(MSG_LOAD_RO_OID, SysListProxy.getBinaryData(object));
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to load object of class " + string + " and oid = " + new Oid(byArray));
        }
    }

    public byte[] getZobjVal(int n) throws CacheException, SQLException {
        Object object = SysListProxy.createSysList(this.mConnectionInfo);
        SysListProxy.setInteger(object, n);
        return this.sendCustomMessage(MSG_GET_ZOBJVAL, SysListProxy.getBinaryData(object));
    }

    public void fillInput(byte[] byArray) throws CacheException {
        throw new SystemError("Server version does not support this call");
    }

    public byte[] getOutput() throws CacheException {
        throw new SystemError("Server version does not support this call");
    }

    public boolean isConnectionClosed() throws CacheServerException {
        if (this.mConnection == null) {
            return true;
        }
        try {
            return this.mConnection.isClosed();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    private byte[] sendCustomMessage(byte[] byArray, byte[] byArray2) throws SQLException, CacheServerException {
        int n = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        byte[] byArray3 = this.myConnection().sendCustomMessage(byArray, byArray2);
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n; ++i) {
            if (!mProfileFlag[i]) continue;
            int n2 = i;
            mNumCallsArray[n2] = mNumCallsArray[n2] + 1;
            int n3 = i;
            mElapsedTimeArray[n3] = mElapsedTimeArray[n3] + (l2 - l);
        }
        if (Logger.logTransactionState()) {
            String string = new String(byArray);
            Object object = SysListProxy.createSysList(this.mConnectionInfo);
            SysListProxy.setInteger(object, 0);
            SysListProxy.setInteger(object, 0);
            SysListProxy.setInteger(object, 0);
            SysListProxy.setInteger(object, 4);
            byte[] byArray4 = this.myConnection().sendCustomMessage(MSG_TRANSACTION, SysListProxy.getBinaryData(object));
            object = SysListProxy.createSysList(byArray4, false, this.mConnectionInfo);
            object = SysListProxy.getSysList(object);
            int n4 = SysListProxy.getInteger(object);
            Logger.out.println("After Message " + string + " $tlevel = " + n4);
        }
        return byArray3;
    }

    private static int oldType2newType(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 3: {
                return -1;
            }
            case 0: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + n);
    }
}

