/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.inject;

import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.InternalContext;
import com.opensymphony.xwork2.inject.InternalFactory;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Scope {
    DEFAULT{

        @Override
        <T> InternalFactory<? extends T> scopeFactory(Class<T> type, String name, InternalFactory<? extends T> factory) {
            return factory;
        }
    }
    ,
    SINGLETON{

        @Override
        <T> InternalFactory<? extends T> scopeFactory(Class<T> type, String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){
                T instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T create(InternalContext context) {
                    Container container = context.getContainer();
                    synchronized (container) {
                        if (this.instance == null) {
                            this.instance = factory.create(context);
                        }
                        return this.instance;
                    }
                }

                public String toString() {
                    return factory.toString();
                }
            };
        }
    }
    ,
    THREAD{

        @Override
        <T> InternalFactory<? extends T> scopeFactory(Class<T> type, String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){
                final ThreadLocal<T> threadLocal = new ThreadLocal();

                @Override
                public T create(InternalContext context) {
                    Object t = this.threadLocal.get();
                    if (t == null) {
                        t = factory.create(context);
                        this.threadLocal.set(t);
                    }
                    return t;
                }

                public String toString() {
                    return factory.toString();
                }
            };
        }
    }
    ,
    REQUEST{

        @Override
        <T> InternalFactory<? extends T> scopeFactory(final Class<T> type, final String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){

                @Override
                public T create(InternalContext context) {
                    Strategy strategy = context.getScopeStrategy();
                    try {
                        return strategy.findInRequest(type, name, this.toCallable(context, factory));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return factory.toString();
                }
            };
        }
    }
    ,
    SESSION{

        @Override
        <T> InternalFactory<? extends T> scopeFactory(final Class<T> type, final String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){

                @Override
                public T create(InternalContext context) {
                    Strategy strategy = context.getScopeStrategy();
                    try {
                        return strategy.findInSession(type, name, this.toCallable(context, factory));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return factory.toString();
                }
            };
        }
    }
    ,
    WIZARD{

        @Override
        <T> InternalFactory<? extends T> scopeFactory(final Class<T> type, final String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){

                @Override
                public T create(InternalContext context) {
                    Strategy strategy = context.getScopeStrategy();
                    try {
                        return strategy.findInWizard(type, name, this.toCallable(context, factory));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return factory.toString();
                }
            };
        }
    };


    <T> Callable<? extends T> toCallable(final InternalContext context, final InternalFactory<? extends T> factory) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                return factory.create(context);
            }
        };
    }

    abstract <T> InternalFactory<? extends T> scopeFactory(Class<T> var1, String var2, InternalFactory<? extends T> var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Strategy {
        public <T> T findInRequest(Class<T> var1, String var2, Callable<? extends T> var3) throws Exception;

        public <T> T findInSession(Class<T> var1, String var2, Callable<? extends T> var3) throws Exception;

        public <T> T findInWizard(Class<T> var1, String var2, Callable<? extends T> var3) throws Exception;
    }
}

