/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

final class Collections {
    private Collections() {
    }

    static <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(Collections.calculateInitialCapacity(expectedSize), 1.0f);
    }

    static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(Collections.calculateInitialCapacity(expectedSize), 1.0f);
    }

    private static int calculateInitialCapacity(int expectedSize) {
        return expectedSize < 3 ? expectedSize + 1 : (expectedSize < 0x40000000 ? expectedSize + expectedSize / 3 : Integer.MAX_VALUE);
    }
}

