/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import org.hibernate.search.backend.QueueingProcessor;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.util.WeakIdentityHashMap;

public class PostTransactionWorkQueueSynchronization
implements Synchronization {
    private QueueingProcessor queueingProcessor;
    private boolean consumed;
    private WeakIdentityHashMap queuePerTransaction;
    private List<Work> queue = new ArrayList<Work>();

    public PostTransactionWorkQueueSynchronization(QueueingProcessor queueingProcessor, WeakIdentityHashMap queuePerTransaction) {
        this.queueingProcessor = queueingProcessor;
        this.queuePerTransaction = queuePerTransaction;
    }

    public void add(Object entity, Serializable id, WorkType workType) {
        this.queueingProcessor.add(entity, id, workType, this.queue);
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int i) {
        try {
            if (3 == i) {
                this.queueingProcessor.performWork(this.queue);
            } else {
                this.queueingProcessor.cancelWork(this.queue);
            }
        }
        finally {
            this.consumed = true;
            if (this.queuePerTransaction != null) {
                this.queuePerTransaction.removeValue(this);
            }
        }
    }
}

