/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jsp;

import com.intersys.jsp.RuntimeEnvironment;
import com.intersys.objects.Database;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class DBHelper {
    public static final String RTENV_ATTRIBUTE = "RTEnvironment";
    public static final String HISTORY_PARAMETER = "history";
    public static final String HISTORY_ATTRIBUTE = "attribute_history";

    public static int getHistoryFromRequest(PageContext pageContext) throws JspException {
        ServletRequest servletRequest = DBHelper.getRequest(pageContext);
        Integer n = (Integer)servletRequest.getAttribute(HISTORY_ATTRIBUTE);
        if (n != null) {
            return n;
        }
        String string = servletRequest.getParameter(HISTORY_PARAMETER);
        if (string == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JspException("Can not get history frame number: \"" + string + "\"");
        }
    }

    protected static void setHistoryInRequest(PageContext pageContext, int n) throws JspException {
        ServletRequest servletRequest = DBHelper.getRequest(pageContext);
        servletRequest.setAttribute(HISTORY_ATTRIBUTE, (Object)new Integer(n));
    }

    public static String getURI(PageContext pageContext) throws JspException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)DBHelper.getRequest(pageContext);
        return httpServletRequest.getRequestURI();
    }

    public static String getURL(PageContext pageContext) throws JspException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)DBHelper.getRequest(pageContext);
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        stringBuffer.append('?');
        stringBuffer.append(httpServletRequest.getQueryString());
        return stringBuffer.toString();
    }

    public static int getHistoryFromSession(PageContext pageContext) throws JspException {
        RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(pageContext);
        return runtimeEnvironment.getHistoryFrame(pageContext);
    }

    public static int getMaxHistoryFromSession(PageContext pageContext) throws JspException {
        RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(pageContext);
        return runtimeEnvironment.getMaxHistoryFrame();
    }

    public static void setHistoryInSession(PageContext pageContext, int n) throws JspException {
        RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(pageContext);
        runtimeEnvironment.setHistoryFrame(n, pageContext);
    }

    public static Database getDBConnectionFromSession(PageContext pageContext) throws JspException {
        RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(pageContext);
        return runtimeEnvironment.getDBConnection();
    }

    public static void setDBConnectionInSession(PageContext pageContext, Database database) throws JspException {
        RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(pageContext);
        runtimeEnvironment.setDBConnection(database);
    }

    public static void removeDBConnectionFromSession(PageContext pageContext) throws JspException {
        HttpSession httpSession = pageContext.getSession();
        if (httpSession != null) {
            httpSession.removeAttribute(RTENV_ATTRIBUTE);
        }
    }

    public static Set getExtraTables(PageContext pageContext, RuntimeEnvironment runtimeEnvironment) throws JspException {
        ServletRequest servletRequest = DBHelper.getRequest(pageContext);
        Enumeration enumeration = servletRequest.getParameterNames();
        HashSet<String> hashSet = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            String string;
            int n;
            String string2;
            String[] stringArray;
            String string3 = (String)enumeration.nextElement();
            int n2 = string3.indexOf(".extratables");
            if (n2 < 0 || ((stringArray = servletRequest.getParameterValues(string2 = string3.substring(0, n2))) == null || stringArray.length == 0) && ((n = string2.lastIndexOf(46)) < 0 || (stringArray = servletRequest.getParameterValues(string = string2.substring(0, n) + ".XName" + string2.substring(n))) == null || stringArray.length == 0)) continue;
            hashSet.add(servletRequest.getParameter(string3));
        }
        return hashSet;
    }

    public static Set getChildTables(PageContext pageContext, RuntimeEnvironment runtimeEnvironment, String string) throws JspException {
        ServletRequest servletRequest = DBHelper.getRequest(pageContext);
        Enumeration enumeration = servletRequest.getParameterNames();
        HashSet<Info> hashSet = new HashSet<Info>();
        while (enumeration.hasMoreElements()) {
            Info info = new Info();
            info.parameter = (String)enumeration.nextElement();
            int n = info.parameter.indexOf(".XName.");
            String string2 = n > 0 ? info.parameter.substring(0, n) : info.parameter;
            info.table = runtimeEnvironment.isChildTable(string, string2);
            if (info.table == null) continue;
            String string3 = info.table;
            if (n > 0) {
                int n2 = n + ".XName".length();
                string3 = info.parameter.substring(0, n) + info.parameter.substring(n2);
            }
            info.column = servletRequest.getParameter(string3 + ".key");
            info.condition = servletRequest.getParameter(string3 + ".condition");
            hashSet.add(info);
        }
        return hashSet;
    }

    public static String createSQLwhere(PageContext pageContext, RuntimeEnvironment runtimeEnvironment, String string, Set set, String string2) throws JspException {
        String string3;
        if (runtimeEnvironment == null) {
            runtimeEnvironment = DBHelper.getRTEnvironment(pageContext);
        }
        ServletRequest servletRequest = DBHelper.getRequest(pageContext);
        Enumeration enumeration = servletRequest.getParameterNames();
        StringBuffer stringBuffer = new StringBuffer();
        if (enumeration == null) {
            return stringBuffer.toString();
        }
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            int n;
            String string4 = (String)enumeration.nextElement();
            string3 = servletRequest.getParameter(string4 + ".expression");
            String string5 = servletRequest.getParameter(string4 + ".expressionin");
            Object object = servletRequest.getParameter(string4 + ".join1");
            String string6 = servletRequest.getParameter(string4 + ".join2");
            String[] stringArray = servletRequest.getParameterValues(string4);
            if (runtimeEnvironment.validateProperty(string, string4)) {
                if (!string4.startsWith(string)) {
                    string4 = string2 + "." + string4;
                }
                bl = DBHelper.appendTableCondition(stringBuffer, string4, stringArray, string3, string5, (String)object, string6, bl);
                continue;
            }
            if (string3 == null && (object == null || string6 == null) || (n = string4.indexOf(46)) < 0 || !runtimeEnvironment.validateProperty(string, string4 = string4.substring(0, n))) continue;
            if (!string4.startsWith(string)) {
                string4 = string2 + "." + string4;
            }
            bl = DBHelper.appendTableCondition(stringBuffer, string4, stringArray, string3, string5, (String)object, string6, bl);
        }
        int n = string.lastIndexOf(46);
        string3 = n > 0 ? string.substring(n + 1) : string;
        for (Object object : set) {
            if (((Info)object).column == null) {
                System.out.println("No column specified for child table " + ((Info)object).table);
                continue;
            }
            if (runtimeEnvironment.validateChildTableProperty(string, ((Info)object).table, ((Info)object).column)) {
                bl = DBHelper.appendChildTableCondition(stringBuffer, servletRequest, string2, string3, (Info)object, bl);
                continue;
            }
            System.out.println("Child table column is not valid: " + ((Info)object).table + ", " + ((Info)object).column);
        }
        return stringBuffer.toString();
    }

    private static boolean appendTableCondition(StringBuffer stringBuffer, String string, String[] stringArray, String string2, String string3, String string4, String string5, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return bl;
        }
        if (!bl) {
            stringBuffer.append("WHERE (");
            bl = true;
        } else {
            stringBuffer.append("AND (");
        }
        if (string4 != null) {
            stringBuffer.append(string + string4 + " AND ( ");
        }
        if (string2 == null && string3 == null) {
            if (string5 != null) {
                stringBuffer.append(string5);
            } else {
                stringBuffer.append(string);
            }
            if (stringArray.length == 1) {
                stringBuffer.append(" = '" + stringArray[0] + "' ");
            } else {
                stringBuffer.append(" IN ( ");
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    stringBuffer.append("'" + stringArray[i] + "', ");
                }
                stringBuffer.append("'" + stringArray[stringArray.length - 1] + "' ) ");
            }
        } else if (string3 == null || string2 != null && stringArray.length == 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("OR ");
                }
                if (string5 != null) {
                    stringBuffer.append(string5 + string2 + "'" + stringArray[i] + "' ");
                    continue;
                }
                stringBuffer.append(string + string2 + "'" + stringArray[i] + "' ");
            }
        } else {
            if (string5 != null) {
                stringBuffer.append(string5);
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(" ");
            stringBuffer.append(string3);
            stringBuffer.append(" ( ");
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append("'" + stringArray[i] + "', ");
            }
            stringBuffer.append("'" + stringArray[stringArray.length - 1] + "' ) ");
        }
        if (string4 != null) {
            stringBuffer.append(") ");
        }
        stringBuffer.append(") ");
        return bl;
    }

    private static boolean appendChildTableCondition(StringBuffer stringBuffer, ServletRequest servletRequest, String string, String string2, Info info, boolean bl) {
        String[] stringArray = servletRequest.getParameterValues(info.parameter);
        if (stringArray.length == 0) {
            return bl;
        }
        if (!bl) {
            stringBuffer.append("WHERE (");
            bl = true;
        } else {
            stringBuffer.append("AND (");
        }
        stringBuffer.append(string + ".ID=" + info.table + '.' + string2);
        if (info.condition != null) {
            stringBuffer.append(" AND " + info.condition);
        }
        stringBuffer.append(" AND (");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("OR ");
            }
            stringBuffer.append(info.table + '.' + info.column + " = '" + stringArray[i] + "' ");
        }
        stringBuffer.append(") ) ");
        return bl;
    }

    protected static String getRequestParameter(PageContext pageContext, String string) throws JspException {
        ServletRequest servletRequest = DBHelper.getRequest(pageContext);
        return servletRequest.getParameter(string);
    }

    private static Object getAttribute(HttpSession httpSession, String string) throws JspException {
        Object object = null;
        try {
            object = httpSession.getAttribute(string);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JspException("IllegalStateException occured: " + illegalStateException.toString(), (Throwable)illegalStateException);
        }
        if (object != null) {
            if (DBHelper.getDebugLevel(httpSession) > 0 && !RTENV_ATTRIBUTE.equals(string)) {
                System.out.println("Returning " + string);
            }
            return object;
        }
        if (DBHelper.getDebugLevel(httpSession) > 0) {
            System.out.println("Returning NULL as " + string);
        }
        return null;
    }

    private static void setAttribute(HttpSession httpSession, String string, Object object) throws JspException {
        try {
            httpSession.setAttribute(string, object);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JspException("IllegalStateException occured: " + illegalStateException.toString(), (Throwable)illegalStateException);
        }
        if (DBHelper.getDebugLevel(httpSession) > 0) {
            System.out.println("Set " + string + " to " + object);
        }
    }

    public static Object retrieveFromSession(PageContext pageContext, String string) throws JspException {
        HttpSession httpSession = DBHelper.getSession(pageContext);
        return DBHelper.getAttribute(httpSession, string);
    }

    public static void storeInSession(PageContext pageContext, String string, Object object) throws JspException {
        HttpSession httpSession = DBHelper.getSession(pageContext);
        DBHelper.setAttribute(httpSession, string, object);
    }

    public static RuntimeEnvironment getRTEnvironment(PageContext pageContext) throws JspException {
        HttpSession httpSession = DBHelper.getSession(pageContext);
        RuntimeEnvironment runtimeEnvironment = (RuntimeEnvironment)DBHelper.getAttribute(httpSession, RTENV_ATTRIBUTE);
        if (runtimeEnvironment == null) {
            runtimeEnvironment = new RuntimeEnvironment(pageContext);
            DBHelper.setAttribute(httpSession, RTENV_ATTRIBUTE, runtimeEnvironment);
        }
        return runtimeEnvironment;
    }

    private static HttpSession getSession(PageContext pageContext) throws JspException {
        if (pageContext == null) {
            if (DBHelper.getDefaultDebugLevel() > 0) {
                System.out.println("Page context is null");
            }
            return null;
        }
        HttpSession httpSession = pageContext.getSession();
        if (httpSession == null) {
            throw new JspException("No HTTP Session is bound");
        }
        return httpSession;
    }

    private static ServletRequest getRequest(PageContext pageContext) throws JspException {
        if (pageContext == null) {
            if (DBHelper.getDefaultDebugLevel() > 0) {
                System.out.println("Page context is null");
            }
            return null;
        }
        ServletRequest servletRequest = pageContext.getRequest();
        if (servletRequest == null) {
            throw new JspException("No Request found in page context");
        }
        return servletRequest;
    }

    public static int getDebugLevel(PageContext pageContext) throws JspException {
        return DBHelper.getDebugLevel(DBHelper.getSession(pageContext));
    }

    public static int getDebugLevel(HttpSession httpSession) {
        return DBHelper.getDefaultDebugLevel();
    }

    public static int getDefaultDebugLevel() {
        return 10;
    }

    protected static class Info {
        String table;
        String parameter;
        String column;
        String condition;

        protected Info() {
        }
    }
}

