/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.AbstractGDS;
import org.firebirdsql.gds.impl.AbstractIscDbHandle;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.AbstractPreparedStatement;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStatementFactory;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.InternalTransactionCoordinator;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBDatabaseMetaData
implements FirebirdDatabaseMetaData {
    private static final Logger log = LoggerFactory.getLogger(FBDatabaseMetaData.class, false);
    private static final String SPACES = "                               ";
    private GDSHelper gdsHelper;
    private AbstractConnection connection;
    HashMap statements = new HashMap();
    private static final String fbSQLKeywords = "ACTIVE,ADMIN,AFTER,ASCENDING,AUTO,BASE_NAME,BEFORE,BIGINT,BLOB,BREAK,CACHE,CHECK_POINT_LENGTH,COMPUTED,CONDITIONAL,CONNECTION_ID,CONTAINING,CSTRING,CURRENT_ROLE,DATABASE,DEBUG,DESCENDING,DO,ENTRY_POINT,EXIT,FILE,FILTER,FREE_IT,FUNCTION,GDSCODE,GENERATOR,GEN_ID,GROUP_COMMIT_WAIT_TIME,IF,INACTIVE,INDEX,INPUT_TYPE,LOGFILE,LOG_BUFFER_SIZE,LONG,MANUAL,MAXIMUM_SEGMENT,MERGE,MESSAGE,MODULE_NAME,NULLS,LOCK,NUM_LOG_BUFFERS,OUTPUT_TYPE,OVERFLOW,PAGE,PAGES,PAGE_SIZE,PARAMETER,PASSWORD,PLAN,POST_EVENT,PROTECTED,RAW_PARTITIONS,RDB$DB_KEY,RECORD_VERSION,RECREATE,RESERV,RESERVING,RETAIN,RETURNING_VALUES,RETURNS,ROLE,ROWS_AFFECTED,SAVEPOINT,SEGMENT,SHADOW,SHARED,SINGULAR,SKIP,SNAPSHOT,SORT,STABILITY,STARTING,STARTS,STATISTICS,SUB_TYPE,SUSPEND,TRANSACTION_ID,TRIGGER,VARIABLE,WAIT,WEEKDAY,WHILE,YEARDAY";
    private static final String GET_PROCEDURES_START = "select  RDB$PROCEDURE_NAME as PROCEDURE_NAME, RDB$DESCRIPTION as REMARKS, RDB$PROCEDURE_OUTPUTS as PROCEDURE_TYPE from RDB$PROCEDURES where ";
    private static final String GET_PROCEDURES_END = "1 = 1 order by 1";
    private static final String GET_PROCEDURE_COLUMNS_START = "select PP.RDB$PROCEDURE_NAME as PROCEDURE_NAME, PP.RDB$PARAMETER_NAME as COLUMN_NAME, PP.RDB$PARAMETER_TYPE as COLUMN_TYPE, F.RDB$FIELD_TYPE as FIELD_TYPE, F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE, F.RDB$FIELD_PRECISION as FIELD_PRECISION, F.RDB$FIELD_SCALE as FIELD_SCALE, F.RDB$FIELD_LENGTH as FIELD_LENGTH, F.RDB$NULL_FLAG as NULL_FLAG, PP.RDB$DESCRIPTION as REMARKS from RDB$PROCEDURE_PARAMETERS PP, RDB$FIELDS F where ";
    private static final String GET_PROCEDURE_COLUMNS_END = " PP.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME order by PP.RDB$PROCEDURE_NAME, PP.RDB$PARAMETER_TYPE desc, PP.RDB$PARAMETER_NUMBER ";
    public static final String TABLE = "TABLE";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String VIEW = "VIEW";
    public static final String[] ALL_TYPES = new String[]{"TABLE", "SYSTEM TABLE", "VIEW"};
    private static final String GET_TABLES_ALL = "select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('SYSTEM TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('VIEW' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$VIEW_SOURCE is not null  order by 3 ";
    private static final String GET_TABLES_EXACT = "select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('SYSTEM TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null and ? = RDB$RELATION_NAME union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null and ? = RDB$RELATION_NAME union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('VIEW' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$VIEW_SOURCE is not null and ? = RDB$RELATION_NAME";
    private static final String GET_TABLES_LIKE = "select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('SYSTEM TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null and RDB$RELATION_NAME || '                               ' like ? escape '\\' union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null and RDB$RELATION_NAME || '                               ' like ? escape '\\' union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('VIEW' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$VIEW_SOURCE is not null and RDB$RELATION_NAME || '                               ' like ? escape '\\'  order by 3 ";
    private static final String GET_COLUMNS_START = "select  RF.RDB$RELATION_NAME as RELATION_NAME, RF.RDB$FIELD_NAME as FIELD_NAME, F.RDB$FIELD_TYPE as FIELD_TYPE, F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE, F.RDB$FIELD_PRECISION as FIELD_PRECISION, F.RDB$FIELD_SCALE as FIELD_SCALE, F.RDB$FIELD_LENGTH as FIELD_LENGTH, F.RDB$CHARACTER_LENGTH as CHAR_LEN, RF.RDB$DESCRIPTION AS REMARKS, RF.RDB$DEFAULT_SOURCE as DEFAULT_SOURCE, RF.RDB$FIELD_POSITION as FIELD_POSITION,  RF.RDB$NULL_FLAG as NULL_FLAG from RDB$RELATION_FIELDS RF, RDB$FIELDS F where ";
    public static final String GET_COLUMNS_END = " RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME order by 1, 11";
    private static final short smallint_type = 7;
    private static final short integer_type = 8;
    private static final short quad_type = 9;
    private static final short float_type = 10;
    private static final short d_float_type = 11;
    private static final short date_type = 12;
    private static final short time_type = 13;
    private static final short char_type = 14;
    private static final short int64_type = 16;
    private static final short double_type = 27;
    private static final short timestamp_type = 35;
    private static final short varchar_type = 37;
    private static final short blob_type = 261;
    private static final String GET_COLUMN_PRIVILEGES_START = "select null as TABLE_CAT,null as TABLE_SCHEM,RF.RDB$RELATION_NAME as TABLE_NAME, RF.RDB$FIELD_NAME as COLUMN_NAME, UP.RDB$GRANTOR as GRANTOR, UP.RDB$USER as GRANTEE, UP.RDB$PRIVILEGE as PRIVILEGE, UP.RDB$GRANT_OPTION as IS_GRANTABLE from RDB$RELATION_FIELDS RF, RDB$FIELDS F, RDB$USER_PRIVILEGES UP where RF.RDB$RELATION_NAME = UP.RDB$RELATION_NAME and RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME  and (UP.RDB$FIELD_NAME is null or UP.RDB$FIELD_NAME = RF.RDB$FIELD_NAME) and UP.RDB$RELATION_NAME = ? and ((";
    private static final String GET_COLUMN_PRIVILEGES_END = " UP.RDB$OBJECT_TYPE = 0) or (RF.RDB$FIELD_NAME is null and UP.RDB$OBJECT_TYPE = 0)) order by 4,7 ";
    private static final String GET_TABLE_PRIVILEGES_START = "select null as TABLE_CAT,  null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, RDB$GRANTOR as GRANTOR,  RDB$USER as GRANTEE,  RDB$PRIVILEGE as PRIVILEGE,  RDB$GRANT_OPTION as IS_GRANTABLE from RDB$USER_PRIVILEGES where ";
    private static final String GET_TABLE_PRIVILEGES_END = " RDB$OBJECT_TYPE = 0 and RDB$FIELD_NAME is null order by 3, 6";
    private static final String GET_BEST_ROW_IDENT = "select     rf.rdb$field_name as column_name,     f.rdb$field_type as field_type,     f.rdb$field_sub_type as field_sub_type,     f.rdb$field_scale as field_scale,     f.rdb$field_precision as field_precision from     rdb$relation_constraints rc,    rdb$index_segments idx,    rdb$relation_fields rf,    rdb$fields f where     rc.rdb$relation_name = ? and     rc.rdb$constraint_type = 'PRIMARY KEY' and     idx.rdb$index_name = rc.rdb$index_name and     rf.rdb$field_name = idx.rdb$field_name and     rf.rdb$relation_name = ? and     f.rdb$field_name = rf.rdb$field_source";
    private static final String GET_PRIMARY_KEYS_START = "select  null as TABLE_CAT,  null as TABLE_SCHEM, RC.RDB$RELATION_NAME as TABLE_NAME, ISGMT.RDB$FIELD_NAME as COLUMN_NAME, CAST ((ISGMT.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ, RC.RDB$CONSTRAINT_NAME as PK_NAME from RDB$RELATION_CONSTRAINTS RC, RDB$INDEX_SEGMENTS ISGMT where ";
    private static final String GET_PRIMARY_KEYS_END = "RC.RDB$INDEX_NAME = ISGMT.RDB$INDEX_NAME and RC.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY' order by ISGMT.RDB$FIELD_NAME ";
    private static final String GET_IMPORTED_KEYS_START = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
    private static final String GET_IMPORTED_KEYS_END = " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  order by 3, 9 ";
    private static final String GET_EXPORTED_KEYS_START = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
    private static final String GET_EXPORTED_KEYS_END = " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  order by 7, 9 ";
    private static final String GET_CROSS_KEYS_START = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
    private static final String GET_CROSS_KEYS_END = " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  order by 7, 9 ";
    private static final String GET_INDEX_INFO_COLUMN_LIST = "  NULL as TABLE_CAT , NULL as TABLE_SCHEM , ind.RDB$RELATION_NAME AS TABLE_NAME , ind.RDB$UNIQUE_FLAG AS NON_UNIQUE , NULL as INDEX_QUALIFIER , ind.RDB$INDEX_NAME as INDEX_NAME , NULL as ITYPE , ise.rdb$field_position+1 as ORDINAL_POSITION , ise.rdb$field_name as COLUMN_NAME , ind.RDB$INDEX_TYPE as ASC_OR_DESC , 0 as CARDINALITY , 0 as IPAGES , null as FILTER_CONDITION ";
    private static final String GET_INDEX_INFO = "SELECT  NULL as TABLE_CAT , NULL as TABLE_SCHEM , ind.RDB$RELATION_NAME AS TABLE_NAME , ind.RDB$UNIQUE_FLAG AS NON_UNIQUE , NULL as INDEX_QUALIFIER , ind.RDB$INDEX_NAME as INDEX_NAME , NULL as ITYPE , ise.rdb$field_position+1 as ORDINAL_POSITION , ise.rdb$field_name as COLUMN_NAME , ind.RDB$INDEX_TYPE as ASC_OR_DESC , 0 as CARDINALITY , 0 as IPAGES , null as FILTER_CONDITION FROM   rdb$indices ind,   rdb$index_segments ise WHERE   ind.rdb$index_name = ise.rdb$index_name AND   ind.rdb$relation_name = ? ORDER BY 4, 6, 8";
    private static final String GET_INDEX_INFO_UPPER = "SELECT  NULL as TABLE_CAT , NULL as TABLE_SCHEM , ind.RDB$RELATION_NAME AS TABLE_NAME , ind.RDB$UNIQUE_FLAG AS NON_UNIQUE , NULL as INDEX_QUALIFIER , ind.RDB$INDEX_NAME as INDEX_NAME , NULL as ITYPE , ise.rdb$field_position+1 as ORDINAL_POSITION , ise.rdb$field_name as COLUMN_NAME , ind.RDB$INDEX_TYPE as ASC_OR_DESC , 0 as CARDINALITY , 0 as IPAGES , null as FILTER_CONDITION FROM   rdb$indices ind,   rdb$index_segments ise WHERE   ind.rdb$index_name = ise.rdb$index_name AND   UPPER(ind.rdb$relation_name) = ? ORDER BY 4, 6, 8";

    FBDatabaseMetaData(GDSHelper gdsHelper) {
        this.gdsHelper = gdsHelper;
    }

    FBDatabaseMetaData(AbstractConnection c) throws GDSException {
        this.gdsHelper = c.getGDSHelper();
        this.connection = c;
    }

    void close() {
        block3: {
            try {
                for (AbstractPreparedStatement stmt : this.statements.values()) {
                    if (stmt.isClosed()) continue;
                    stmt.close();
                }
                this.statements.clear();
            }
            catch (SQLException e) {
                if (log == null) break block3;
                log.warn("error in DatabaseMetaData.close", e);
            }
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public String getURL() throws SQLException {
        AbstractGDS gds = (AbstractGDS)this.connection.getInternalAPIHandler();
        return GDSFactory.getJdbcUrl(gds.getType(), this.connection.mc.getDatabase());
    }

    public String getUserName() throws SQLException {
        return this.gdsHelper.getUserName();
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        if (this.getDatabaseMajorVersion() == 1) {
            return false;
        }
        if (this.getDatabaseMajorVersion() == 2) {
            return false;
        }
        throw new FBDriverNotCapableException();
    }

    public boolean nullsAreSortedLow() throws SQLException {
        if (this.getDatabaseMajorVersion() == 1) {
            return false;
        }
        if (this.getDatabaseMajorVersion() == 2) {
            return true;
        }
        throw new FBDriverNotCapableException();
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        if (this.getDatabaseMajorVersion() == 1) {
            return false;
        }
        if (this.getDatabaseMajorVersion() == 2) {
            return false;
        }
        throw new FBDriverNotCapableException();
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        if (this.getDatabaseMajorVersion() == 1) {
            return true;
        }
        if (this.getDatabaseMajorVersion() == 2) {
            return false;
        }
        throw new FBDriverNotCapableException();
    }

    public String getDatabaseProductName() throws SQLException {
        return this.gdsHelper.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.gdsHelper.getDatabaseProductVersion();
    }

    public String getDriverName() throws SQLException {
        return "Jaybird JCA/JDBC driver";
    }

    public String getDriverVersion() throws SQLException {
        return "2.1";
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 1;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return fbSQLKeywords;
    }

    public String getNumericFunctions() throws SQLException {
        return "";
    }

    public String getStringFunctions() throws SQLException {
        return "SUBSTRING,UCASE,CONCAT";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYOFYEAR,HOUR,MINUTE,MONTH,NOW,SECOND,YEAR";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "$";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return null;
    }

    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    public String getCatalogTerm() throws SQLException {
        return null;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 31;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 31;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 31;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        if (this.getDatabaseMajorVersion() >= 1 && this.getDatabaseMinorVersion() >= 5) {
            return 65531;
        }
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 31;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 31;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 0: {
                return false;
            }
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        Clause procedureClause = new Clause("RDB$PROCEDURE_NAME", procedureNamePattern);
        String sql = GET_PROCEDURES_START;
        sql = sql + procedureClause.getCondition();
        sql = sql + GET_PROCEDURES_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!procedureClause.getCondition().equals("")) {
            params.add(procedureClause.getValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        XSQLVAR[] xsqlvars = new XSQLVAR[8];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PROCEDURE_CAT";
        xsqlvars[0].relname = "RDB$PROCEDURES";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PROCEDURE_SCHEM";
        xsqlvars[1].relname = "RDB$PROCEDURES";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PROCEDURE_NAME";
        xsqlvars[2].relname = "RDB$PROCEDURES";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "FUTURE1";
        xsqlvars[3].relname = "RDB$PROCEDURES";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FUTURE2";
        xsqlvars[4].relname = "RDB$PROCEDURES";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FUTURE3";
        xsqlvars[5].relname = "RDB$PROCEDURES";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 80;
        xsqlvars[6].sqlname = "REMARKS";
        xsqlvars[6].relname = "RDB$PROCEDURES";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "PROCEDURE_TYPE";
        xsqlvars[7].relname = "RDB$PROCEDURES";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            short procedureType;
            byte[][] row = new byte[8][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PROCEDURE_NAME").trim());
            row[3] = null;
            row[4] = null;
            row[5] = null;
            String remarks = rs.getString("REMARKS");
            row[6] = this.getBytes(remarks);
            if (remarks != null && remarks.length() > xsqlvars[6].sqllen) {
                xsqlvars[6].sqllen = remarks.length();
            }
            row[7] = (procedureType = rs.getShort("PROCEDURE_TYPE")) == 0 ? xsqlvars[0].encodeShort((short)1) : xsqlvars[0].encodeShort((short)2);
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        Clause procedureClause = new Clause("PP.RDB$PROCEDURE_NAME", procedureNamePattern);
        Clause columnClause = new Clause("PP.RDB$PARAMETER_NAME", columnNamePattern);
        String sql = GET_PROCEDURE_COLUMNS_START;
        sql = sql + procedureClause.getCondition();
        sql = sql + columnClause.getCondition();
        sql = sql + GET_PROCEDURE_COLUMNS_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!procedureClause.getCondition().equals("")) {
            params.add(procedureClause.getValue());
        }
        if (!columnClause.getCondition().equals("")) {
            params.add(columnClause.getValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        XSQLVAR[] xsqlvars = new XSQLVAR[13];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PROCEDURE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PROCEDURE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PROCEDURE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 500;
        xsqlvars[4].sqlname = "COLUMN_TYPE";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 500;
        xsqlvars[5].sqlname = "DATA_TYPE";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "TYPE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 496;
        xsqlvars[7].sqlname = "PRECISION";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 496;
        xsqlvars[8].sqlname = "LENGTH";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "SCALE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "RADIX";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 500;
        xsqlvars[11].sqlname = "NULLABLE";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 80;
        xsqlvars[12].sqlname = "REMARKS";
        xsqlvars[12].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[13][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PROCEDURE_NAME").trim());
            row[3] = this.getBytes(rs.getString("COLUMN_NAME").trim());
            short columnType = rs.getShort("COLUMN_TYPE");
            row[4] = columnType == 0 ? xsqlvars[0].encodeShort((short)1) : xsqlvars[0].encodeShort((short)4);
            short fieldType = rs.getShort("FIELD_TYPE");
            short fieldSubType = rs.getShort("FIELD_SUB_TYPE");
            short fieldScale = rs.getShort("FIELD_SCALE");
            int dataType = this.getDataType(fieldType, fieldSubType, fieldScale);
            row[5] = xsqlvars[0].encodeShort((short)dataType);
            row[6] = this.getBytes(FBDatabaseMetaData.getDataTypeName(fieldType, fieldSubType, fieldScale));
            row[7] = null;
            row[7] = dataType == 3 || dataType == 2 ? xsqlvars[0].encodeInt(rs.getShort("FIELD_PRECISION")) : xsqlvars[0].encodeInt(rs.getShort("FIELD_LENGTH"));
            row[8] = xsqlvars[0].encodeInt(rs.getShort("FIELD_LENGTH"));
            row[9] = xsqlvars[0].encodeShort((short)(fieldScale * -1));
            row[10] = xsqlvars[0].encodeShort((short)10);
            short nullFlag = rs.getShort("NULL_FLAG");
            row[11] = nullFlag == 1 ? xsqlvars[0].encodeShort((short)0) : xsqlvars[0].encodeShort((short)1);
            String remarks = rs.getString("REMARKS");
            row[12] = this.getBytes(remarks);
            if (remarks != null && remarks.length() > xsqlvars[12].sqllen) {
                xsqlvars[12].sqllen = remarks.length();
            }
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (tableNamePattern == null || "".equals(tableNamePattern)) {
            tableNamePattern = "%";
        }
        this.checkCatalogAndSchema(catalog, schemaPattern);
        if (types == null) {
            types = ALL_TYPES;
        }
        String sql = "";
        ArrayList<String> params = new ArrayList<String>();
        if (this.isAllCondition(tableNamePattern)) {
            sql = GET_TABLES_ALL;
            params.add(this.getWantsSystemTables(types));
            params.add(this.getWantsTables(types));
            params.add(this.getWantsViews(types));
        } else if (this.hasNoWildcards(tableNamePattern)) {
            tableNamePattern = this.stripQuotes(this.stripEscape(tableNamePattern));
            sql = GET_TABLES_EXACT;
            params.add(this.getWantsSystemTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsViews(types));
            params.add(tableNamePattern);
        } else {
            tableNamePattern = this.stripQuotes(tableNamePattern) + SPACES + "%";
            sql = GET_TABLES_LIKE;
            params.add(this.getWantsSystemTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsViews(types));
            params.add(tableNamePattern);
        }
        return this.doQuery(sql, params);
    }

    public ResultSet getSchemas() throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[]{new XSQLVAR()};
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_SCHEM";
        xsqlvars[0].relname = "TABLESCHEMAS";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getCatalogs() throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[]{new XSQLVAR()};
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "TABLECATALOGS";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getTableTypes() throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[]{new XSQLVAR()};
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_TYPE";
        xsqlvars[0].relname = "TABLETYPES";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>(ALL_TYPES.length);
        for (int i = 0; i < ALL_TYPES.length; ++i) {
            rows.add(new byte[][]{this.getBytes(ALL_TYPES[i])});
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        Clause tableClause = new Clause("RF.RDB$RELATION_NAME", tableNamePattern);
        Clause columnClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
        String sql = GET_COLUMNS_START;
        sql = sql + tableClause.getCondition();
        sql = sql + columnClause.getCondition();
        sql = sql + GET_COLUMNS_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getValue());
        }
        if (!columnClause.getCondition().equals("")) {
            params.add(columnClause.getValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        XSQLVAR[] xsqlvars = new XSQLVAR[18];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 500;
        xsqlvars[4].sqlname = "DATA_TYPE";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 449;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "TYPE_NAME";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 496;
        xsqlvars[6].sqlname = "COLUMN_SIZE";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "BUFFER_LENGTH";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 496;
        xsqlvars[8].sqlname = "DECIMAL_DIGITS";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 496;
        xsqlvars[9].sqlname = "NUM_PREC_RADIX";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 496;
        xsqlvars[10].sqlname = "NULLABLE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 449;
        xsqlvars[11].sqllen = 80;
        xsqlvars[11].sqlname = "REMARKS";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 449;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "COLUMN_DEF";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 496;
        xsqlvars[13].sqlname = "SQL_DATA_TYPE";
        xsqlvars[13].relname = "COLUMNINFO";
        xsqlvars[14] = new XSQLVAR();
        xsqlvars[14].sqltype = 496;
        xsqlvars[14].sqlname = "SQL_DATETIME_SUB";
        xsqlvars[14].relname = "COLUMNINFO";
        xsqlvars[15] = new XSQLVAR();
        xsqlvars[15].sqltype = 496;
        xsqlvars[15].sqlname = "CHAR_OCTET_LENGTH";
        xsqlvars[15].relname = "COLUMNINFO";
        xsqlvars[16] = new XSQLVAR();
        xsqlvars[16].sqltype = 496;
        xsqlvars[16].sqlname = "ORDINAL_POSITION";
        xsqlvars[16].relname = "COLUMNINFO";
        xsqlvars[17] = new XSQLVAR();
        xsqlvars[17].sqltype = 448;
        xsqlvars[17].sqllen = 3;
        xsqlvars[17].sqlname = "IS_NULLABLE";
        xsqlvars[17].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            String column_def;
            byte[][] row = new byte[18][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("RELATION_NAME").trim());
            row[3] = this.getBytes(rs.getString("FIELD_NAME").trim());
            short fieldType = rs.getShort("FIELD_TYPE");
            short fieldSubType = rs.getShort("FIELD_SUB_TYPE");
            short fieldScale = rs.getShort("FIELD_SCALE");
            int dataType = this.getDataType(fieldType, fieldSubType, fieldScale);
            row[4] = xsqlvars[0].encodeShort((short)dataType);
            row[5] = this.getBytes(FBDatabaseMetaData.getDataTypeName(fieldType, fieldSubType, fieldScale));
            switch (dataType) {
                case 2: 
                case 3: {
                    row[6] = xsqlvars[0].encodeInt(rs.getShort("FIELD_PRECISION"));
                    row[8] = xsqlvars[0].encodeInt(fieldScale * -1);
                    row[15] = xsqlvars[0].encodeInt(0);
                    break;
                }
                case 1: 
                case 12: {
                    row[6] = xsqlvars[0].encodeInt(rs.getShort("CHAR_LEN"));
                    row[8] = xsqlvars[0].encodeInt(fieldScale * -1);
                    row[15] = xsqlvars[0].encodeInt(rs.getShort("FIELD_LENGTH"));
                    break;
                }
                case 6: {
                    row[6] = xsqlvars[0].encodeInt(7);
                    row[8] = xsqlvars[0].encodeInt(7);
                    row[15] = xsqlvars[0].encodeInt(0);
                    break;
                }
                case 8: {
                    row[6] = xsqlvars[0].encodeInt(15);
                    row[8] = xsqlvars[0].encodeInt(15);
                    row[15] = xsqlvars[0].encodeInt(0);
                    break;
                }
                case 4: {
                    row[6] = xsqlvars[0].encodeInt(10);
                    row[8] = xsqlvars[0].encodeInt(fieldScale * -1);
                    row[15] = xsqlvars[0].encodeInt(0);
                    break;
                }
                case 5: {
                    row[6] = xsqlvars[0].encodeInt(5);
                    row[8] = xsqlvars[0].encodeInt(fieldScale * -1);
                    row[15] = xsqlvars[0].encodeInt(0);
                    break;
                }
                case 91: {
                    row[6] = xsqlvars[0].encodeInt(10);
                    row[8] = xsqlvars[0].encodeInt(fieldScale * -1);
                    row[15] = xsqlvars[0].encodeInt(0);
                    break;
                }
                case 92: {
                    row[6] = xsqlvars[0].encodeInt(8);
                    row[8] = xsqlvars[0].encodeInt(fieldScale * -1);
                    row[15] = xsqlvars[0].encodeInt(0);
                    break;
                }
                case 93: {
                    row[6] = xsqlvars[0].encodeInt(19);
                    row[8] = xsqlvars[0].encodeInt(fieldScale * -1);
                    row[15] = xsqlvars[0].encodeInt(0);
                    break;
                }
                default: {
                    row[6] = xsqlvars[0].encodeInt(0);
                    row[8] = xsqlvars[0].encodeInt(fieldScale * -1);
                    row[15] = xsqlvars[0].encodeInt(0);
                }
            }
            row[7] = xsqlvars[0].encodeShort((short)0);
            row[9] = xsqlvars[0].encodeInt(10);
            short nullFlag = rs.getShort("NULL_FLAG");
            row[10] = nullFlag == 1 ? xsqlvars[0].encodeInt(0) : xsqlvars[0].encodeInt(1);
            String remarks = rs.getString("REMARKS");
            row[11] = this.getBytes(remarks);
            if (remarks != null && remarks.length() > xsqlvars[11].sqllen) {
                xsqlvars[11].sqllen = remarks.length();
            }
            if ((column_def = rs.getString("DEFAULT_SOURCE")) != null) {
                String defaultValue = column_def.trim();
                int defaultPos = defaultValue.toUpperCase().indexOf("DEFAULT");
                if (defaultPos >= 0) {
                    defaultValue = defaultValue.substring(7).trim();
                }
                row[12] = this.getBytes(defaultValue);
            } else {
                row[12] = null;
            }
            row[13] = null;
            row[14] = null;
            row[16] = xsqlvars[0].encodeInt(rs.getShort("FIELD_POSITION") + 1);
            row[17] = nullFlag == 1 ? this.getBytes("NO") : this.getBytes("YES");
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    private int getDataType(short fieldType, short fieldSubType, short fieldScale) {
        if (fieldScale < 0) {
            switch (fieldType) {
                case 7: 
                case 8: 
                case 16: 
                case 27: {
                    if (fieldSubType == 2) {
                        return 3;
                    }
                    return 2;
                }
            }
        }
        switch (fieldType) {
            case 7: {
                if (fieldSubType == 1) {
                    return 2;
                }
                if (fieldSubType == 2) {
                    return 3;
                }
                return 5;
            }
            case 8: {
                if (fieldSubType == 1) {
                    return 2;
                }
                if (fieldSubType == 2) {
                    return 3;
                }
                return 4;
            }
            case 11: 
            case 27: {
                return 8;
            }
            case 10: {
                return 6;
            }
            case 14: {
                return 1;
            }
            case 37: {
                return 12;
            }
            case 35: {
                return 93;
            }
            case 13: {
                return 92;
            }
            case 12: {
                return 91;
            }
            case 16: {
                if (fieldSubType == 1) {
                    return 2;
                }
                if (fieldSubType == 2) {
                    return 3;
                }
                return -5;
            }
            case 261: {
                if (fieldSubType < 0) {
                    return 2004;
                }
                if (fieldSubType == 0) {
                    return -4;
                }
                if (fieldSubType == 1) {
                    return -1;
                }
                return 1111;
            }
            case 9: {
                return 1111;
            }
        }
        return 0;
    }

    static String getDataTypeName(short sqltype, short sqlsubtype, short sqlscale) {
        if (sqlscale < 0) {
            switch (sqltype) {
                case 7: 
                case 8: 
                case 16: 
                case 27: {
                    if (sqlsubtype == 2) {
                        return "DECIMAL";
                    }
                    return "NUMERIC";
                }
            }
        }
        switch (sqltype) {
            case 7: {
                return "SMALLINT";
            }
            case 8: {
                return "INTEGER";
            }
            case 11: 
            case 27: {
                return "DOUBLE PRECISION";
            }
            case 10: {
                return "FLOAT";
            }
            case 14: {
                return "CHAR";
            }
            case 37: {
                return "VARCHAR";
            }
            case 35: {
                return "TIMESTAMP";
            }
            case 13: {
                return "TIME";
            }
            case 12: {
                return "DATE";
            }
            case 16: {
                if (sqlsubtype == 1) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "BIGINT";
            }
            case 261: {
                if (sqlsubtype < 0) {
                    return "BLOB SUB_TYPE <0";
                }
                if (sqlsubtype == 0) {
                    return "BLOB SUB_TYPE 0";
                }
                if (sqlsubtype == 1) {
                    return "BLOB SUB_TYPE 1";
                }
                return "BLOB SUB_TYPE " + sqlsubtype;
            }
            case 9: {
                return "ARRAY";
            }
        }
        return "NULL";
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        Clause columnClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
        String sql = GET_COLUMN_PRIVILEGES_START;
        sql = sql + columnClause.getCondition();
        sql = sql + GET_COLUMN_PRIVILEGES_END;
        ArrayList<String> params = new ArrayList<String>();
        table = this.stripQuotes(this.stripEscape(table));
        params.add(table);
        if (!columnClause.getCondition().equals("")) {
            params.add(columnClause.getValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        XSQLVAR[] xsqlvars = new XSQLVAR[8];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "COLUMNPRIV";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNPRIV";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "COLUMNPRIV";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNPRIV";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "GRANTOR";
        xsqlvars[4].relname = "COLUMNPRIV";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "GRANTEE";
        xsqlvars[5].relname = "COLUMNPRIV";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "PRIVILEGE";
        xsqlvars[6].relname = "COLUMNPRIV";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "IS_GRANTABLE";
        xsqlvars[7].relname = "COLUMNPRIV";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[8][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("TABLE_NAME"));
            row[3] = this.getBytes(rs.getString("COLUMN_NAME"));
            row[4] = this.getBytes(rs.getString("GRANTOR"));
            row[5] = this.getBytes(rs.getString("GRANTEE"));
            String privilege = rs.getString("PRIVILEGE");
            if (privilege.equals("A")) {
                row[6] = this.getBytes("ALL");
            } else if (privilege.equals("S")) {
                row[6] = this.getBytes("SELECT");
            } else if (privilege.equals("D")) {
                row[6] = this.getBytes("DELETE");
            } else if (privilege.equals("I")) {
                row[6] = this.getBytes("INSERT");
            } else if (privilege.equals("U")) {
                row[6] = this.getBytes("UPDATE");
            } else if (privilege.equals("R")) {
                row[6] = this.getBytes("REFERENCE");
            } else if (privilege.equals("M")) {
                row[6] = this.getBytes("MEMBEROF");
            }
            short isGrantable = rs.getShort("IS_GRANTABLE");
            row[7] = isGrantable == 0 ? this.getBytes("NO") : this.getBytes("YES");
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        tableNamePattern = this.stripQuotes(this.stripEscape(tableNamePattern));
        Clause tableClause = new Clause("RDB$RELATION_NAME", tableNamePattern);
        String sql = GET_TABLE_PRIVILEGES_START;
        sql = sql + tableClause.getCondition();
        sql = sql + GET_TABLE_PRIVILEGES_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        XSQLVAR[] xsqlvars = new XSQLVAR[7];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "TABLEPRIV";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "TABLEPRIV";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "TABLEPRIV";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "GRANTOR";
        xsqlvars[3].relname = "TABLEPRIV";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "GRANTEE";
        xsqlvars[4].relname = "TABLEPRIV";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "PRIVILEGE";
        xsqlvars[5].relname = "TABLEPRIV";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "IS_GRANTABLE";
        xsqlvars[6].relname = "TABLEPRIV";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[7][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("TABLE_NAME"));
            row[3] = this.getBytes(rs.getString("GRANTOR"));
            row[4] = this.getBytes(rs.getString("GRANTEE"));
            String privilege = rs.getString("PRIVILEGE");
            if (privilege.equals("A")) {
                row[5] = this.getBytes("ALL");
            } else if (privilege.equals("S")) {
                row[5] = this.getBytes("SELECT");
            } else if (privilege.equals("D")) {
                row[5] = this.getBytes("DELETE");
            } else if (privilege.equals("I")) {
                row[5] = this.getBytes("INSERT");
            } else if (privilege.equals("U")) {
                row[5] = this.getBytes("UPDATE");
            } else if (privilege.equals("R")) {
                row[5] = this.getBytes("REFERENCE");
            } else if (privilege.equals("M")) {
                row[5] = this.getBytes("MEMBEROF");
            }
            short isGrantable = rs.getShort("IS_GRANTABLE");
            row[6] = isGrantable == 0 ? this.getBytes("NO") : this.getBytes("YES");
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[8];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 500;
        xsqlvars[0].sqlname = "SCOPE";
        xsqlvars[0].relname = "ROWIDENTIFIER";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "COLUMN_NAME";
        xsqlvars[1].relname = "ROWIDENTIFIER";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 500;
        xsqlvars[2].sqlname = "DATA_TYPE";
        xsqlvars[2].relname = "ROWIDENTIFIER";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "TYPE_NAME";
        xsqlvars[3].relname = "ROWIDENTIFIER";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 496;
        xsqlvars[4].sqlname = "COLUMN_SIZE";
        xsqlvars[4].relname = "ROWIDENTIFIER";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 496;
        xsqlvars[5].sqlname = "BUFFER_LENGTH";
        xsqlvars[5].relname = "ROWIDENTIFIER";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "DECIMAL_DIGITS";
        xsqlvars[6].relname = "ROWIDENTIFIER";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "PSEUDO_COLUMN";
        xsqlvars[7].relname = "ROWIDENTIFIER";
        ResultSet tables = this.getTables(catalog, schema, table, null);
        if (!tables.next()) {
            return new FBResultSet(xsqlvars, new ArrayList());
        }
        ArrayList rows = this.getPrimaryKeyIdentifier(table, scope, xsqlvars);
        if (rows.size() == 0) {
            byte[][] row = new byte[][]{xsqlvars[0].encodeShort((short)scope), this.getBytes("RDB$DB_KEY"), xsqlvars[0].encodeShort((short)this.getDataType((short)14, (short)0, (short)0)), this.getBytes(FBDatabaseMetaData.getDataTypeName((short)14, (short)0, (short)0)), xsqlvars[0].encodeInt(0), null, xsqlvars[0].encodeShort((short)0), xsqlvars[0].encodeShort((short)2)};
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    private ArrayList getPrimaryKeyIdentifier(String table, int scope, XSQLVAR[] xsqlvars) throws SQLException {
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>(0);
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(table);
        params.add(table);
        ResultSet rs = this.doQuery(GET_BEST_ROW_IDENT, params);
        while (rs.next()) {
            byte[][] row = new byte[][]{xsqlvars[0].encodeShort((short)scope), this.getBytes(rs.getString("COLUMN_NAME").trim()), xsqlvars[0].encodeShort((short)this.getDataType(rs.getShort("FIELD_TYPE"), rs.getShort("FIELD_SUB_TYPE"), rs.getShort("FIELD_SCALE"))), this.getBytes(FBDatabaseMetaData.getDataTypeName(rs.getShort("FIELD_TYPE"), rs.getShort("FIELD_SUB_TYPE"), rs.getShort("FIELD_SCALE"))), xsqlvars[0].encodeInt(rs.getInt("FIELD_PRECISION")), null, xsqlvars[0].encodeShort(rs.getShort("FIELD_SCALE")), xsqlvars[0].encodeShort((short)1)};
            rows.add(row);
        }
        return rows;
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[8];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 500;
        xsqlvars[0].sqlname = "SCOPE";
        xsqlvars[0].relname = "VERSIONCOL";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "COLUMN_NAME";
        xsqlvars[1].relname = "VERSIONCOL";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 500;
        xsqlvars[2].sqlname = "DATA_TYPE";
        xsqlvars[2].relname = "VERSIONCOL";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "TYPE_NAME";
        xsqlvars[3].relname = "VERSIONCOL";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 496;
        xsqlvars[4].sqlname = "COLUMN_SIZE";
        xsqlvars[4].relname = "VERSIONCOL";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 496;
        xsqlvars[5].sqlname = "BUFFER_LENGTH";
        xsqlvars[5].relname = "VERSIONCOL";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "DECIMAL_DIGITS";
        xsqlvars[6].relname = "VERSIONCOL";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "PSEUDO_COLUMN";
        xsqlvars[7].relname = "VERSIONCOL";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        Clause tableClause = new Clause("RC.RDB$RELATION_NAME", table);
        String sql = GET_PRIMARY_KEYS_START;
        sql = sql + tableClause.getCondition();
        sql = sql + GET_PRIMARY_KEYS_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        XSQLVAR[] xsqlvars = new XSQLVAR[6];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 500;
        xsqlvars[4].sqlname = "KEY_SEQ";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "PK_NAME";
        xsqlvars[5].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[][]{null, null, this.getBytes(rs.getString("TABLE_NAME").trim()), this.getBytes(rs.getString("COLUMN_NAME").trim()), xsqlvars[0].encodeShort(rs.getShort("KEY_SEQ")), this.getBytes(rs.getString("PK_NAME"))};
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        Clause tableClause = new Clause("FK.RDB$RELATION_NAME", table);
        String sql = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
        sql = sql + tableClause.getCondition();
        sql = sql + GET_IMPORTED_KEYS_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        XSQLVAR[] xsqlvars = new XSQLVAR[14];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PKTABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PKTABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PKTABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "PKCOLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FKTABLE_CAT";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FKTABLE_SCHEM";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "FKTABLE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "FKCOLUMN_NAME";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "KEY_SEQ";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "UPDATE_RULE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "DELETE_RULE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 448;
        xsqlvars[11].sqllen = 31;
        xsqlvars[11].sqlname = "FK_NAME";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "PK_NAME";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "DEFERRABILITY";
        xsqlvars[13].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[14][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PKTABLE_NAME").trim());
            row[3] = this.getBytes(rs.getString("PKCOLUMN_NAME").trim());
            row[4] = null;
            row[5] = null;
            row[6] = this.getBytes(rs.getString("FKTABLE_NAME").trim());
            row[7] = this.getBytes(rs.getString("FKCOLUMN_NAME").trim());
            row[8] = xsqlvars[0].encodeShort(rs.getShort("KEY_SEQ"));
            String updateRule = rs.getString("UPDATE_RULE");
            if (updateRule.equals("NO ACTION") || updateRule.equals("RESTRICT")) {
                row[9] = xsqlvars[0].encodeShort((short)3);
            } else if (updateRule.equals("CASCADE")) {
                row[9] = xsqlvars[0].encodeShort((short)0);
            } else if (updateRule.equals("SET NULL")) {
                row[9] = xsqlvars[0].encodeShort((short)2);
            } else if (updateRule.equals("SET DEFAULT")) {
                row[9] = xsqlvars[0].encodeShort((short)4);
            }
            String deleteRule = rs.getString("DELETE_RULE");
            if (deleteRule.equals("NO ACTION") || deleteRule.equals("RESTRICT")) {
                row[10] = xsqlvars[0].encodeShort((short)3);
            } else if (deleteRule.equals("CASCADE")) {
                row[10] = xsqlvars[0].encodeShort((short)0);
            } else if (deleteRule.equals("SET NULL")) {
                row[10] = xsqlvars[0].encodeShort((short)2);
            } else if (deleteRule.equals("SET DEFAULT")) {
                row[10] = xsqlvars[0].encodeShort((short)4);
            }
            row[11] = this.getBytes(rs.getString("FK_NAME"));
            row[12] = this.getBytes(rs.getString("PK_NAME"));
            row[13] = xsqlvars[0].encodeShort((short)7);
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        Clause tableClause = new Clause("PK.RDB$RELATION_NAME", table);
        String sql = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
        sql = sql + tableClause.getCondition();
        sql = sql + " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  order by 7, 9 ";
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        XSQLVAR[] xsqlvars = new XSQLVAR[14];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PKTABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PKTABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PKTABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "PKCOLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FKTABLE_CAT";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FKTABLE_SCHEM";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "FKTABLE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "FKCOLUMN_NAME";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "KEY_SEQ";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "UPDATE_RULE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "DELETE_RULE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 448;
        xsqlvars[11].sqllen = 31;
        xsqlvars[11].sqlname = "FK_NAME";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "PK_NAME";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "DEFERRABILITY";
        xsqlvars[13].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[14][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PKTABLE_NAME").trim());
            row[3] = this.getBytes(rs.getString("PKCOLUMN_NAME").trim());
            row[4] = null;
            row[5] = null;
            row[6] = this.getBytes(rs.getString("FKTABLE_NAME").trim());
            row[7] = this.getBytes(rs.getString("FKCOLUMN_NAME").trim());
            row[8] = xsqlvars[0].encodeShort(rs.getShort("KEY_SEQ"));
            String updateRule = rs.getString("UPDATE_RULE");
            if (updateRule.equals("NO ACTION") || updateRule.equals("RESTRICT")) {
                row[9] = xsqlvars[0].encodeShort((short)3);
            } else if (updateRule.equals("CASCADE")) {
                row[9] = xsqlvars[0].encodeShort((short)0);
            } else if (updateRule.equals("SET NULL")) {
                row[9] = xsqlvars[0].encodeShort((short)2);
            } else if (updateRule.equals("SET DEFAULT")) {
                row[9] = xsqlvars[0].encodeShort((short)4);
            }
            String deleteRule = rs.getString("DELETE_RULE");
            if (deleteRule.equals("NO ACTION") || deleteRule.equals("RESTRICT")) {
                row[10] = xsqlvars[0].encodeShort((short)3);
            } else if (deleteRule.equals("CASCADE")) {
                row[10] = xsqlvars[0].encodeShort((short)0);
            } else if (deleteRule.equals("SET NULL")) {
                row[10] = xsqlvars[0].encodeShort((short)2);
            } else if (deleteRule.equals("SET DEFAULT")) {
                row[10] = xsqlvars[0].encodeShort((short)4);
            }
            row[11] = this.getBytes(rs.getString("FK_NAME"));
            row[12] = this.getBytes(rs.getString("PK_NAME"));
            row[13] = xsqlvars[0].encodeShort((short)7);
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        this.checkCatalogAndSchema(primaryCatalog, primarySchema);
        this.checkCatalogAndSchema(foreignCatalog, foreignSchema);
        Clause primaryTableClause = new Clause("PK.RDB$RELATION_NAME", primaryTable);
        Clause foreignTableClause = new Clause("FK.RDB$RELATION_NAME", foreignTable);
        String sql = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
        sql = sql + primaryTableClause.getCondition();
        sql = sql + foreignTableClause.getCondition();
        sql = sql + " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  order by 7, 9 ";
        ArrayList<String> params = new ArrayList<String>();
        if (!primaryTableClause.getCondition().equals("")) {
            params.add(primaryTableClause.getValue());
        }
        if (!foreignTableClause.getCondition().equals("")) {
            params.add(foreignTableClause.getValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        XSQLVAR[] xsqlvars = new XSQLVAR[14];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PKTABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PKTABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PKTABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "PKCOLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FKTABLE_CAT";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FKTABLE_SCHEM";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "FKTABLE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "FKCOLUMN_NAME";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "KEY_SEQ";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "UPDATE_RULE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "DELETE_RULE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 448;
        xsqlvars[11].sqllen = 31;
        xsqlvars[11].sqlname = "FK_NAME";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "PK_NAME";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "DEFERRABILITY";
        xsqlvars[13].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[14][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PKTABLE_NAME").trim());
            row[3] = this.getBytes(rs.getString("PKCOLUMN_NAME").trim());
            row[4] = null;
            row[5] = null;
            row[6] = this.getBytes(rs.getString("FKTABLE_NAME").trim());
            row[7] = this.getBytes(rs.getString("FKCOLUMN_NAME").trim());
            row[8] = xsqlvars[0].encodeShort(rs.getShort("KEY_SEQ"));
            String updateRule = rs.getString("UPDATE_RULE");
            if (updateRule.equals("NO ACTION") || updateRule.equals("RESTRICT")) {
                row[9] = xsqlvars[0].encodeShort((short)3);
            } else if (updateRule.equals("CASCADE")) {
                row[9] = xsqlvars[0].encodeShort((short)0);
            } else if (updateRule.equals("SET NULL")) {
                row[9] = xsqlvars[0].encodeShort((short)2);
            } else if (updateRule.equals("SET DEFAULT")) {
                row[9] = xsqlvars[0].encodeShort((short)4);
            }
            String deleteRule = rs.getString("DELETE_RULE");
            if (deleteRule.equals("NO ACTION") || deleteRule.equals("RESTRICT")) {
                row[10] = xsqlvars[0].encodeShort((short)3);
            } else if (deleteRule.equals("CASCADE")) {
                row[10] = xsqlvars[0].encodeShort((short)0);
            } else if (deleteRule.equals("SET NULL")) {
                row[10] = xsqlvars[0].encodeShort((short)2);
            } else if (deleteRule.equals("SET DEFAULT")) {
                row[10] = xsqlvars[0].encodeShort((short)4);
            }
            row[11] = this.getBytes(rs.getString("FK_NAME"));
            row[12] = this.getBytes(rs.getString("PK_NAME"));
            row[13] = xsqlvars[0].encodeShort((short)7);
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    private byte[] createShort(int value) throws SQLException {
        if (value > Short.MAX_VALUE) {
            throw new FBSQLException("Cannot convert integer to short.", "HY009");
        }
        return new XSQLVAR().encodeShort((short)value);
    }

    public ResultSet getTypeInfo() throws SQLException {
        XSQLVAR anXSQLVAR = new XSQLVAR();
        byte[] shortZero = anXSQLVAR.encodeShort((short)0);
        byte[] CASESENSITIVE = this.getBytes("T");
        byte[] CASEINSENSITIVE = this.getBytes("F");
        byte[] UNSIGNED = this.getBytes("T");
        byte[] SIGNED = this.getBytes("F");
        byte[] FIXEDSCALE = this.getBytes("T");
        byte[] VARIABLESCALE = this.getBytes("F");
        byte[] NOTAUTOINC = this.getBytes("F");
        byte[] BINARY = anXSQLVAR.encodeInt(2);
        byte[] PREDNONE = anXSQLVAR.encodeShort((short)0);
        byte[] PREDBASIC = anXSQLVAR.encodeShort((short)2);
        byte[] SEARCHABLE = anXSQLVAR.encodeShort((short)3);
        byte[] NULLABLE = anXSQLVAR.encodeShort((short)1);
        XSQLVAR[] xsqlvars = new XSQLVAR[18];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TYPE_NAME";
        xsqlvars[0].relname = "TYPEINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 500;
        xsqlvars[1].sqlname = "DATA_TYPE";
        xsqlvars[1].relname = "TYPEINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 496;
        xsqlvars[2].sqlname = "PRECISION";
        xsqlvars[2].relname = "TYPEINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 1;
        xsqlvars[3].sqlname = "LITERAL_PREFIX";
        xsqlvars[3].relname = "TYPEINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 1;
        xsqlvars[4].sqlname = "LITERAL_SUFFIX";
        xsqlvars[4].relname = "TYPEINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "CREATE_PARAMS";
        xsqlvars[5].relname = "TYPEINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "NULLABLE";
        xsqlvars[6].relname = "TYPEINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 452;
        xsqlvars[7].sqllen = 1;
        xsqlvars[7].sqlname = "CASE_SENSITIVE";
        xsqlvars[7].relname = "TYPEINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "SEARCHABLE";
        xsqlvars[8].relname = "TYPEINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 452;
        xsqlvars[9].sqllen = 1;
        xsqlvars[9].sqlname = "UNSIGNED_ATTRIBUTE";
        xsqlvars[9].relname = "TYPEINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 452;
        xsqlvars[10].sqllen = 1;
        xsqlvars[10].sqlname = "FIXED_PREC_SCALE";
        xsqlvars[10].relname = "TYPEINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 452;
        xsqlvars[11].sqllen = 1;
        xsqlvars[11].sqlname = "AUTO_INCREMENT";
        xsqlvars[11].relname = "TYPEINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "LOCAL_TYPE_NAME";
        xsqlvars[12].relname = "TYPEINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "MINIMUM_SCALE";
        xsqlvars[13].relname = "TYPEINFO";
        xsqlvars[14] = new XSQLVAR();
        xsqlvars[14].sqltype = 500;
        xsqlvars[14].sqlname = "MAXIMUM_SCALE";
        xsqlvars[14].relname = "TYPEINFO";
        xsqlvars[15] = new XSQLVAR();
        xsqlvars[15].sqltype = 496;
        xsqlvars[15].sqlname = "SQL_DATA_TYPE";
        xsqlvars[15].relname = "TYPEINFO";
        xsqlvars[16] = new XSQLVAR();
        xsqlvars[16].sqltype = 496;
        xsqlvars[16].sqlname = "SQL_DATETIME_SUB";
        xsqlvars[16].relname = "TYPEINFO";
        xsqlvars[17] = new XSQLVAR();
        xsqlvars[17].sqltype = 496;
        xsqlvars[17].sqlname = "NUM_PREC_RADIX";
        xsqlvars[17].relname = "TYPEINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        rows.add(new byte[][]{this.getBytes("BIGINT"), this.createShort(-5), anXSQLVAR.encodeInt(64), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(580), null, BINARY});
        rows.add(new byte[][]{this.getBytes("BLOB SUB_TYPE 0"), this.createShort(-4), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(520), null, BINARY});
        rows.add(new byte[][]{this.getBytes("BLOB SUB_TYPE 1"), this.createShort(-1), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(520), null, BINARY});
        rows.add(new byte[][]{this.getBytes("CHAR"), this.createShort(1), anXSQLVAR.encodeInt(32664), this.getBytes("'"), this.getBytes("'"), this.getBytes("length"), NULLABLE, CASESENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(452), null, BINARY});
        rows.add(new byte[][]{this.getBytes("NUMERIC"), this.createShort(2), anXSQLVAR.encodeInt(18), null, null, this.getBytes("precision,scale"), NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, this.createShort(18), anXSQLVAR.encodeInt(580), null, BINARY});
        rows.add(new byte[][]{this.getBytes("DECIMAL"), this.createShort(3), anXSQLVAR.encodeInt(18), null, null, this.getBytes("precision,scale"), NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, this.createShort(18), anXSQLVAR.encodeInt(580), null, BINARY});
        rows.add(new byte[][]{this.getBytes("INTEGER"), this.createShort(4), anXSQLVAR.encodeInt(32), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(496), null, BINARY});
        rows.add(new byte[][]{this.getBytes("SMALLINT"), this.createShort(5), anXSQLVAR.encodeInt(16), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(500), null, BINARY});
        rows.add(new byte[][]{this.getBytes("FLOAT"), this.createShort(6), anXSQLVAR.encodeInt(7), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, VARIABLESCALE, NOTAUTOINC, null, this.createShort(0), this.createShort(7), anXSQLVAR.encodeInt(482), null, BINARY});
        rows.add(new byte[][]{this.getBytes("DOUBLE PRECISION"), this.createShort(8), anXSQLVAR.encodeInt(15), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, VARIABLESCALE, NOTAUTOINC, null, this.createShort(0), this.createShort(15), anXSQLVAR.encodeInt(480), null, BINARY});
        rows.add(new byte[][]{this.getBytes("VARCHAR"), this.createShort(12), anXSQLVAR.encodeInt(32664), this.getBytes("'"), this.getBytes("'"), this.getBytes("length"), NULLABLE, CASESENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(448), null, BINARY});
        rows.add(new byte[][]{this.getBytes("DATE"), this.createShort(91), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(570), null, BINARY});
        rows.add(new byte[][]{this.getBytes("TIME"), this.createShort(92), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(560), null, BINARY});
        rows.add(new byte[][]{this.getBytes("TIMESTAMP"), this.createShort(93), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(510), null, BINARY});
        rows.add(new byte[][]{this.getBytes("ARRAY"), this.createShort(1111), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(540), null, BINARY});
        rows.add(new byte[][]{this.getBytes("BLOB SUB_TYPE <0 "), this.createShort(2004), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(520), null, BINARY});
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        XSQLVAR[] xsqlvars = new XSQLVAR[13];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "INDEXINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "INDEXINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "INDEXINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 452;
        xsqlvars[3].sqllen = 1;
        xsqlvars[3].sqlname = "NON_UNIQUE";
        xsqlvars[3].relname = "INDEXINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "INDEX_QUALIFIER";
        xsqlvars[4].relname = "INDEXINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "INDEX_NAME";
        xsqlvars[5].relname = "INDEXINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "TYPE";
        xsqlvars[6].relname = "INDEXINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "ORDINAL_POSITION";
        xsqlvars[7].relname = "INDEXINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 448;
        xsqlvars[8].sqllen = 31;
        xsqlvars[8].sqlname = "COLUMN_NAME";
        xsqlvars[8].relname = "INDEXINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 448;
        xsqlvars[9].sqllen = 31;
        xsqlvars[9].sqlname = "ASC_OR_DESC";
        xsqlvars[9].relname = "INDEXINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 496;
        xsqlvars[10].sqlname = "CARDINALITY";
        xsqlvars[10].relname = "INDEXINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 496;
        xsqlvars[11].sqlname = "PAGES";
        xsqlvars[11].relname = "INDEXINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "FILTER_CONDITION";
        xsqlvars[12].relname = "INDEXINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        ArrayList<String> params = new ArrayList<String>();
        params.add(table);
        ResultSet rs = this.doQuery(GET_INDEX_INFO, params);
        if (!rs.next()) {
            params.clear();
            params.add(table.toUpperCase());
            rs = this.doQuery(GET_INDEX_INFO_UPPER, params);
            if (!rs.next()) {
                return new FBResultSet(xsqlvars, rows);
            }
        }
        do {
            byte[][] row = new byte[13][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("TABLE_NAME").trim());
            int nonUnique = rs.getInt("NON_UNIQUE");
            row[3] = nonUnique == 0 ? this.getBytes("T") : this.getBytes("F");
            row[4] = null;
            row[5] = this.getBytes(rs.getString("INDEX_NAME").trim());
            row[6] = xsqlvars[0].encodeShort((short)3);
            row[7] = xsqlvars[0].encodeShort(rs.getShort("ORDINAL_POSITION"));
            row[8] = this.getBytes(rs.getString("COLUMN_NAME").trim());
            int index_type = rs.getInt("ASC_OR_DESC");
            row[9] = index_type == 1 ? this.getBytes("D") : this.getBytes("A");
            row[10] = xsqlvars[0].encodeInt(0);
            row[11] = xsqlvars[0].encodeInt(0);
            row[12] = null;
            rows.add(row);
        } while (rs.next());
        return new FBResultSet(xsqlvars, rows);
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return concurrency == 1007 || concurrency == 1008;
            }
        }
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[6];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TYPE_CAT";
        xsqlvars[0].relname = "UDT";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TYPE_SCHEM";
        xsqlvars[1].relname = "UDT";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TYPE_NAME";
        xsqlvars[2].relname = "UDT";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "CLASS_NAME";
        xsqlvars[3].relname = "UDT";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "DATA_TYPE";
        xsqlvars[4].relname = "UDT";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "REMARKS";
        xsqlvars[5].relname = "UDT";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public ResultSet getAttributes(String param1, String param2, String param3, String param4) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public boolean supportsSavepoints() throws SQLException {
        return this.getDatabaseMajorVersion() >= 1 && this.getDatabaseMinorVersion() >= 5;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[6];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TYPE_CAT";
        xsqlvars[0].relname = "SUPERTYPES";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TYPE_SCHEM";
        xsqlvars[1].relname = "SUPERTYPES";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TYPE_NAME";
        xsqlvars[2].relname = "SUPERTYPES";
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "SUPERTYPE_CAT";
        xsqlvars[3].relname = "SUPERTYPES";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "SUPERTYPE_SCHEM";
        xsqlvars[4].relname = "SUPERTYPES";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "SUPERTYPE_NAME";
        xsqlvars[5].relname = "SUPERTYPES";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[4];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "SUPERTABLES";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "SUPERTABLES";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "SUPERTABLES";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "SUPERTABLE_NAME";
        xsqlvars[3].relname = "SUPERTABLES";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 2 || holdability == 1;
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return ((AbstractIscDbHandle)this.gdsHelper.getIscDBHandle()).getDatabaseProductMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return ((AbstractIscDbHandle)this.gdsHelper.getIscDBHandle()).getDatabaseProductMinorVersion();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 1;
    }

    private boolean isAllCondition(String pattern) {
        return "%".equals(pattern);
    }

    public boolean hasNoWildcards(String pattern) {
        int pos;
        if (pattern == null) {
            return true;
        }
        int scannedTo = 0;
        while ((pos = pattern.indexOf(37, scannedTo)) < pattern.length() && pos != -1) {
            if (pos == 0 || pattern.charAt(pos - 1) != '\\') {
                return false;
            }
            scannedTo = ++pos;
        }
        scannedTo = 0;
        while ((pos = pattern.indexOf(95, scannedTo)) < pattern.length() && pos != -1) {
            if (pos == 0 || pattern.charAt(pos - 1) != '\\') {
                return false;
            }
            scannedTo = ++pos;
        }
        return true;
    }

    public String stripEscape(String pattern) {
        StringBuffer stripped = new StringBuffer(pattern.length());
        for (int pos = 0; pos < pattern.length(); ++pos) {
            if (pattern.charAt(pos) == '\\') continue;
            stripped.append(pattern.charAt(pos));
        }
        return stripped.toString();
    }

    private String getWantsSystemTables(String[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (!SYSTEM_TABLE.equals(types[i])) continue;
            return "T";
        }
        return "F";
    }

    private String getWantsTables(String[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (!TABLE.equals(types[i])) continue;
            return "T";
        }
        return "F";
    }

    private String getWantsViews(String[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (!VIEW.equals(types[i])) continue;
            return "T";
        }
        return "F";
    }

    public String stripQuotes(String pattern) {
        if (pattern.length() >= 2 && pattern.charAt(0) == '\"' && pattern.charAt(pattern.length() - 1) == '\"') {
            return pattern.substring(1, pattern.length() - 1);
        }
        return pattern.toUpperCase();
    }

    public String getProcedureSourceCode(String procedureName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$PROCEDURE_SOURCE From RDB$PROCEDURES Where RDB$PROCEDURE_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(procedureName);
        ResultSet rs = this.doQuery(sql, params);
        if (rs.next()) {
            sResult = rs.getString(1);
        }
        rs.close();
        return sResult;
    }

    public String getTriggerSourceCode(String triggerName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$TRIGGER_SOURCE From RDB$TRIGGERS Where RDB$TRIGGER_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(triggerName);
        ResultSet rs = this.doQuery(sql, params);
        if (rs.next()) {
            sResult = rs.getString(1);
        }
        rs.close();
        return sResult;
    }

    public String getViewSourceCode(String viewName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$VIEW_SOURCE From RDB$RELATIONS Where RDB$RELATION_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(viewName);
        ResultSet rs = this.doQuery(sql, params);
        if (rs.next()) {
            sResult = rs.getString(1);
        }
        rs.close();
        return sResult;
    }

    private void checkCatalogAndSchema(String catalog, String schema) throws SQLException {
    }

    private byte[] getBytes(String value) {
        if (value != null) {
            return value.getBytes();
        }
        return null;
    }

    private AbstractPreparedStatement getStatement(String sql) throws SQLException {
        AbstractPreparedStatement s = (AbstractPreparedStatement)this.statements.get(sql);
        if (s != null && s.isClosed()) {
            this.statements.remove(sql);
            s = null;
        }
        if (s != null) {
            return s;
        }
        if (this.connection == null) {
            InternalTransactionCoordinator.MetaDataTransactionCoordinator metaDataTransactionCoordinator = new InternalTransactionCoordinator.MetaDataTransactionCoordinator();
            s = FBStatementFactory.createPreparedStatement(this.gdsHelper, sql, 1004, 1007, 2, metaDataTransactionCoordinator, metaDataTransactionCoordinator, true);
        } else {
            s = (AbstractPreparedStatement)this.connection.prepareMetaDataStatement(sql, 1004, 1007);
        }
        this.statements.put(sql, s);
        return s;
    }

    public ResultSet doQuery(String sql, List params) throws SQLException {
        AbstractPreparedStatement s = this.getStatement(sql);
        for (int i = 0; i < params.size(); ++i) {
            s.setStringForced(i + 1, (String)params.get(i));
        }
        return s.executeMetaDataQuery();
    }

    private class Clause {
        private String condition = "";
        private String value;

        public Clause(String columnName, String pattern) {
            if (pattern == null) {
                return;
            }
            if (FBDatabaseMetaData.this.isAllCondition(pattern)) {
                return;
            }
            if (FBDatabaseMetaData.this.hasNoWildcards(pattern)) {
                this.value = FBDatabaseMetaData.this.stripQuotes(FBDatabaseMetaData.this.stripEscape(pattern));
                this.condition = columnName + " = ? and ";
            } else {
                this.value = FBDatabaseMetaData.this.stripQuotes(pattern) + FBDatabaseMetaData.SPACES + "%";
                this.condition = columnName + " || '" + FBDatabaseMetaData.SPACES + "' like ? escape '\\' and ";
            }
        }

        public String getCondition() {
            return this.condition;
        }

        public String getValue() {
            return this.value;
        }
    }
}

