/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PersisterProperties {
    private String mHost;
    private String mPort;
    private String mNameSpace;
    private String mRootDir;
    private String mClassPath;
    private String mInclude;
    private String mLogFile;
    public static final String FILE_SWITCH = "-f";
    public static final String FILE_SWITCH_DEF = "-fd";
    public static final String DEFAULT_ORM_PROVIDER = "default";
    public static final String USE_ANNOTATIONS_ORM_PROVIDER = "annotations";
    public static final String USE_HIBERNATE_ORM_PROVIDER = "hibernate";
    private String mUser;
    private Properties mProperties;
    private String mExclude;
    private String mDefaultJavaProjectionPackage;
    private String mDefaultAccessLevel;
    private String mDefaultAccessType;
    private String mSelectionType;
    public static final String FIELDS = "fields";
    public static final String GETTERS = "getters";
    public static final String SETTERS = "setters";
    public static final String GETTERS_AND_SETTERS = "getters and setters";
    private String mPassword;
    private int mGenerationType;
    private String mOrmProvider;
    public static final String SCHEMABUILDER_PREFIX = "com.intersys.schemabuilder.";
    public static final String HOST = "com.intersys.schemabuilder.host";
    public static final String DEFAULT_HOST = "localhost";
    public static final String PORT = "com.intersys.schemabuilder.port";
    public static final String DEFAULT_PORT = "1972";
    public static final String NAMESPACE = "com.intersys.schemabuilder.namespace";
    public static final String DEFAULT_NAMESPACE = "USER";
    private static final String FLAGS = "com.intersys.schemabuilder.flags";
    public static final String ROOTDIR = "com.intersys.schemabuilder.rootdir";
    private static final String DEFAULT_ROOTDIR = "";
    public static final String CLASSPATH = "com.intersys.schemabuilder.classpath";
    private static final String DEFAULT_CLASSPATH = "";
    public static final String LOGFILE = "com.intersys.schemabuilder.logfile";
    private static final String DEFAULT_LOGFILE = "";
    public static final String INCLUDE = "com.intersys.schemabuilder.classes";
    public static final String EXCLUDE = "com.intersys.schemabuilder.exclude";
    public static final String DEFAULT_ACCESS_LEVEL = "com.intersys.schemabuilder.defaultaccesslevel";
    public static final String DEFAULT_ACCESS_TYPE = "com.intersys.schemabuilder.defaultaccesstype";
    public static final String DEFAULT_DEFAULT_ACCESS_TYPE = "getters and setters";
    public static final String DEFAULT_JAVA_PROJECTION_PACKAGE = "com.intersys.schemabuilder.defaultjavaprojectionpackage";
    public static final String ORM_PROVIDER = "com.intersys.schemabuilder.metadata";
    public static final String DEFAULT_DEFAULT_ORM_PROVIDER = "default";
    public static final String GENERATION_TYPE = "com.intersys.schemabuilder.generationtype";
    public static final String DEFAULT_GENERATION_TYPE = "default";
    public static String IS_MERGE = "com.intersys.schemabuilder.merge";
    private static final String DEFAULT_IS_MERGE = "false";
    public static final String SCHEMA_USER = "com.intersys.schemabuilder.user";
    public static final String USER = "user";
    public static final String DEFAULT_USER = "_SYSTEM";
    public static final String PASSWORD = "password";
    public static final String SCHEMA_PASSWORD = "com.intersys.schemabuilder.password";
    public static final String DEFAULT_PASSWORD = "";
    public static final String SELECTION_TYPE = "com.intersys.schemabuilder.source";
    public static final String SELECT_ZIPS_OR_JARS = "jars";
    public static final String SELECT_DIRS_OR_CLASSES = "classes";
    public static final String DEFAULT_SELECTION_TYPE = "jars";
    public static final String PROJECTION_DIRECTORY = "com.intersys.schemabuilder.projectiondir";
    public static final String DEFAULT_PROJECTION_DIRECTORY = ".";
    private String mProjectionDirectory;
    private boolean isAdvancedOptionsWizard;
    private boolean mDoMerge;
    private boolean mChangedSelectionType;

    public boolean isChangedSelectionType() {
        return this.mChangedSelectionType;
    }

    public void setChangedSelectionType(boolean bl) {
        this.mChangedSelectionType = bl;
    }

    public PersisterProperties(Properties properties) {
        this.setRunTimeSwitches(properties);
    }

    public PersisterProperties(Properties properties, String string) {
        properties.setProperty(PASSWORD, string);
        this.setRunTimeSwitches(properties);
    }

    public void setRunTimeSwitches(Properties properties) {
        this.mHost = properties.getProperty(HOST, DEFAULT_HOST);
        this.mPort = properties.getProperty(PORT, DEFAULT_PORT);
        this.mNameSpace = properties.getProperty(NAMESPACE, DEFAULT_NAMESPACE);
        this.mRootDir = properties.getProperty(ROOTDIR, "");
        this.mClassPath = properties.getProperty(CLASSPATH, "");
        this.mLogFile = properties.getProperty(LOGFILE, "");
        this.mInclude = properties.getProperty(INCLUDE, "");
        this.mExclude = properties.getProperty(EXCLUDE, "");
        this.mDefaultAccessLevel = properties.getProperty(DEFAULT_ACCESS_LEVEL, "protected").toLowerCase();
        this.mDefaultAccessType = properties.getProperty(DEFAULT_ACCESS_TYPE, "getters and setters").toLowerCase();
        this.mDefaultJavaProjectionPackage = properties.getProperty(DEFAULT_JAVA_PROJECTION_PACKAGE, "");
        this.mOrmProvider = properties.getProperty(ORM_PROVIDER, "default").toLowerCase();
        try {
            this.mGenerationType = Integer.parseInt(properties.getProperty(GENERATION_TYPE, "default"));
        }
        catch (Exception exception) {
            this.mGenerationType = 0;
        }
        this.mSelectionType = properties.getProperty(SELECTION_TYPE, "jars").toLowerCase();
        this.mProjectionDirectory = new File(properties.getProperty(PROJECTION_DIRECTORY, DEFAULT_PROJECTION_DIRECTORY)).getAbsolutePath().toString();
        if (properties.getProperty(SCHEMA_USER) != null) {
            properties.setProperty(USER, properties.getProperty(SCHEMA_USER));
        }
        if (properties.getProperty(SCHEMA_PASSWORD) != null) {
            properties.setProperty(PASSWORD, properties.getProperty(SCHEMA_PASSWORD));
        }
        this.mProperties = new Properties(properties);
        this.mUser = this.setDefaultValue(USER, DEFAULT_USER);
        this.mPassword = this.setDefaultValue(PASSWORD, "");
        this.setDoMerge(new Boolean(properties.getProperty(IS_MERGE, DEFAULT_IS_MERGE)));
    }

    private String setDefaultValue(String string, String string2) {
        if (this.mProperties.getProperty(string) == null) {
            this.mProperties.setProperty(string, string2);
        }
        return this.mProperties.getProperty(string);
    }

    public boolean getDoMerge() {
        return this.mDoMerge;
    }

    public void setDoMerge(boolean bl) {
        this.mDoMerge = bl;
    }

    public void writePropertiesToConfigFile(Properties properties, String string) {
        properties.setProperty(HOST, this.getHost());
        properties.setProperty(PORT, this.getPort());
        properties.setProperty(NAMESPACE, this.getNameSpace());
        properties.setProperty(USER, this.getUser());
        properties.setProperty(ROOTDIR, this.getRootDir());
        properties.setProperty(CLASSPATH, this.getClassPath());
        properties.setProperty(LOGFILE, this.getLogFile());
        properties.setProperty(INCLUDE, this.getInclude());
        properties.setProperty(EXCLUDE, this.getExclude());
        properties.setProperty(DEFAULT_ACCESS_LEVEL, this.getDefaultAccessLevel());
        properties.setProperty(DEFAULT_ACCESS_TYPE, this.getDefaultAccessType());
        properties.setProperty(DEFAULT_JAVA_PROJECTION_PACKAGE, this.getDefaultJavaProjectionPackage());
        properties.setProperty(ORM_PROVIDER, this.getOrmProvider());
        properties.remove(PASSWORD);
        properties.remove(SCHEMA_PASSWORD);
        properties.setProperty(GENERATION_TYPE, new Integer(this.getGenerationType()).toString());
        properties.setProperty(SELECTION_TYPE, this.getSelectionType());
        properties.setProperty(ROOTDIR, this.getRootDir());
        properties.setProperty(CLASSPATH, this.getClassPath());
        properties.setProperty(IS_MERGE, new Boolean(this.getDoMerge()).toString());
        properties.setProperty(PROJECTION_DIRECTORY, this.getProjectionDirectory());
        try {
            properties.store(new FileOutputStream(string), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getRootDir() {
        return this.mRootDir;
    }

    public void setRootDir(String string) {
        this.mRootDir = string;
    }

    public String getClassPath() {
        return this.mClassPath;
    }

    public void setClassPath(String string) {
        this.mClassPath = string;
    }

    public String getHost() {
        return this.mHost;
    }

    public String getPort() {
        return this.mPort;
    }

    public String getNameSpace() {
        return this.mNameSpace;
    }

    public String getInclude() {
        return this.mInclude;
    }

    public void setInclude(String string) {
        this.mInclude = string;
    }

    public String getUser() {
        return this.mUser;
    }

    public String getExclude() {
        return this.mExclude;
    }

    public String getDefaultAccessLevel() {
        return this.mDefaultAccessLevel;
    }

    public String getDefaultAccessType() {
        return this.mDefaultAccessType;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getGenerationType() {
        return this.mGenerationType;
    }

    public String getOrmProvider() {
        return this.mOrmProvider;
    }

    public String getDefaultJavaProjectionPackage() {
        return this.mDefaultJavaProjectionPackage;
    }

    public String getSelectionType() {
        return this.mSelectionType;
    }

    public void setSelectionType(String string) {
        this.mSelectionType = string;
    }

    public String getProjectionDirectory() {
        return this.mProjectionDirectory;
    }

    public void updateLoginInfo(String string, String string2, String string3, String string4, String string5) {
        this.mHost = string;
        this.mPort = string2;
        this.mUser = string3;
        this.mPassword = string4;
        this.mProperties.setProperty(USER, this.mUser);
        this.mProperties.setProperty(PASSWORD, this.mPassword);
        this.mNameSpace = string5;
    }

    public void updateStandardOptions(String string, String string2, String string3, String string4, boolean bl) {
        this.mExclude = string;
        this.mDefaultAccessLevel = string2;
        this.mDefaultAccessType = string3;
        this.mOrmProvider = string4;
        this.setDoMerge(bl);
    }

    public void updateProjectionOptions(String string, String string2, String string3) {
        this.mDefaultJavaProjectionPackage = string;
        this.mGenerationType = Integer.parseInt(string2);
        this.mProjectionDirectory = string3;
    }

    public String getLogFile() {
        return this.mLogFile;
    }

    public void setLogFile(String string) {
        this.mLogFile = string;
    }

    public boolean isAdvancedOptionsWizard() {
        return this.isAdvancedOptionsWizard;
    }

    public void setAdvancedOptionsWizard(boolean bl) {
        this.isAdvancedOptionsWizard = bl;
    }

    public Properties getProperties() {
        return this.mProperties;
    }
}

