/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import java.sql.SQLException;
import java.util.Map;

public class ZObjValReader {
    protected static final int MAX_ZOBJVAL_NODE = 6;
    protected byte[][] mZobjval;
    protected Map mValueMap;
    protected Oid mOid;

    public ZObjValReader(Map map, Oid oid) {
        this.mValueMap = map;
        this.mOid = oid;
    }

    public ZObjValReader(byte[][] byArray) {
        this.mZobjval = byArray;
    }

    private byte[] getAt(int n) {
        return this.mZobjval[n - 1];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSwizzled(int n, int n2) throws CacheException {
        Object object;
        block9: {
            object = null;
            if (this.mValueMap != null) {
                Dataholder dataholder = (Dataholder)this.mValueMap.get(new Integer(n));
                if (dataholder == null) {
                    return false;
                }
                if (n2 > 0) {
                    object = dataholder.getSysList();
                    break block9;
                } else {
                    if (ZObjValReader.isObjNull(n2, dataholder)) return false;
                    return true;
                }
            }
            object = SysListProxy.createSysList(this.getAt(n), false, Dataholder.DEFAULT_CONNECTION_INFO);
        }
        try {
            if (SysListProxy.atEnd(object)) {
                return false;
            }
            if (n2 < 1) {
                return false;
            }
            if (n2 <= 1) return Dataholder.isSwizzled(object);
            if (!SysListProxy.skip(object, n2 - 1)) {
                return false;
            }
            if (!SysListProxy.atEnd(object)) return Dataholder.isSwizzled(object);
            return false;
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Bad data in cache for nodes [" + n + ';' + n2 + "]");
        }
    }

    public Dataholder getProperty(int n, int n2) throws CacheException {
        Object object;
        Object object2 = null;
        if (this.mValueMap != null) {
            object = (Dataholder)this.mValueMap.get(new Integer(n));
            if (n2 <= 0) {
                switch (n2) {
                    case 0: {
                        return object;
                    }
                }
                throw new SystemError("Unsupported jj value: " + n2);
            }
            if (object == null) {
                return null;
            }
            object2 = ((Dataholder)object).getSysList();
        } else {
            object2 = SysListProxy.createSysList(this.getAt(n), false, Dataholder.DEFAULT_CONNECTION_INFO);
        }
        try {
            object = SysListProxy.getWrappedItem(object2, n2 - 1);
            return new Dataholder(4096, object);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Bad data in cache for nodes [" + n + ';' + n2 + "]");
        }
    }

    protected void setCachedObject(int n, int n2, Dataholder dataholder) {
        if (this.mValueMap == null) {
            return;
        }
        if (n2 != 0) {
            return;
        }
        this.mValueMap.put(new Integer(n), dataholder);
    }

    public Oid getOid() {
        return this.mOid;
    }

    protected Map getValueMap() {
        return this.mValueMap;
    }

    private static final boolean isObjNull(int n, Dataholder dataholder) throws CacheException {
        switch (n) {
            case 0: {
                switch (dataholder.getType()) {
                    case 2: 
                    case 4: 
                    case 6: 
                    case 15: 
                    case 512: 
                    case 4096: {
                        int n2 = ZObjValReader.getOrefFromDataholder(dataholder);
                        return n2 == 0;
                    }
                    case 1026: {
                        return false;
                    }
                }
                byte[] byArray = dataholder.getBinary();
                return byArray == null || byArray.length == 0;
            }
        }
        throw new SystemError("Unsupported jj value: " + n);
    }

    private static int getOrefFromDataholder(Dataholder dataholder) throws CacheException {
        String string = dataholder.getString();
        if (string == null) {
            return 0;
        }
        int n = string.indexOf(64);
        if (n >= 0) {
            return Integer.parseInt(string.substring(0, n));
        }
        return Integer.parseInt(string);
    }

    public String toString() {
        if (this.mZobjval != null) {
            return super.toString();
        }
        String string = this.mOid != null ? this.mOid.toString() + ": " : "";
        return string + this.mValueMap.toString();
    }

    public void assertEquals(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Object v = this.mValueMap.get(new Integer(i));
            if (string == null) {
                if (v == null || v.toString().equals("null")) continue;
                throw new IllegalStateException("Assertion Failure: ZobjVal mismatch at node #" + i + ": " + string + "/" + v);
            }
            if (string.equals(v.toString())) continue;
            throw new IllegalStateException("Assertion Failure: ZobjVal mismatch at node #" + i + ": " + string + "/" + v);
        }
    }
}

