/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheRunTimeException;
import com.intersys.objects.Id;
import com.intersys.objects.SystemError;
import java.io.Serializable;
import java.sql.SQLException;

public class Oid
implements Serializable,
Comparable {
    protected Object mData;
    private Integer mHashCode = null;
    private String mClassNamedCached = null;
    private String mIdCached = null;
    private int mIntId = -1;

    public Oid(String string, String string2) {
        try {
            this.mData = SysListProxy.createSysList(new ConnectionInfo());
            SysListProxy.setString(this.mData, string);
            SysListProxy.setString(this.mData, string2);
            this.mClassNamedCached = string2;
            this.mIdCached = string;
        }
        catch (SQLException sQLException) {
            throw new CacheRunTimeException(new CacheException(sQLException));
        }
    }

    public Oid(String string) {
        this(string, "");
    }

    public Oid(Id id, String string) {
        this(id.toString(), string);
    }

    public Oid(int n, String string) {
        try {
            this.mData = SysListProxy.createSysList(new ConnectionInfo());
            SysListProxy.setInteger(this.mData, n);
            SysListProxy.setString(this.mData, string);
            this.mClassNamedCached = string;
        }
        catch (SQLException sQLException) {
            throw new CacheRunTimeException(new CacheException(sQLException));
        }
    }

    public Oid(int n) {
        this(n, "");
        this.mIntId = n;
    }

    public Oid(Object object) {
        this.mData = object;
    }

    public Oid(byte[] byArray) {
        this.mData = byArray != null ? SysListProxy.createSysList(byArray, true, new ConnectionInfo()) : SysListProxy.createSysList(new ConnectionInfo());
    }

    public byte[] getData() {
        return SysListProxy.getBinaryData(this.mData);
    }

    public String getClassName() {
        if (this.mClassNamedCached == null) {
            try {
                String string = SysListProxy.getString(this.mData, 1);
                if (string == null) {
                    string = "";
                }
                this.mClassNamedCached = string;
            }
            catch (SQLException sQLException) {
                this.mClassNamedCached = "";
            }
        }
        return this.mClassNamedCached;
    }

    public Id getId() throws CacheException {
        try {
            return new Id(SysListProxy.getString(this.mData, 0));
        }
        catch (SQLException sQLException) {
            return new Id("");
        }
    }

    public String toIdString() {
        if (this.mIdCached == null) {
            try {
                this.mIdCached = this.getId().toString();
            }
            catch (CacheException cacheException) {
                throw new CacheRunTimeException(cacheException);
            }
        }
        return this.mIdCached;
    }

    public boolean undefined() throws SystemError {
        try {
            SysListProxy.rewind(this.mData);
            return SysListProxy.atEnd(this.mData);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to get data from oid");
        }
    }

    public String toString() {
        if (this.mData == null) {
            return null;
        }
        return this.mData.toString();
    }

    private int intId() {
        if (this.mIntId == -1) {
            try {
                this.mIntId = Integer.parseInt(this.toIdString());
            }
            catch (NumberFormatException numberFormatException) {
                this.mIntId = -100;
            }
        }
        return this.mIntId;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Oid)) {
            return false;
        }
        Oid oid = (Oid)object;
        if (this.intId() != oid.intId()) {
            return false;
        }
        if (!this.getClassName().equals(oid.getClassName())) {
            return false;
        }
        if (this.intId() >= 0) {
            return true;
        }
        return this.toIdString().equals(oid.toIdString());
    }

    public int compareTo(Object object) {
        Oid oid = (Oid)object;
        int n = this.getClassName().compareTo(oid.getClassName());
        if (n != 0) {
            return n;
        }
        return this.toIdString().compareTo(oid.toIdString());
    }

    public int hashCode() {
        if (this.mData == null) {
            return 0;
        }
        if (this.mHashCode == null) {
            int n = this.getClassName().hashCode();
            int n2 = this.intId();
            if (n2 < 0) {
                n2 = this.toIdString().hashCode();
            }
            this.mHashCode = new Integer(n2 + n);
        }
        return this.mHashCode;
    }
}

