/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.PrintStream;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.jdbc.InternalDriver;

public class JDBCBoot {
    private Properties bootProperties = new Properties();
    private static final String NETWORK_SERVER_AUTOSTART_CLASS_NAME = "org.apache.derby.iapi.jdbc.DRDAServerStarter";

    void addProperty(String string, String string2) {
        this.bootProperties.put(string, string2);
    }

    public void boot(String string, PrintStream printStream) {
        if (InternalDriver.activeDriver() == null) {
            this.addProperty("derby.service.jdbc", "org.apache.derby.jdbc.InternalDriver");
            this.addProperty("derby.service.authentication", "org.apache.derby.iapi.jdbc.AuthenticationService");
            Monitor.startMonitor(this.bootProperties, printStream);
            if (Boolean.valueOf(PropertyUtil.getSystemProperty("derby.drda.startNetworkServer")).booleanValue()) {
                try {
                    Monitor.startSystemModule(NETWORK_SERVER_AUTOSTART_CLASS_NAME);
                }
                catch (StandardException standardException) {
                    Monitor.logTextMessage("J102", standardException.getMessage());
                }
            }
        }
    }
}

