/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy._Proxy_;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;

public class ARRAY
extends DatumWithConnection
implements OracleArray {
    static final byte KOPUP_INLINE_COLL = 1;
    ArrayDescriptor descriptor;
    Object objArray;
    Datum[] datumArray;
    byte[] locator;
    byte prefixFlag;
    byte[] prefixSegment;
    int numElems = -1;
    boolean enableBuffering = false;
    boolean enableIndexing = false;
    public static final int ACCESS_FORWARD = 1;
    public static final int ACCESS_REVERSE = 2;
    public static final int ACCESS_UNKNOWN = 3;
    int accessDirection = 3;
    long lastIndex;
    long lastOffset;
    long[] indexArray;
    long imageOffset;
    long imageLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;
    Object acProxy;

    public ARRAY(ArrayDescriptor arrayDescriptor, Connection connection, Object object) throws SQLException {
        ARRAY.assertNotNull(arrayDescriptor);
        this.descriptor = arrayDescriptor;
        ARRAY.assertNotNull(connection);
        if (!arrayDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct ARRAY instance,invalid connection");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        arrayDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = object == null ? new Datum[0] : this.descriptor.toOracleArray(object, 1L, -1);
    }

    public ARRAY(ArrayDescriptor arrayDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        ARRAY.assertNotNull(arrayDescriptor);
        this.descriptor = arrayDescriptor;
        ARRAY.assertNotNull(connection);
        if (!arrayDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct ARRAY instance,invalid connection");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        arrayDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = null;
        this.locator = null;
    }

    public static ARRAY toARRAY(Object object, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        ARRAY aRRAY = null;
        if (object != null) {
            if (object instanceof ARRAY) {
                aRRAY = (ARRAY)object;
            } else if (object instanceof ORAData) {
                aRRAY = (ARRAY)((ORAData)object).toDatum(oracleConnection);
            } else if (object instanceof OracleData) {
                Object object2 = ((OracleData)object).toJDBCObject(oracleConnection);
                if (object2 instanceof _Proxy_) {
                    final _Proxy_ _Proxy_2 = (_Proxy_)object2;
                    object2 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return ProxyFactory.extractDelegate(_Proxy_2);
                        }
                    });
                }
                aRRAY = (ARRAY)object2;
            } else if (object instanceof CustomDatum) {
                aRRAY = (ARRAY)oracleConnection.physicalConnectionWithin().toDatum((CustomDatum)object);
            } else {
                SQLException sQLException = DatabaseError.createSqlException(null, 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBaseTypeName() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.getBaseName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBaseType() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.getBaseType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toJavaArray(this, 1L, -1, this.getMap(), this.enableBuffering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getArray(Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toJavaArray(this, 1L, -1, map, this.enableBuffering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            if (l2 < 1L || n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid arguments,'index' should be >= 1 and 'count' >= 0. An exception is thrown.");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.descriptor.toJavaArray(this, l2, n2, this.getMap(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getArray(long l2, int n2, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            if (l2 < 1L || n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid arguments,'index' should be >= 1 and 'count' >= 0. An exception is thrown.");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.descriptor.toJavaArray(this, l2, n2, map, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.getResultSet(this.getInternalConnection().getTypeMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet(Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toResultSet(this, 1L, -1, map, this.enableBuffering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.getResultSet(l2, n2, this.getInternalConnection().getTypeMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet(long l2, int n2, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            if (l2 < 1L || n2 < -1) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getResultSet()");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.descriptor.toResultSet(this, l2, n2, map, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] getOracleArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toOracleArray(this, 1L, -1, this.enableBuffering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int length() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toLength(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] getOracleArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            if (l2 < 1L || n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getOracleArray()");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.descriptor.toOracleArray(this, l2, n2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLTypeName() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            String string = null;
            if (this.descriptor == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61, "ARRAY");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            string = this.descriptor.getName();
            return string;
        }
    }

    @Override
    public Map getMap() throws SQLException {
        return this.getInternalConnection().getTypeMap();
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.getDescriptor();
    }

    @Override
    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBytes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toBytes(this, this.enableBuffering);
        }
    }

    @Override
    public void setDatumArray(Datum[] datumArray) {
        this.datumArray = datumArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjArray(Object object) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            if (object == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid argument,'oarray' should not be null. An exception is thrown.");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.objArray = object;
        }
    }

    @Override
    public void setLocator(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.locator = byArray;
        }
    }

    @Override
    public void setPrefixSegment(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.prefixSegment = byArray;
        }
    }

    @Override
    public void setPrefixFlag(byte by) {
        this.prefixFlag = by;
    }

    @Override
    public byte[] getLocator() {
        return this.locator;
    }

    @Override
    public void setLength(int n2) {
        this.numElems = n2;
    }

    @Override
    public boolean hasDataSeg() {
        return this.locator == null;
    }

    @Override
    public boolean isInline() {
        return (this.prefixFlag & 1) == 1;
    }

    @Override
    public Object toJdbc() throws SQLException {
        Map map = this.getMap();
        return this.toJdbc(map);
    }

    public Object toJdbc(Map map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    Object toClass(Class clazz, Map map) throws SQLException {
        Object object;
        block6: {
            object = null;
            try {
                if (clazz == null || clazz == ARRAY.class || clazz == Array.class) {
                    object = this;
                    break block6;
                }
                Object t2 = clazz.newInstance();
                if (t2 instanceof ORADataFactory) {
                    ORADataFactory oRADataFactory = (ORADataFactory)t2;
                    object = oRADataFactory.create(this, 2003);
                    break block6;
                }
                if (t2 instanceof OracleDataFactory) {
                    OracleDataFactory oracleDataFactory = (OracleDataFactory)t2;
                    object = oracleDataFactory.create(this, 2003);
                    break block6;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (InstantiationException instantiationException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + instantiationException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (IllegalAccessException illegalAccessException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + illegalAccessException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return object;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new Object[n2][];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getIntArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return (int[])this.descriptor.toNumericArray(this, 1L, -1, 4, this.enableBuffering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getIntArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return (int[])this.descriptor.toNumericArray(this, l2, n2, 4, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getDoubleArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return (double[])this.descriptor.toNumericArray(this, 1L, -1, 5, this.enableBuffering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getDoubleArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return (double[])this.descriptor.toNumericArray(this, l2, n2, 5, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] getShortArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return (short[])this.descriptor.toNumericArray(this, 1L, -1, 8, this.enableBuffering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] getShortArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return (short[])this.descriptor.toNumericArray(this, l2, n2, 8, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getLongArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return (long[])this.descriptor.toNumericArray(this, 1L, -1, 7, this.enableBuffering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getLongArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return (long[])this.descriptor.toNumericArray(this, l2, n2, 7, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getFloatArray() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return (float[])this.descriptor.toNumericArray(this, 1L, -1, 6, this.enableBuffering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getFloatArray(long l2, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return (float[])this.descriptor.toNumericArray(this, l2, n2, 6, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoBuffering(boolean bl) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            this.enableBuffering = bl;
        }
    }

    @Override
    public boolean getAutoBuffering() throws SQLException {
        return this.enableBuffering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoIndexing(boolean bl, int n2) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            this.enableIndexing = bl;
            this.accessDirection = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoIndexing(boolean bl) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            this.enableIndexing = bl;
            this.accessDirection = 3;
        }
    }

    @Override
    public boolean getAutoIndexing() throws SQLException {
        return this.enableIndexing;
    }

    @Override
    public int getAccessDirection() throws SQLException {
        return this.accessDirection;
    }

    @Override
    public void setLastIndexOffset(long l2, long l3) throws SQLException {
        this.lastIndex = l2;
        this.lastOffset = l3;
    }

    @Override
    public void setIndexOffset(long l2, long l3) throws SQLException {
        if (this.indexArray == null) {
            this.indexArray = new long[this.numElems];
        }
        this.indexArray[(int)l2 - 1] = l3;
    }

    @Override
    public long getLastIndex() throws SQLException {
        return this.lastIndex;
    }

    @Override
    public long getLastOffset() throws SQLException {
        return this.lastOffset;
    }

    @Override
    public long getOffset(long l2) throws SQLException {
        long l3 = -1L;
        if (this.indexArray != null) {
            l3 = this.indexArray[(int)l2 - 1];
        }
        return l3;
    }

    @Override
    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.imageOffset = l2;
        this.imageLength = l3;
    }

    @Override
    public void setImageLength(long l2) throws SQLException {
        this.imageLength = l2;
    }

    @Override
    public long getImageOffset() {
        return this.imageOffset;
    }

    @Override
    public long getImageLength() {
        return this.imageLength;
    }

    public String dump() throws SQLException {
        return STRUCT.dump(this);
    }

    @Override
    public String stringValue() throws SQLException {
        Datum[] datumArray = this.getOracleArray();
        String string = "[";
        for (int i2 = 0; i2 < datumArray.length; ++i2) {
            if (i2 != 0) {
                string = string + ", ";
            }
            string = datumArray[i2] == null ? string + "null" : string + datumArray[i2].stringValue();
        }
        string = string + "]";
        return string;
    }

    static void dump(ARRAY aRRAY, PrintWriter printWriter, int n2) throws SQLException {
        int n3;
        if (n2 > 0) {
            printWriter.println();
        }
        ArrayDescriptor arrayDescriptor = aRRAY.getDescriptor();
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print(' ');
        }
        printWriter.println("name = " + arrayDescriptor.getName());
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print(' ');
        }
        printWriter.println("max length = " + arrayDescriptor.getMaxLength());
        Object[] objectArray = (Object[])aRRAY.getArray();
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print(' ');
        }
        int n4 = objectArray.length;
        printWriter.println("length = " + n4);
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                printWriter.print(' ');
            }
            printWriter.print("element[" + n3 + "] = ");
            STRUCT.dump(objectArray[n3], printWriter, n2 + 4);
        }
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public void setACProxy(Object object) {
        this.acProxy = object;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }
}

