/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.EJB.objects;

import com.intersys.EJB.objects.SerializableInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EJBBinaryStream
extends SerializableInputStream {
    byte[] buf;
    int offset;
    int length;
    public static final int bufsize = 2048;

    public EJBBinaryStream(InputStream inputStream) throws IOException {
        int n;
        this.buf = new byte[2048];
        int n2 = 2048;
        this.offset = 0;
        if (inputStream == null) {
            this.offset = 0;
            this.length = 0;
            return;
        }
        while ((n = inputStream.read(this.buf, this.offset, n2)) != -1) {
            this.length += n;
            if ((n2 -= n) == 0) {
                byte[] byArray = new byte[this.buf.length + 2048];
                System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
                this.buf = byArray;
                n2 = 2048;
            }
            this.offset += n;
        }
        this.offset = 0;
    }

    public EJBBinaryStream(byte[] byArray, int n) {
        this.buf = byArray;
        this.offset = 0;
        this.length = n;
    }

    public EJBBinaryStream(byte[] byArray) {
        this.buf = byArray;
        this.offset = 0;
        this.length = byArray.length;
    }

    public EJBBinaryStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.offset = n;
        this.length = n2;
    }

    public void rewind() {
        this.offset = 0;
    }

    public int available() throws IOException {
        return this.length - this.offset;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.available() == 0) {
            return -1;
        }
        int n3 = n2 <= this.available() ? n2 : this.available();
        System.arraycopy(this.buf, this.offset, byArray, n, n3);
        this.offset += n3;
        return n3;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        return byArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }
}

