/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;

@GwtCompatible
public class MultimapContainsKeyTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsKeyYes() {
        MultimapContainsKeyTester.assertTrue((boolean)this.multimap().containsKey(this.sampleKeys().e0));
    }

    public void testContainsKeyNo() {
        MultimapContainsKeyTester.assertFalse((boolean)this.multimap().containsKey(this.sampleKeys().e3));
    }

    public void testContainsKeysFromKeySet() {
        for (Object k : this.multimap().keySet()) {
            MultimapContainsKeyTester.assertTrue((boolean)this.multimap().containsKey(k));
        }
    }

    public void testContainsKeyAgreesWithGet() {
        for (Object k : this.sampleKeys()) {
            MultimapContainsKeyTester.assertEquals((!this.multimap().get(k).isEmpty() ? 1 : 0) != 0, (boolean)this.multimap().containsKey(k));
        }
    }

    public void testContainsKeyAgreesWithAsMap() {
        for (Object k : this.sampleKeys()) {
            MultimapContainsKeyTester.assertEquals((boolean)this.multimap().containsKey(k), (boolean)this.multimap().asMap().containsKey(k));
        }
    }

    public void testContainsKeyAgreesWithKeySet() {
        for (Object k : this.sampleKeys()) {
            MultimapContainsKeyTester.assertEquals((boolean)this.multimap().containsKey(k), (boolean)this.multimap().keySet().contains(k));
        }
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsKeyNullPresent() {
        this.initMultimapWithNullKey();
        MultimapContainsKeyTester.assertTrue((boolean)this.multimap().containsKey(null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_QUERIES})
    public void testContainsKeyNullAbsent() {
        MultimapContainsKeyTester.assertFalse((boolean)this.multimap().containsKey(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_QUERIES})
    public void testContainsKeyNullDisallowed() {
        try {
            this.multimap().containsKey(null);
            MultimapContainsKeyTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

