/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeType
extends OpenType
implements Serializable {
    private static final long serialVersionUID = -5366242454346948798L;
    private TreeMap nameToDescription;
    private TreeMap nameToType;
    private transient String m_classStringValue = null;
    private transient int m_hashcode = 0;

    public CompositeType(String typeName, String description, String[] itemNames, String[] itemDescriptions, OpenType[] itemTypes) throws OpenDataException {
        super(CompositeData.class.getName(), typeName, description);
        this.validate(typeName, description, itemNames, itemDescriptions, itemTypes);
        this.initialize(itemNames, itemDescriptions, itemTypes);
    }

    private void initialize(String[] itemNames, String[] itemDescriptions, OpenType[] itemTypes) throws OpenDataException {
        this.m_hashcode = this.computeHashCode(this.getTypeName(), itemNames, itemTypes);
        this.nameToDescription = new TreeMap();
        this.nameToType = new TreeMap();
        for (int i = 0; i < itemNames.length; ++i) {
            String item = itemNames[i].trim();
            if (this.nameToDescription.containsKey(item)) {
                throw new OpenDataException("The key: " + item + " is already mapped to a previous entry");
            }
            this.nameToDescription.put(item, itemDescriptions[i]);
            this.nameToType.put(item, itemTypes[i]);
        }
    }

    private void validate(String typeName, String description, String[] itemNames, String[] itemDescriptions, OpenType[] itemTypes) throws IllegalArgumentException {
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("typeName can't be null or empty");
        }
        if (description == null || description.length() == 0) {
            throw new IllegalArgumentException("description can't be null or empty");
        }
        if (itemNames == null || itemNames.length == 0) {
            throw new IllegalArgumentException("The String[] of itemNames cannot be null or empty");
        }
        if (itemDescriptions == null || itemDescriptions.length == 0) {
            throw new IllegalArgumentException("The String[] of itemDescriptions cannot be null or empty");
        }
        if (itemTypes == null || itemTypes.length == 0) {
            throw new IllegalArgumentException("The OpenType[] of itemTypes cannot be null or empty");
        }
        if (itemDescriptions.length != itemNames.length || itemTypes.length != itemNames.length) {
            throw new IllegalArgumentException("itemNames, itemDescriptions and itemTypes must all be the same length");
        }
        for (int i = 0; i < itemNames.length; ++i) {
            String value = itemNames[i];
            String d = itemDescriptions[i];
            if (value == null) {
                throw new IllegalArgumentException("The itemName at index: " + i + " cannot be a null value");
            }
            if (d == null) {
                throw new IllegalArgumentException("The itemDescription at index: " + i + " cannot be a null value");
            }
            if (value.trim().equals("")) {
                throw new IllegalArgumentException("The itemName at index: " + i + " cannot be an empty string");
            }
            if (d.trim().equals("")) {
                throw new IllegalArgumentException("The itemDescription at index: " + i + " cannot be an empty string");
            }
            if (itemTypes[i] != null) continue;
            throw new IllegalArgumentException("The OpenType at index: " + i + " cannot be a null value");
        }
    }

    public boolean containsKey(String itemName) {
        if (itemName == null || itemName.length() == 0) {
            return false;
        }
        return this.nameToDescription.containsKey(itemName);
    }

    public String getDescription(String itemName) {
        if (itemName == null || itemName.length() == 0) {
            return null;
        }
        return (String)this.nameToDescription.get(itemName);
    }

    public OpenType getType(String itemName) {
        if (itemName == null || itemName.length() == 0) {
            return null;
        }
        return (OpenType)this.nameToType.get(itemName);
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.nameToDescription.keySet());
    }

    public boolean isValue(Object object) {
        if (!(object instanceof CompositeData)) {
            return false;
        }
        CompositeData compositeData = (CompositeData)object;
        return this.equals(compositeData.getCompositeType());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CompositeType)) {
            return false;
        }
        CompositeType type = (CompositeType)object;
        if (!this.getTypeName().equals(type.getTypeName())) {
            return false;
        }
        return this.nameToType.equals(type.nameToType);
    }

    public int hashCode() {
        return this.m_hashcode;
    }

    public String toString() {
        if (this.m_classStringValue == null) {
            StringBuffer value = new StringBuffer(100);
            value.append(this.getClassName()).append(" TypeName: ").append(this.getTypeName()).append(" contains data:\n");
            for (Map.Entry entry : this.nameToType.entrySet()) {
                value.append("ItemName: ").append((String)entry.getKey()).append(" OpenType value: ").append(((OpenType)entry.getValue()).toString()).append("\n");
            }
            this.m_classStringValue = value.toString();
        }
        return this.m_classStringValue;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        String[] itemNames = this.nameToDescription.keySet().toArray(new String[this.nameToDescription.size()]);
        String[] itemDescriptions = this.nameToDescription.values().toArray(new String[this.nameToDescription.size()]);
        OpenType[] itemTypes = this.nameToType.values().toArray(new OpenType[this.nameToType.size()]);
        try {
            this.validate(this.getTypeName(), this.getDescription(), itemNames, itemDescriptions, itemTypes);
            this.initialize(itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new StreamCorruptedException("validation failed for deserialized object, unable to create object in the correct state");
        }
    }

    private int computeHashCode(String name, String[] itemnames, OpenType[] itemtypes) {
        int result = name.hashCode();
        for (int i = 0; i < itemnames.length; ++i) {
            result += itemnames[i].hashCode();
            result += itemtypes[i].hashCode();
        }
        return result;
    }
}

