/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote.rmi;

import java.io.IOException;
import java.io.NotSerializableException;
import java.rmi.MarshalledObject;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.rmi.RMIConnection;
import javax.security.auth.Subject;
import mx4j.remote.NotificationTuple;
import mx4j.remote.RemoteNotificationClientHandler;
import mx4j.remote.rmi.RMIMarshaller;

public class ClientInvoker
implements MBeanServerConnection {
    private final RMIConnection connection;
    private final Subject delegate;
    private final RemoteNotificationClientHandler notificationHandler;

    public ClientInvoker(RMIConnection rmiConnection, RemoteNotificationClientHandler notificationHandler, Subject delegate) {
        this.connection = rmiConnection;
        this.delegate = delegate;
        this.notificationHandler = notificationHandler;
    }

    @Override
    public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        NotificationTuple tuple = new NotificationTuple(observed, listener, filter, handback);
        if (this.notificationHandler.contains(tuple)) {
            return;
        }
        MarshalledObject f = null;
        try {
            f = RMIMarshaller.marshal(filter);
        }
        catch (NotSerializableException x) {
            tuple.setInvokeFilter(true);
        }
        Integer[] ids = this.connection.addNotificationListeners(new ObjectName[]{observed}, new MarshalledObject[]{f}, new Subject[]{this.delegate});
        this.notificationHandler.addNotificationListener(ids[0], tuple);
    }

    @Override
    public void removeNotificationListener(ObjectName observed, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Integer[] ids = this.notificationHandler.getNotificationListeners(new NotificationTuple(observed, listener));
        if (ids == null) {
            throw new ListenerNotFoundException("Could not find listener " + listener);
        }
        this.connection.removeNotificationListeners(observed, ids, this.delegate);
        this.notificationHandler.removeNotificationListeners(ids);
    }

    @Override
    public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Integer id = this.notificationHandler.getNotificationListener(new NotificationTuple(observed, listener, filter, handback));
        if (id == null) {
            throw new ListenerNotFoundException("Could not find listener " + listener + " with filter " + filter + " and handback " + handback);
        }
        Integer[] ids = new Integer[]{id};
        this.connection.removeNotificationListeners(observed, ids, this.delegate);
        this.notificationHandler.removeNotificationListeners(ids);
    }

    @Override
    public void addNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        MarshalledObject f = RMIMarshaller.marshal(filter);
        MarshalledObject h = RMIMarshaller.marshal(handback);
        this.connection.addNotificationListener(observed, listener, f, h, this.delegate);
    }

    @Override
    public void removeNotificationListener(ObjectName observed, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.connection.removeNotificationListener(observed, listener, this.delegate);
    }

    @Override
    public void removeNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        MarshalledObject f = RMIMarshaller.marshal(filter);
        MarshalledObject h = RMIMarshaller.marshal(handback);
        this.connection.removeNotificationListener(observed, listener, f, h, this.delegate);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return this.connection.getMBeanInfo(objectName, this.delegate);
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException, IOException {
        return this.connection.isInstanceOf(objectName, className, this.delegate);
    }

    @Override
    public String[] getDomains() throws IOException {
        return this.connection.getDomains(this.delegate);
    }

    @Override
    public String getDefaultDomain() throws IOException {
        return this.connection.getDefaultDomain(this.delegate);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        return this.connection.createMBean(className, objectName, this.delegate);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        MarshalledObject arguments = RMIMarshaller.marshal(args);
        return this.connection.createMBean(className, objectName, arguments, parameters, this.delegate);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.connection.createMBean(className, objectName, loaderName, this.delegate);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        MarshalledObject arguments = RMIMarshaller.marshal(args);
        return this.connection.createMBean(className, objectName, loaderName, arguments, parameters, this.delegate);
    }

    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        this.connection.unregisterMBean(objectName, this.delegate);
    }

    @Override
    public Object getAttribute(ObjectName objectName, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        return this.connection.getAttribute(objectName, attribute, this.delegate);
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        MarshalledObject attrib = RMIMarshaller.marshal(attribute);
        this.connection.setAttribute(objectName, attrib, this.delegate);
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        return this.connection.getAttributes(objectName, attributes, this.delegate);
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        MarshalledObject attribs = RMIMarshaller.marshal(attributes);
        return this.connection.setAttributes(objectName, attribs, this.delegate);
    }

    @Override
    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        MarshalledObject arguments = RMIMarshaller.marshal(args);
        return this.connection.invoke(objectName, methodName, arguments, parameters, this.delegate);
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        return this.connection.getMBeanCount(this.delegate);
    }

    @Override
    public boolean isRegistered(ObjectName objectName) throws IOException {
        return this.connection.isRegistered(objectName, this.delegate);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
        return this.connection.getObjectInstance(objectName, this.delegate);
    }

    public Set queryMBeans(ObjectName patternName, QueryExp filter) throws IOException {
        MarshalledObject query = RMIMarshaller.marshal(filter);
        return this.connection.queryMBeans(patternName, query, this.delegate);
    }

    public Set queryNames(ObjectName patternName, QueryExp filter) throws IOException {
        MarshalledObject query = RMIMarshaller.marshal(filter);
        return this.connection.queryNames(patternName, query, this.delegate);
    }
}

