/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.timer.TimeQueue;
import mx4j.timer.TimeTask;
import mx4j.timer.TimerTask;

public class Timer
extends NotificationBroadcasterSupport
implements TimerMBean,
MBeanRegistration {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private TimeQueue queue = new TimeQueue();
    private boolean isActive;
    private int notificationID;
    private HashMap tasks = new HashMap();
    private boolean sendPastNotification;
    private ObjectName objectName;

    private Logger getLogger() {
        return Log.getLogger((String)this.getClass().getName());
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        Logger logger = this.getLogger();
        this.objectName = name;
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)("Timer service " + this.objectName + " preRegistered successfully"));
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        Logger logger = this.getLogger();
        boolean done = registrationDone;
        if (!done) {
            logger.warn((Object)("Timer service " + this.objectName + " was not registered"));
        } else if (logger.isEnabledFor(0)) {
            logger.trace((Object)("Timer service " + this.objectName + " postRegistered successfully."));
        }
    }

    @Override
    public void preDeregister() throws Exception {
        Logger logger = this.getLogger();
        this.stop();
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)("Timer service " + this.objectName + " preDeregistered successfully"));
        }
    }

    @Override
    public void postDeregister() {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)("Timer service " + this.objectName + " postDeregistered successfully"));
        }
    }

    @Override
    public void start() {
        if (!this.isActive()) {
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)("Starting Timer service " + this.objectName));
            }
            this.queue.clear();
            this.queue.start();
            ArrayList tasks = this.updateTasks();
            this.scheduleTasks(tasks);
            this.isActive = true;
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)("Timer service " + this.objectName + " started successfully"));
            }
        }
    }

    @Override
    public void stop() {
        if (this.isActive()) {
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)("Stopping Timer service " + this.objectName));
            }
            this.queue.stop();
            this.queue.clear();
            this.isActive = false;
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)("Timer service " + this.objectName + " stopped successfully"));
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public Integer addNotification(String type, String message, Object userData, Date date) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, 0L, 0L, false);
    }

    @Override
    public Integer addNotification(String type, String message, Object userData, Date date, long period) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, 0L, false);
    }

    @Override
    public Integer addNotification(String type, String message, Object userData, Date date, long period, long occurrences) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, occurrences, false);
    }

    @Override
    public Integer addNotification(String type, String message, Object userData, Date date, long period, long occurrences, boolean fixedRate) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Notification date cannot be null");
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Period cannot be negative");
        }
        if (occurrences < 0L) {
            throw new IllegalArgumentException("Occurrences cannot be negative");
        }
        long now = System.currentTimeMillis();
        if (this.isActive()) {
            long lastTime;
            if (date.getTime() < now) {
                date = new Date(now);
            }
            if (period > 0L && occurrences > 0L && (lastTime = date.getTime() + (occurrences - 1L) * period) < now) {
                throw new IllegalArgumentException("Last date for periodic notification is before current date");
            }
        }
        Integer id = this.addNotificationImpl(type, message, userData, date, period, occurrences, fixedRate);
        if (this.isActive()) {
            TimerTask task = this.getTask(id);
            this.updateTask(task, now);
            if (!task.isFinished()) {
                this.queue.schedule((TimeTask)task);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer addNotificationImpl(String type, String message, Object userData, Date date, long period, long occurrences, boolean fixedRate) {
        Logger logger = this.getLogger();
        Integer id = this.createNotificationID();
        TimerNotification notification = new TimerNotification(type, this, 0L, System.currentTimeMillis(), message, id);
        notification.setUserData(userData);
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Adding timer notification: " + notification + " on Timer service " + this.objectName));
        }
        TimerTask task = this.createTimerTask(notification, date, period, occurrences, fixedRate);
        Timer timer = this;
        synchronized (timer) {
            this.tasks.put(id, task);
        }
        return id;
    }

    private TimerTask createTimerTask(TimerNotification notification, Date date, long period, long occurrences, boolean fixedRate) {
        return new TimerTask(notification, date, period, occurrences, fixedRate){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TimerNotification toSend;
                TimerNotification notification;
                TimerNotification timerNotification = notification = this.getNotification();
                synchronized (timerNotification) {
                    toSend = new TimerNotification(notification.getType(), notification.getSource(), notification.getSequenceNumber(), notification.getTimeStamp(), notification.getMessage(), notification.getNotificationID());
                    toSend.setUserData(notification.getUserData());
                    notification.setSequenceNumber(notification.getSequenceNumber() + 1L);
                }
                Timer.this.sendNotification(toSend);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList updateTasks() {
        ArrayList<TimerTask> list = new ArrayList<TimerTask>();
        boolean sendPast = this.getSendPastNotifications();
        long now = System.currentTimeMillis();
        Timer timer = this;
        synchronized (timer) {
            Map.Entry entry;
            Iterator i = this.tasks.entrySet().iterator();
            while (i.hasNext() && (entry = this.getNextNonFinishedTaskEntry(i)) != null) {
                TimerTask task = (TimerTask)entry.getValue();
                if (!sendPast) {
                    this.updateTask(task, now);
                    if (task.isFinished()) continue;
                }
                list.add(task);
            }
            return list;
        }
    }

    private void updateTask(TimerTask task, long now) {
        long time = task.getNextExecutionTime();
        while (time < now && !task.isFinished()) {
            if (task.isPeriodic()) {
                task.setNextExecutionTime(time + task.getPeriod());
                time = task.getNextExecutionTime();
                continue;
            }
            task.setFinished(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTasks(ArrayList tasks) {
        Timer timer = this;
        synchronized (timer) {
            for (int i = 0; i < tasks.size(); ++i) {
                TimerTask task = (TimerTask)tasks.get(i);
                this.queue.schedule((TimeTask)task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotification(Integer id) throws InstanceNotFoundException {
        Logger logger = this.getLogger();
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            if (t == null) {
                throw new InstanceNotFoundException("Cannot find notification to remove with id: " + id);
            }
            this.queue.unschedule((TimeTask)t);
            this.tasks.remove(id);
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Notification " + t.getNotification() + " removed successfully from Timer service " + this.objectName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotifications(String type) throws InstanceNotFoundException {
        Logger logger = this.getLogger();
        boolean found = false;
        Timer timer = this;
        synchronized (timer) {
            Map.Entry entry;
            Iterator i = this.tasks.entrySet().iterator();
            while (i.hasNext() && (entry = this.getNextNonFinishedTaskEntry(i)) != null) {
                TimerTask t = (TimerTask)entry.getValue();
                TimerNotification n = t.getNotification();
                if (!n.getType().equals(type)) continue;
                this.queue.unschedule((TimeTask)t);
                i.remove();
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("Notification " + n + " removed successfully from Timer service " + this.objectName));
                }
                found = true;
            }
        }
        if (!found) {
            throw new InstanceNotFoundException("Cannot find timer notification to remove with type: " + type + " from Timer service " + this.objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllNotifications() {
        Timer timer = this;
        synchronized (timer) {
            this.queue.clear();
            this.tasks.clear();
            this.notificationID = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllNotificationIDs() {
        Vector vector = new Vector();
        Timer timer = this;
        synchronized (timer) {
            Map.Entry entry;
            Iterator i = this.tasks.entrySet().iterator();
            while (i.hasNext() && (entry = this.getNextNonFinishedTaskEntry(i)) != null) {
                vector.add(entry.getKey());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getNotificationIDs(String type) {
        Vector vector = new Vector();
        Timer timer = this;
        synchronized (timer) {
            Map.Entry entry;
            Iterator i = this.tasks.entrySet().iterator();
            while (i.hasNext() && (entry = this.getNextNonFinishedTaskEntry(i)) != null) {
                TimerTask t = (TimerTask)entry.getValue();
                TimerNotification n = t.getNotification();
                if (!n.getType().equals(type)) continue;
                vector.add(entry.getKey());
            }
        }
        return vector;
    }

    @Override
    public boolean getSendPastNotifications() {
        return this.sendPastNotification;
    }

    @Override
    public void setSendPastNotifications(boolean value) {
        this.sendPastNotification = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNbNotifications() {
        int count = 0;
        Timer timer = this;
        synchronized (timer) {
            Map.Entry entry;
            Iterator i = this.tasks.entrySet().iterator();
            while (i.hasNext() && (entry = this.getNextNonFinishedTaskEntry(i)) != null) {
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Timer timer = this;
        synchronized (timer) {
            return this.getNbNotifications() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNotificationType(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            return t == null ? null : t.getNotification().getType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNotificationMessage(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            return t == null ? null : t.getNotification().getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getNotificationUserData(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            return t == null ? null : t.getNotification().getUserData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            return t == null ? null : new Date(t.getDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getPeriod(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            return t == null ? null : new Long(t.getPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getNbOccurences(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            return t == null ? null : new Long(t.getOccurrences());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer createNotificationID() {
        Timer timer = this;
        synchronized (timer) {
            return new Integer(++this.notificationID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerTask getTask(Integer id) {
        Logger logger = this.getLogger();
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = (TimerTask)this.tasks.get(id);
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Retrieving task with id " + id + ": " + t));
            }
            if (t != null && t.isFinished()) {
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("Task with id " + id + " is expired, removing it"));
                }
                this.tasks.remove(id);
                t = null;
            }
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry getNextNonFinishedTaskEntry(Iterator i) {
        Logger logger = this.getLogger();
        Timer timer = this;
        synchronized (timer) {
            if (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                TimerTask t = (TimerTask)entry.getValue();
                if (t.isFinished()) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug((Object)("Found an expired notification, removing it: " + t));
                    }
                    i.remove();
                    return this.getNextNonFinishedTaskEntry(i);
                }
                return entry;
            }
            return null;
        }
    }

    @Override
    public void sendNotification(Notification n) {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)("Start sending notifications from Timer service " + this.objectName));
        }
        super.sendNotification(n);
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)("Finished sending notifications from Timer service " + this.objectName));
        }
    }

    @Override
    public Boolean getFixedRate(Integer id) {
        return new Boolean(this.getTask(id).getFixedRate());
    }
}

