/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.proxy;

import java.io.IOException;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import mx4j.tools.remote.proxy.RemoteMBeanProxyException;

public class RemoteMBeanProxy
implements DynamicMBean,
NotificationEmitter,
MBeanRegistration {
    private final ObjectName remoteObjectName;
    private final JMXConnector connector;
    private final MBeanServerConnection connection;

    public RemoteMBeanProxy(ObjectName remoteObjectName, JMXServiceURL url, Map environment, Subject delegate) throws IOException {
        this(remoteObjectName, JMXConnectorFactory.newJMXConnector(url, environment), environment, delegate);
    }

    public RemoteMBeanProxy(ObjectName remoteObjectName, JMXConnector connector, Map environment, Subject delegate) throws IOException {
        this.remoteObjectName = remoteObjectName;
        this.connector = connector;
        this.connector.connect(environment);
        this.connection = connector.getMBeanServerConnection(delegate);
    }

    public RemoteMBeanProxy(ObjectName remoteObjectName, MBeanServerConnection connection) {
        this.remoteObjectName = remoteObjectName;
        this.connector = null;
        this.connection = connection;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
        JMXConnector cntor = this.getJMXConnector();
        if (cntor != null) {
            cntor.close();
        }
    }

    @Override
    public void postDeregister() {
    }

    protected ObjectName getRemoteObjectName() {
        return this.remoteObjectName;
    }

    protected MBeanServerConnection getMBeanServerConnection() {
        return this.connection;
    }

    protected JMXConnector getJMXConnector() {
        return this.connector;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try {
            return this.getMBeanServerConnection().getMBeanInfo(this.getRemoteObjectName());
        }
        catch (Exception x) {
            throw new RemoteMBeanProxyException(x);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.getMBeanServerConnection().getAttribute(this.getRemoteObjectName(), attribute);
        }
        catch (InstanceNotFoundException x) {
            throw new RemoteMBeanProxyException(x);
        }
        catch (IOException x) {
            throw new RemoteMBeanProxyException(x);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.getMBeanServerConnection().setAttribute(this.getRemoteObjectName(), attribute);
        }
        catch (InstanceNotFoundException x) {
            throw new RemoteMBeanProxyException(x);
        }
        catch (IOException x) {
            throw new RemoteMBeanProxyException(x);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        try {
            return this.getMBeanServerConnection().getAttributes(this.getRemoteObjectName(), attributes);
        }
        catch (InstanceNotFoundException x) {
            throw new RemoteMBeanProxyException(x);
        }
        catch (ReflectionException x) {
            throw new RemoteMBeanProxyException(x);
        }
        catch (IOException x) {
            throw new RemoteMBeanProxyException(x);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        try {
            return this.getMBeanServerConnection().setAttributes(this.getRemoteObjectName(), attributes);
        }
        catch (InstanceNotFoundException x) {
            throw new RemoteMBeanProxyException(x);
        }
        catch (ReflectionException x) {
            throw new RemoteMBeanProxyException(x);
        }
        catch (IOException x) {
            throw new RemoteMBeanProxyException(x);
        }
    }

    @Override
    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        try {
            return this.getMBeanServerConnection().invoke(this.getRemoteObjectName(), method, arguments, params);
        }
        catch (InstanceNotFoundException x) {
            throw new RemoteMBeanProxyException(x);
        }
        catch (IOException x) {
            throw new RemoteMBeanProxyException(x);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.getMBeanInfo().getNotifications();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        try {
            this.getMBeanServerConnection().addNotificationListener(this.getRemoteObjectName(), listener, filter, handback);
        }
        catch (InstanceNotFoundException x) {
            throw new RemoteMBeanProxyException(x);
        }
        catch (IOException x) {
            throw new RemoteMBeanProxyException(x);
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        try {
            this.getMBeanServerConnection().removeNotificationListener(this.getRemoteObjectName(), listener);
        }
        catch (InstanceNotFoundException x) {
            throw new RemoteMBeanProxyException(x);
        }
        catch (IOException x) {
            throw new RemoteMBeanProxyException(x);
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        try {
            this.getMBeanServerConnection().removeNotificationListener(this.getRemoteObjectName(), listener, filter, handback);
        }
        catch (InstanceNotFoundException x) {
            throw new RemoteMBeanProxyException(x);
        }
        catch (IOException x) {
            throw new RemoteMBeanProxyException(x);
        }
    }
}

