/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescriptorSupport
implements Descriptor {
    private static final long serialVersionUID = -6292969195866300415L;
    private HashMap descriptor;
    private transient HashMap fields = new HashMap(20);

    public DescriptorSupport() {
    }

    public DescriptorSupport(int initNumFields) throws MBeanException, RuntimeOperationsException {
        if (initNumFields <= 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Number of Fields cannot be <= 0"));
        }
        this.fields = new HashMap(initNumFields);
    }

    public DescriptorSupport(DescriptorSupport inDescr) {
        if (inDescr != null) {
            this.setFields(inDescr.getFieldNames(), inDescr.getFieldValues(inDescr.getFieldNames()));
        }
    }

    public DescriptorSupport(String xml) throws MBeanException, RuntimeOperationsException, XMLParseException {
        if (xml == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor XML string is null"));
        }
        NodeList fields = this.documentFromXML(xml).getElementsByTagName("field");
        for (int i = 0; i < fields.getLength(); ++i) {
            this.addFieldFromXML(fields.item(i));
        }
    }

    public DescriptorSupport(String[] pairs) {
        if (pairs != null && pairs.length != 0) {
            for (int i = 0; i < pairs.length; ++i) {
                String pair = pairs[i];
                if (pair == null || pair.length() == 0) continue;
                int equal = pair.indexOf(61);
                if (equal < 1) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("Illegal pair: " + pair));
                }
                String name = pair.substring(0, equal);
                String value = null;
                if (equal < pair.length() - 1) {
                    value = pair.substring(equal + 1);
                }
                this.setField(name, value);
            }
        }
    }

    public DescriptorSupport(String[] names, Object[] values) {
        this.setFields(names, values);
    }

    @Override
    public Object clone() throws RuntimeOperationsException {
        return new DescriptorSupport(this);
    }

    @Override
    public Object getFieldValue(String name) throws RuntimeOperationsException {
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid field name"));
        }
        ValueHolder holder = (ValueHolder)this.fields.get(name.toLowerCase());
        return holder == null ? null : holder.fieldValue;
    }

    @Override
    public void setField(String name, Object value) throws RuntimeOperationsException {
        this.checkField(name, value);
        String lcase = name.toLowerCase();
        ValueHolder holder = (ValueHolder)this.fields.get(lcase);
        ValueHolder newHolder = new ValueHolder(holder == null ? name : holder.fieldName, value);
        this.fields.put(lcase, newHolder);
    }

    @Override
    public void removeField(String name) {
        if (name != null) {
            this.fields.remove(name.toLowerCase());
        }
    }

    @Override
    public String[] getFieldNames() {
        String[] names = new String[this.fields.size()];
        int x = 0;
        for (ValueHolder holder : this.fields.values()) {
            names[x++] = holder.fieldName;
        }
        return names;
    }

    @Override
    public Object[] getFieldValues(String[] names) {
        if (this.fields.isEmpty()) {
            return new Object[0];
        }
        if (names == null) {
            Object[] list = new Object[this.fields.size()];
            int x = 0;
            for (ValueHolder holder : this.fields.values()) {
                list[x++] = holder.fieldValue;
            }
            return list;
        }
        Object[] list = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                list[i] = this.getFieldValue(names[i]);
                continue;
            }
            catch (RuntimeOperationsException x) {
                list[i] = null;
            }
        }
        return list;
    }

    @Override
    public String[] getFields() {
        String[] values = new String[this.fields.size()];
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        for (ValueHolder holder : this.fields.values()) {
            String key = holder.fieldName;
            Object value = holder.fieldValue;
            buffer.setLength(0);
            buffer.append(key);
            buffer.append("=");
            if (value != null) {
                if (value instanceof String) {
                    buffer.append(value.toString());
                } else {
                    buffer.append("(");
                    buffer.append(value.toString());
                    buffer.append(")");
                }
            }
            values[x++] = buffer.toString();
        }
        return values;
    }

    @Override
    public void setFields(String[] names, Object[] values) throws RuntimeOperationsException {
        if (names == null || values == null || names.length != values.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid arguments"));
        }
        for (int i = 0; i < names.length; ++i) {
            this.setField(names[i], values[i]);
        }
    }

    @Override
    public boolean isValid() throws RuntimeOperationsException {
        if (this.getFieldValue("name") == null || this.getFieldValue("descriptorType") == null) {
            return false;
        }
        try {
            for (ValueHolder holder : this.fields.values()) {
                this.checkField(holder.fieldName, holder.fieldValue);
            }
            return true;
        }
        catch (RuntimeOperationsException x) {
            return false;
        }
    }

    public String toXMLString() throws RuntimeOperationsException {
        StringBuffer buf = new StringBuffer(32);
        buf.append("<Descriptor>");
        try {
            if (this.fields.size() != 0) {
                for (ValueHolder holder : this.fields.values()) {
                    Object value = holder.fieldValue;
                    String valstr = this.toXMLValueString(value);
                    buf.append("<field name=\"");
                    buf.append(holder.fieldName);
                    buf.append("\" value=\"");
                    buf.append(valstr);
                    buf.append("\"></field>");
                }
            }
            buf.append("</Descriptor>");
            return buf.toString();
        }
        catch (RuntimeException x) {
            throw new RuntimeOperationsException(x);
        }
    }

    public String toString() throws RuntimeOperationsException {
        StringBuffer buf = new StringBuffer();
        try {
            if (this.fields.size() != 0) {
                Iterator i = this.fields.values().iterator();
                while (i.hasNext()) {
                    ValueHolder holder = (ValueHolder)i.next();
                    buf.append(holder.fieldName).append(" ").append(holder.fieldValue);
                    if (!i.hasNext()) continue;
                    buf.append(",");
                }
            }
            return buf.toString();
        }
        catch (RuntimeOperationsException x) {
            return buf.toString();
        }
    }

    private void addFieldFromXML(Node n) throws XMLParseException, DOMException, RuntimeOperationsException {
        if (!(n instanceof Element)) {
            throw new XMLParseException("Invalid XML descriptor entity");
        }
        NamedNodeMap attributes = n.getAttributes();
        if (attributes.getLength() != 2 && (attributes.getNamedItem("name") == null || attributes.getNamedItem("value") == null)) {
            throw new XMLParseException("Invalid XML descriptor element");
        }
        String name = attributes.getNamedItem("name").getNodeValue();
        String value = attributes.getNamedItem("value").getNodeValue();
        this.setField(name, this.parseValueString(value));
    }

    private void checkField(String name, Object value) throws RuntimeOperationsException {
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal field name"));
        }
        boolean isValid = true;
        if (name.equalsIgnoreCase("name") || name.equalsIgnoreCase("descriptorType")) {
            isValid = value instanceof String && ((String)value).length() != 0;
        } else if (name.equalsIgnoreCase("class") || name.equalsIgnoreCase("role") || name.equalsIgnoreCase("getMethod") || name.equalsIgnoreCase("setMethod")) {
            isValid = value instanceof String;
        } else if (name.equalsIgnoreCase("persistPeriod") || name.equalsIgnoreCase("currencyTimeLimit") || name.equalsIgnoreCase("lastUpdatedTimeStamp") || name.equalsIgnoreCase("lastReturnedTimeStamp")) {
            if (value instanceof Number) {
                isValid = ((Number)value).longValue() >= -1L;
            } else if (value instanceof String) {
                try {
                    isValid = Long.parseLong((String)value) >= -1L;
                }
                catch (NumberFormatException e) {
                    isValid = false;
                }
            } else {
                isValid = false;
            }
        } else if (name.equalsIgnoreCase("log")) {
            String s;
            isValid = value instanceof String ? "t".equalsIgnoreCase(s = (String)value) || "true".equalsIgnoreCase(s) || "f".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s) : value instanceof Boolean;
        } else if (name.equalsIgnoreCase("visibility")) {
            if (value instanceof Number) {
                long l = ((Number)value).longValue();
                isValid = l >= 1L && l <= 4L;
            } else if (value instanceof String) {
                try {
                    long l = Long.parseLong((String)value);
                    isValid = l >= 1L && l <= 4L;
                }
                catch (NumberFormatException e) {
                    isValid = false;
                }
            } else {
                isValid = false;
            }
        } else if (name.equalsIgnoreCase("severity")) {
            if (value instanceof Number) {
                long l = ((Number)value).longValue();
                isValid = l >= 0L && l <= 6L;
            } else if (value instanceof String) {
                try {
                    long l = Long.parseLong((String)value);
                    isValid = l >= 0L && l <= 6L;
                }
                catch (NumberFormatException e) {
                    isValid = false;
                }
            } else {
                isValid = false;
            }
        } else if (name.equalsIgnoreCase("persistPolicy")) {
            String s;
            isValid = value instanceof String ? "OnUpdate".equalsIgnoreCase(s = (String)value) || "OnTimer".equalsIgnoreCase(s) || "NoMoreOftenThan".equalsIgnoreCase(s) || "Always".equalsIgnoreCase(s) || "Never".equalsIgnoreCase(s) : false;
        }
        if (!isValid) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid value '" + value + "' for field " + name));
        }
    }

    private Document documentFromXML(String xml) throws XMLParseException {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document d = db.parse(new ByteArrayInputStream(xml.getBytes()));
            return d;
        }
        catch (Exception x) {
            throw new XMLParseException(x.toString());
        }
    }

    private Class getObjectValueClass(String value) throws XMLParseException {
        int eoc = value.indexOf("/");
        if (eoc == -1) {
            throw new XMLParseException("Illegal XML descriptor class name");
        }
        String klass = value.substring(1, eoc);
        Class<?> result = null;
        try {
            result = Thread.currentThread().getContextClassLoader().loadClass(klass);
        }
        catch (Exception x) {
            throw new XMLParseException(x.toString());
        }
        return result;
    }

    private String getObjectValueString(String value) throws XMLParseException {
        int bov = value.indexOf("/");
        if (bov == -1) {
            throw new XMLParseException("Illegal XML descriptor object value");
        }
        return value.substring(bov + 1, value.length() - 1);
    }

    private String objectClassToID(Class k) {
        StringBuffer result = new StringBuffer();
        result.append(k.getName());
        result.append("/");
        return result.toString();
    }

    private Object parseValueString(String value) throws XMLParseException {
        Object result = null;
        result = value.compareToIgnoreCase("(null)") == 0 ? null : (value.charAt(0) != '(' ? value : this.parseObjectValueString(value));
        return result;
    }

    private Object parseObjectValueString(String value) throws XMLParseException {
        if (value.charAt(value.length() - 1) != ')') {
            throw new XMLParseException("Invalid XML descriptor value");
        }
        Character result = null;
        Class k = this.getObjectValueClass(value);
        String s = this.getObjectValueString(value);
        try {
            result = k != Character.class ? k.getConstructor(String.class).newInstance(s) : new Character(s.charAt(0));
        }
        catch (Exception x) {
            throw new XMLParseException(x.toString());
        }
        return result;
    }

    private String toXMLValueString(Object value) {
        Class<?> k;
        String result = value == null ? "(null)" : ((k = value.getClass()) == String.class && ((String)value).charAt(0) != '(' ? (String)value : this.toObjectXMLValueString(k, value));
        return result;
    }

    private String toObjectXMLValueString(Class k, Object value) {
        StringBuffer result = new StringBuffer();
        result.append("(");
        result.append(this.objectClassToID(k));
        result.append(value.toString());
        result.append(")");
        return result.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        HashMap desc = (HashMap)stream.readFields().get("descriptor", null);
        this.fields = new HashMap(desc.size());
        for (Map.Entry entry : desc.entrySet()) {
            String name = (String)entry.getKey();
            this.fields.put(name.toLowerCase(), new ValueHolder(name, entry.getValue()));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        HashMap<String, Object> desc = new HashMap<String, Object>(this.fields.size());
        for (ValueHolder holder : this.fields.values()) {
            desc.put(holder.fieldName, holder.fieldValue);
        }
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("descriptor", desc);
        stream.writeFields();
    }

    private static class ValueHolder {
        private final String fieldName;
        private final Object fieldValue;

        private ValueHolder(String fieldName, Object value) {
            this.fieldName = fieldName;
            this.fieldValue = value;
        }
    }
}

