/*
 * Decompiled with CFR 0.152.
 */
package mx4j.monitor;

import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import mx4j.log.Logger;
import mx4j.monitor.MX4JMonitor;
import mx4j.monitor.MX4JStringMonitorMBean;

public class MX4JStringMonitor
extends MX4JMonitor
implements MX4JStringMonitorMBean {
    private static final String EMPTY = "";
    private String stringToCompare = "";
    private boolean notifyMatch;
    private boolean notifyDiffer;

    public MX4JStringMonitor() throws NotCompliantMBeanException {
        super(MX4JStringMonitorMBean.class);
    }

    public MX4JStringMonitor(Class management) throws NotCompliantMBeanException {
        super(management);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    public synchronized String getStringToCompare() {
        return this.stringToCompare;
    }

    @Override
    public synchronized void setStringToCompare(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("String to compare cannot be null");
        }
        this.stringToCompare = value;
    }

    @Override
    public synchronized boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    @Override
    public synchronized void setNotifyMatch(boolean notifyMatch) {
        this.notifyMatch = notifyMatch;
    }

    @Override
    public synchronized boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    @Override
    public synchronized void setNotifyDiffer(boolean notifyDiffer) {
        this.notifyDiffer = notifyDiffer;
    }

    @Override
    public String getDerivedGauge(ObjectName objectName) {
        StringMonitorInfo info = (StringMonitorInfo)this.getMonitorInfo(objectName);
        return info.getGauge();
    }

    @Override
    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        StringMonitorInfo info = (StringMonitorInfo)this.getMonitorInfo(objectName);
        return info.getTimestamp();
    }

    @Override
    protected MX4JMonitor.MonitorInfo createMonitorInfo() {
        return new StringMonitorInfo();
    }

    protected int compare(String left, String right) {
        return left == null ? (right == null ? 0 : -1) : (right == null ? 1 : left.compareTo(right));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void monitor(ObjectName name, String attribute, Object value, MX4JMonitor.MonitorInfo monitorInfo) {
        if (!(value instanceof String)) {
            this.sendErrorNotification(monitorInfo, "jmx.monitor.error.type", "Attribute type must be a String, not " + value.getClass(), name, attribute);
            return;
        }
        String gauge = (String)value;
        String reference = null;
        MX4JStringMonitor mX4JStringMonitor = this;
        synchronized (mX4JStringMonitor) {
            reference = this.getStringToCompare();
        }
        Logger logger = this.getLogger();
        StringMonitorInfo info = (StringMonitorInfo)monitorInfo;
        if (logger.isEnabledFor(10)) {
            logger.debug("Computing gauge, previous values are: " + info);
            logger.debug("Current values are: gauge=" + gauge + ", stringToCompare=" + reference);
        }
        this.compareAndSendNotification(gauge, reference, info, name, attribute);
        info.setGauge(gauge);
        info.setTimestamp(System.currentTimeMillis());
    }

    private void compareAndSendNotification(String gauge, String reference, StringMonitorInfo info, ObjectName name, String attribute) {
        boolean equals;
        Logger logger = this.getLogger();
        boolean bl = equals = this.compare(gauge, reference) == 0;
        if (info.isDifferNotified() && !equals) {
            if (logger.isEnabledFor(10)) {
                logger.debug("Difference already notified, gauge=" + gauge + ", string-to-compare=" + reference);
            }
            return;
        }
        if (info.isMatchNotified() && equals) {
            if (logger.isEnabledFor(10)) {
                logger.debug("Match already notified, gauge=" + gauge + ", string-to-compare=" + reference);
            }
            return;
        }
        if (equals) {
            if (logger.isEnabledFor(10)) {
                logger.debug("Gauge matches, gauge=" + gauge + ", string-to-compare=" + reference);
            }
            info.setDifferNotified(false);
            if (this.getNotifyMatch()) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Sending string match notification");
                }
                info.setMatchNotified(true);
                this.sendNotification("jmx.monitor.string.matches", "Gauge " + gauge + " matched " + reference, name, attribute, gauge, reference);
            } else {
                info.setMatchNotified(false);
                if (logger.isEnabledFor(10)) {
                    logger.debug("StringMonitor is configured in non-match-notification mode");
                }
            }
        } else {
            if (logger.isEnabledFor(10)) {
                logger.debug("Gauge differs, gauge=" + gauge + ", string-to-compare=" + reference);
            }
            info.setMatchNotified(false);
            if (this.getNotifyDiffer()) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Sending string differ notification");
                }
                info.setDifferNotified(true);
                this.sendNotification("jmx.monitor.string.differs", "Gauge " + gauge + " differs from " + reference, name, attribute, gauge, reference);
            } else {
                info.setDifferNotified(false);
                if (logger.isEnabledFor(10)) {
                    logger.debug("StringMonitor is configured in non-differ-notification mode");
                }
            }
        }
    }

    protected class StringMonitorInfo
    extends MX4JMonitor.MonitorInfo {
        private String gauge;
        private long timestamp;
        private boolean matchNotified;
        private boolean differNotified;

        protected StringMonitorInfo() {
        }

        public String getGauge() {
            return this.gauge;
        }

        public void setGauge(String gauge) {
            this.gauge = gauge;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public boolean isMatchNotified() {
            return this.matchNotified;
        }

        public void setMatchNotified(boolean matchNotified) {
            this.matchNotified = matchNotified;
        }

        public boolean isDifferNotified() {
            return this.differNotified;
        }

        public void setDifferNotified(boolean differNotified) {
            this.differNotified = differNotified;
        }

        @Override
        public void clearNotificationStatus() {
            super.clearNotificationStatus();
            this.differNotified = false;
            this.matchNotified = false;
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer(super.toString());
            buffer.append(", gauge=").append(this.getGauge());
            buffer.append(", matchNotified=").append(this.isMatchNotified());
            buffer.append(", differNotified=").append(this.isDifferNotified());
            return buffer.toString();
        }
    }
}

