/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ParentListener
extends Thread {
    private File heartbeatFile = null;

    public ParentListener(String path) throws IOException {
        if (path == null) {
            throw new IOException();
        }
        this.heartbeatFile = new File(path);
        this.heartbeatFile.getCanonicalPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.indexOf("windows") >= 0) {
            if (osname.indexOf("nt") == -1 && osname.indexOf("2000") == -1 && osname.indexOf("xp") == -1) {
                return;
            }
            while (!this.heartbeatFile.delete()) {
                ParentListener.yield();
                try {
                    ParentListener.sleep(5000L);
                }
                catch (Exception e) {}
            }
        } else {
            InputStream is = System.in;
            int bytesAvailable = 0;
            int bytesRead = 0;
            byte[] buf = new byte[1024];
            try {
                while (true) {
                    InputStream inputStream = is;
                    synchronized (inputStream) {
                        is.mark(buf.length);
                        bytesAvailable = is.available();
                        if (bytesAvailable < buf.length) {
                            bytesRead = is.read(buf, 0, bytesAvailable + 1);
                            is.reset();
                            if (bytesRead == -1) {
                                break;
                            }
                        } else if (buf.length < 0x3FFFFFFF) {
                            buf = new byte[buf.length * 2];
                        }
                    }
                    ParentListener.yield();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this.heartbeatFile != null) {
            this.heartbeatFile.delete();
        }
        System.exit(0);
    }
}

