/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class AllocationExpression
extends Expression
implements InvocationSite {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    MethodBinding syntheticAccessor;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public FieldDeclaration enumConstant;
    protected TypeBinding typeExpected;
    public boolean inferredReturnType;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.checkCapturedLocalInitializationIfNecessary((ReferenceBinding)this.binding.declaringClass.erasure(), blockScope, flowInfo);
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                flowInfo = this.arguments[i].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                if ((this.arguments[i].implicitConversion & 0x400) == 0) continue;
                this.arguments[i].checkNPE(blockScope, flowContext, flowInfo);
            }
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                typeBindingArray = blockScope.environment().convertToRawTypes(this.binding.thrownExceptions, true, true);
            }
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, (FlowInfo)flowInfo.unconditionalCopy(), blockScope);
        }
        if (this.binding.declaringClass.isMemberType() && !this.binding.declaringClass.isStatic()) {
            blockScope.resetEnclosingMethodStaticFlag();
        }
        this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    public void checkCapturedLocalInitializationIfNecessary(ReferenceBinding referenceBinding, BlockScope blockScope, FlowInfo flowInfo) {
        NestedTypeBinding nestedTypeBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        if ((referenceBinding.tagBits & 0x834L) == 2068L && !blockScope.isDefinedInType(referenceBinding) && (syntheticArgumentBindingArray = (nestedTypeBinding = (NestedTypeBinding)referenceBinding).syntheticOuterLocalVariables()) != null) {
            int n = syntheticArgumentBindingArray.length;
            for (int i = 0; i < n; ++i) {
                SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[i];
                LocalVariableBinding localVariableBinding = syntheticArgumentBinding.actualOuterLocalVariable;
                if (localVariableBinding == null || localVariableBinding.declaration == null || flowInfo.isDefinitelyAssigned(localVariableBinding)) continue;
                blockScope.problemReporter().uninitializedLocalVariable(localVariableBinding, this);
            }
        }
    }

    public Expression enclosingInstance() {
        return null;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        boolean bl2;
        if (!bl) {
            blockScope.problemReporter().unusedObjectAllocation(this);
        }
        int n = codeStream.position;
        MethodBinding methodBinding = this.binding.original();
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        codeStream.new_(referenceBinding);
        boolean bl3 = bl2 = (this.implicitConversion & 0x400) != 0;
        if (bl || bl2) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(n, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invoke((byte)-73, methodBinding, null);
        } else {
            int n2 = this.syntheticAccessor.parameters.length - methodBinding.parameters.length;
            for (int i = 0; i < n2; ++i) {
                codeStream.aconst_null();
            }
            codeStream.invoke((byte)-73, this.syntheticAccessor, null);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else if (bl2) {
            codeStream.generateImplicitConversion(this.implicitConversion);
            switch (this.postConversionType((Scope)blockScope).id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if (referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType()) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, false);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, false);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        MethodBinding methodBinding = this.binding.original();
        if (methodBinding.isPrivate()) {
            ReferenceBinding referenceBinding = methodBinding.declaringClass;
            if (blockScope.enclosingSourceType() != referenceBinding) {
                if ((referenceBinding.tagBits & 0x10L) != 0L && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    methodBinding.tagBits |= 0x200L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)referenceBinding).addSyntheticMethod(methodBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                }
            }
        }
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.type != null) {
            stringBuffer.append("new ");
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            for (int i = 0; i < n2; ++i) {
                this.typeArguments[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.type != null) {
            this.type.printExpression(0, stringBuffer);
        }
        stringBuffer.append('(');
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
            }
        }
        return stringBuffer.append(')');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        ReferenceBinding referenceBinding;
        int n;
        boolean bl;
        int n2;
        this.constant = Constant.NotAConstant;
        if (this.type == null) {
            this.resolvedType = blockScope.enclosingReceiverType();
        } else {
            this.resolvedType = this.type.resolveType(blockScope, true);
            if (this.type instanceof ParameterizedQualifiedTypeReference) {
                ReferenceBinding referenceBinding2 = (ReferenceBinding)this.resolvedType;
                if (referenceBinding2 == null) {
                    return referenceBinding2;
                }
                block0: while ((referenceBinding2.modifiers & 8) == 0 && !referenceBinding2.isRawType()) {
                    if ((referenceBinding2 = referenceBinding2.enclosingType()) != null) continue;
                    ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference = (ParameterizedQualifiedTypeReference)this.type;
                    for (n2 = parameterizedQualifiedTypeReference.typeArguments.length - 2; n2 >= 0; --n2) {
                        if (parameterizedQualifiedTypeReference.typeArguments[n2] == null) continue;
                        blockScope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, this.resolvedType);
                        break block0;
                    }
                }
            }
        }
        boolean bl2 = bl = this.type != null && (this.type.bits & 0x80000) != 0;
        if (this.typeArguments != null) {
            int n3 = this.typeArguments.length;
            n2 = blockScope.compilerOptions().sourceLevel < 0x310000L ? 1 : 0;
            this.genericTypeArguments = new TypeBinding[n3];
            for (n = 0; n < n3; ++n) {
                TypeReference typeReference = this.typeArguments[n];
                this.genericTypeArguments[n] = typeReference.resolveType(blockScope, true);
                if (this.genericTypeArguments[n] == null) {
                    n2 = 1;
                }
                if (n2 == 0 || !(typeReference instanceof Wildcard)) continue;
                blockScope.problemReporter().illegalUsageOfWildcard(typeReference);
            }
            if (bl) {
                blockScope.problemReporter().diamondNotWithExplicitTypeArguments(this.typeArguments);
                return null;
            }
            if (n2 != 0) {
                if (this.arguments != null) {
                    int n4 = this.arguments.length;
                    for (n = 0; n < n4; ++n) {
                        this.arguments[n].resolveType(blockScope);
                    }
                }
                return null;
            }
        }
        boolean bl3 = false;
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            n = 0;
            int n5 = this.arguments.length;
            typeBindingArray = new TypeBinding[n5];
            for (int i = 0; i < n5; ++i) {
                Expression expression = this.arguments[i];
                if (expression instanceof CastExpression) {
                    expression.bits |= 0x20;
                    bl3 = true;
                }
                if ((typeBindingArray[i] = expression.resolveType(blockScope)) != null) continue;
                n = 1;
            }
            if (n != 0) {
                if (bl) {
                    return null;
                }
                if (this.resolvedType instanceof ReferenceBinding) {
                    MethodBinding methodBinding;
                    TypeBinding[] typeBindingArray2 = new TypeBinding[n5];
                    int n6 = n5;
                    while (--n6 >= 0) {
                        typeBindingArray2[n6] = typeBindingArray[n6] == null ? TypeBinding.NULL : typeBindingArray[n6];
                    }
                    this.binding = blockScope.findMethod((ReferenceBinding)this.resolvedType, TypeConstants.INIT, typeBindingArray2, this);
                    if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                        if (methodBinding.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                            methodBinding = blockScope.environment().createParameterizedGenericMethod(methodBinding.original(), (RawTypeBinding)null);
                        }
                        this.binding = methodBinding;
                        MethodBinding methodBinding2 = methodBinding.original();
                        if (methodBinding2.isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod(methodBinding2)) {
                            methodBinding2.modifiers |= 0x8000000;
                        }
                    }
                }
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null || !this.resolvedType.isValidBinding()) {
            return null;
        }
        if (this.type != null && !this.resolvedType.canBeInstantiated()) {
            blockScope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        if (bl) {
            TypeBinding[] typeBindingArray3 = this.inferElidedTypes(((ParameterizedTypeBinding)this.resolvedType).genericType(), null, typeBindingArray, blockScope);
            if (typeBindingArray3 == null) {
                blockScope.problemReporter().cannotInferElidedTypes(this);
                this.resolvedType = null;
                return null;
            }
            this.resolvedType = this.type.resolvedType = blockScope.environment().createParameterizedType(((ParameterizedTypeBinding)this.resolvedType).genericType(), typeBindingArray3, ((ParameterizedTypeBinding)this.resolvedType).enclosingType());
        }
        if (!(this.binding = blockScope.getConstructor(referenceBinding = (ReferenceBinding)this.resolvedType, typeBindingArray, this)).isValidBinding()) {
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = referenceBinding;
            }
            if (this.type != null && !this.type.resolvedType.isValidBinding()) {
                return null;
            }
            blockScope.problemReporter().invalidConstructor(this, this.binding);
            return this.resolvedType;
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            blockScope.problemReporter().missingTypeInConstructor(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (AllocationExpression.checkInvocationArguments(blockScope, null, referenceBinding, this.binding, this.arguments, typeBindingArray, bl3, this)) {
            this.bits |= 0x10000;
        }
        if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
            blockScope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
        }
        if (!bl && this.resolvedType.isParameterizedTypeWithActualArguments()) {
            this.checkTypeArgumentRedundancy((ParameterizedTypeBinding)this.resolvedType, null, typeBindingArray, blockScope);
        }
        return referenceBinding;
    }

    public TypeBinding[] inferElidedTypes(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, TypeBinding[] typeBindingArray, BlockScope blockScope) {
        MethodBinding methodBinding = blockScope.getStaticFactory(referenceBinding, referenceBinding2, typeBindingArray, this);
        if (methodBinding instanceof ParameterizedGenericMethodBinding && methodBinding.isValidBinding()) {
            ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = (ParameterizedGenericMethodBinding)methodBinding;
            this.inferredReturnType = parameterizedGenericMethodBinding.inferredReturnType;
            return ((ParameterizedTypeBinding)methodBinding.returnType).arguments;
        }
        return null;
    }

    public void checkTypeArgumentRedundancy(ParameterizedTypeBinding parameterizedTypeBinding, ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, BlockScope blockScope) {
        int n;
        TypeBinding[] typeBindingArray2;
        ProblemReporter problemReporter = blockScope.problemReporter();
        if (problemReporter.computeSeverity(16778100) == 256 || blockScope.compilerOptions().sourceLevel < 0x330000L) {
            return;
        }
        if (parameterizedTypeBinding.arguments == null) {
            return;
        }
        if (this.genericTypeArguments != null) {
            return;
        }
        if (typeBindingArray == Binding.NO_PARAMETERS && this.typeExpected instanceof ParameterizedTypeBinding) {
            typeBindingArray2 = (TypeBinding[])this.typeExpected;
            if (typeBindingArray2.arguments != null && parameterizedTypeBinding.arguments.length == typeBindingArray2.arguments.length) {
                for (n = 0; n < parameterizedTypeBinding.arguments.length && parameterizedTypeBinding.arguments[n] == typeBindingArray2.arguments[n]; ++n) {
                }
                if (n == parameterizedTypeBinding.arguments.length) {
                    problemReporter.redundantSpecificationOfTypeArguments(this.type, parameterizedTypeBinding.arguments);
                    return;
                }
            }
        }
        if ((typeBindingArray2 = this.inferElidedTypes(parameterizedTypeBinding.genericType(), referenceBinding, typeBindingArray, blockScope)) == null) {
            return;
        }
        for (n = 0; n < typeBindingArray2.length; ++n) {
            if (typeBindingArray2[n] == parameterizedTypeBinding.arguments[n]) continue;
            return;
        }
        problemReporter.redundantSpecificationOfTypeArguments(this.type, parameterizedTypeBinding.arguments);
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    public void setDepth(int n) {
    }

    public void setFieldIndex(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.typeArguments != null) {
                n2 = this.typeArguments.length;
                for (n = 0; n < n2; ++n) {
                    this.typeArguments[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                for (n = 0; n < n2; ++n) {
                    this.arguments[n].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void setExpectedType(TypeBinding typeBinding) {
        this.typeExpected = typeBinding;
    }

    public TypeBinding expectedType() {
        return this.typeExpected;
    }
}

