/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ConditionalExpression
extends OperatorExpression {
    public Expression condition;
    public Expression valueIfTrue;
    public Expression valueIfFalse;
    public Constant optimizedBooleanConstant;
    public Constant optimizedIfTrueConstant;
    public Constant optimizedIfFalseConstant;
    int trueInitStateIndex = -1;
    int falseInitStateIndex = -1;
    int mergedInitStateIndex = -1;
    private int nullStatus = 1;

    public ConditionalExpression(Expression expression, Expression expression2, Expression expression3) {
        this.condition = expression;
        this.valueIfTrue = expression2;
        this.valueIfFalse = expression3;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = expression3.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        int n = (flowInfo.reachMode() & 3) != 0 ? 1 : 0;
        Constant constant = this.condition.optimizedBooleanConstant();
        boolean bl = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl2 = constant != Constant.NotAConstant && !constant.booleanValue();
        int n2 = flowInfo.reachMode();
        flowInfo = this.condition.analyseCode(blockScope, flowContext, flowInfo, constant == Constant.NotAConstant);
        FlowInfo flowInfo3 = flowInfo.initsWhenTrue().copy();
        if (bl2) {
            if ((n2 & 3) == 0) {
                flowInfo3.setReachMode(1);
            }
            if (!ConditionalExpression.isKnowDeadCodePattern(this.condition) || blockScope.compilerOptions().reportDeadCodeInTrivialIfStatement) {
                this.valueIfTrue.complainIfUnreachable(flowInfo3, blockScope, n);
            }
        }
        this.trueInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3);
        flowInfo3 = this.valueIfTrue.analyseCode(blockScope, flowContext, flowInfo3);
        FlowInfo flowInfo4 = flowInfo.initsWhenFalse().copy();
        if (bl) {
            if ((n2 & 3) == 0) {
                flowInfo4.setReachMode(1);
            }
            if (!ConditionalExpression.isKnowDeadCodePattern(this.condition) || blockScope.compilerOptions().reportDeadCodeInTrivialIfStatement) {
                this.valueIfFalse.complainIfUnreachable(flowInfo4, blockScope, n);
            }
        }
        this.falseInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo4);
        flowInfo4 = this.valueIfFalse.analyseCode(blockScope, flowContext, flowInfo4);
        if (bl) {
            flowInfo2 = flowInfo3.addPotentialInitializationsFrom(flowInfo4);
            this.nullStatus = this.valueIfTrue.nullStatus(flowInfo3);
        } else if (bl2) {
            flowInfo2 = flowInfo4.addPotentialInitializationsFrom(flowInfo3);
            this.nullStatus = this.valueIfFalse.nullStatus(flowInfo4);
        } else {
            this.computeNullStatus(flowInfo3, flowInfo4);
            constant = this.optimizedIfTrueConstant;
            boolean bl3 = constant != null && constant != Constant.NotAConstant && constant.booleanValue();
            boolean bl4 = constant != null && constant != Constant.NotAConstant && !constant.booleanValue();
            constant = this.optimizedIfFalseConstant;
            boolean bl5 = constant != null && constant != Constant.NotAConstant && constant.booleanValue();
            boolean bl6 = constant != null && constant != Constant.NotAConstant && !constant.booleanValue();
            UnconditionalFlowInfo unconditionalFlowInfo = flowInfo3.initsWhenTrue().unconditionalCopy();
            UnconditionalFlowInfo unconditionalFlowInfo2 = flowInfo4.initsWhenTrue().unconditionalCopy();
            UnconditionalFlowInfo unconditionalFlowInfo3 = flowInfo3.initsWhenFalse().unconditionalInits();
            UnconditionalFlowInfo unconditionalFlowInfo4 = flowInfo4.initsWhenFalse().unconditionalInits();
            if (bl4) {
                unconditionalFlowInfo.setReachMode(1);
            }
            if (bl6) {
                unconditionalFlowInfo2.setReachMode(1);
            }
            if (bl3) {
                unconditionalFlowInfo3.setReachMode(1);
            }
            if (bl5) {
                unconditionalFlowInfo4.setReachMode(1);
            }
            flowInfo2 = FlowInfo.conditional(unconditionalFlowInfo.mergedWith(unconditionalFlowInfo2), unconditionalFlowInfo3.mergedWith(unconditionalFlowInfo4));
        }
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo2);
        flowInfo2.setReachMode(n2);
        return flowInfo2;
    }

    private void computeNullStatus(FlowInfo flowInfo, FlowInfo flowInfo2) {
        int n;
        int n2 = this.valueIfTrue.nullStatus(flowInfo);
        if (n2 == (n = this.valueIfFalse.nullStatus(flowInfo2))) {
            this.nullStatus = n2;
            return;
        }
        int n3 = 0;
        int n4 = n2 | n;
        if ((n4 & 0x12) != 0) {
            n3 |= 0x10;
        }
        if ((n4 & 0x24) != 0) {
            n3 |= 0x20;
        }
        if ((n4 & 9) != 0) {
            n3 |= 8;
        }
        if (n3 > 0) {
            this.nullStatus = n3;
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (bl) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        Constant constant = this.condition.optimizedBooleanConstant();
        boolean bl2 = constant == Constant.NotAConstant || constant.booleanValue();
        boolean bl3 = constant == Constant.NotAConstant || !constant.booleanValue();
        BranchLabel branchLabel = new BranchLabel(codeStream);
        BranchLabel branchLabel2 = new BranchLabel(codeStream);
        branchLabel2.tagBits |= 2;
        this.condition.generateOptimizedBoolean(blockScope, codeStream, null, branchLabel2, constant == Constant.NotAConstant);
        if (this.trueInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.trueInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.trueInitStateIndex);
        }
        if (bl2) {
            this.valueIfTrue.generateCode(blockScope, codeStream, bl);
            if (bl3) {
                int n2 = codeStream.position;
                codeStream.goto_(branchLabel);
                codeStream.updateLastRecordedEndPC(blockScope, n2);
                if (bl) {
                    switch (this.resolvedType.id) {
                        case 7: 
                        case 8: {
                            codeStream.decrStackSize(2);
                            break;
                        }
                        default: {
                            codeStream.decrStackSize(1);
                        }
                    }
                }
            }
        }
        if (bl3) {
            if (this.falseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.falseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.falseInitStateIndex);
            }
            if (branchLabel2.forwardReferenceCount() > 0) {
                branchLabel2.place();
            }
            this.valueIfFalse.generateCode(blockScope, codeStream, bl);
            if (bl) {
                codeStream.recordExpressionType(this.resolvedType);
            }
            if (bl2) {
                branchLabel.place();
            }
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        BranchLabel branchLabel3;
        BranchLabel branchLabel4;
        boolean bl2;
        block8: {
            int n;
            block10: {
                Constant constant;
                block9: {
                    if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5 || (this.valueIfTrue.implicitConversion & 0xFF) >> 4 != 5) {
                        super.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
                        return;
                    }
                    constant = this.condition.constant;
                    Constant constant2 = this.condition.optimizedBooleanConstant();
                    boolean bl3 = !(constant != Constant.NotAConstant && !constant.booleanValue() || constant2 != Constant.NotAConstant && !constant2.booleanValue());
                    bl2 = !(constant != Constant.NotAConstant && constant.booleanValue() || constant2 != Constant.NotAConstant && constant2.booleanValue());
                    branchLabel4 = new BranchLabel(codeStream);
                    boolean bl4 = constant == Constant.NotAConstant && constant2 == Constant.NotAConstant;
                    branchLabel3 = new BranchLabel(codeStream);
                    this.condition.generateOptimizedBoolean(blockScope, codeStream, null, branchLabel3, bl4);
                    if (this.trueInitStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.trueInitStateIndex);
                        codeStream.addDefinitelyAssignedVariables(blockScope, this.trueInitStateIndex);
                    }
                    if (!bl3) break block8;
                    this.valueIfTrue.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
                    if (!bl2) break block8;
                    if (branchLabel2 != null) break block9;
                    if (branchLabel == null) break block10;
                    constant = this.optimizedIfTrueConstant;
                    int n2 = n = constant != null && constant != Constant.NotAConstant && constant.booleanValue() ? 1 : 0;
                    if (n == 0) break block10;
                    break block8;
                }
                if (branchLabel != null) break block10;
                constant = this.optimizedIfTrueConstant;
                int n3 = n = constant != null && constant != Constant.NotAConstant && !constant.booleanValue() ? 1 : 0;
                if (n != 0) break block8;
            }
            n = codeStream.position;
            codeStream.goto_(branchLabel4);
            codeStream.updateLastRecordedEndPC(blockScope, n);
        }
        if (bl2) {
            branchLabel3.place();
            if (this.falseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.falseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.falseInitStateIndex);
            }
            this.valueIfFalse.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
            branchLabel4.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
    }

    public int nullStatus(FlowInfo flowInfo) {
        return this.nullStatus;
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        this.condition.printExpression(n, stringBuffer).append(" ? ");
        this.valueIfTrue.printExpression(0, stringBuffer).append(" : ");
        return this.valueIfFalse.printExpression(0, stringBuffer);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        Constant constant;
        Object object;
        Object object2;
        this.constant = Constant.NotAConstant;
        LookupEnvironment lookupEnvironment = blockScope.environment();
        boolean bl = blockScope.compilerOptions().sourceLevel >= 0x310000L;
        TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, TypeBinding.BOOLEAN);
        this.condition.computeConversion(blockScope, TypeBinding.BOOLEAN, typeBinding);
        if (this.valueIfTrue instanceof CastExpression) {
            this.valueIfTrue.bits |= 0x20;
        }
        TypeBinding typeBinding2 = this.valueIfTrue.resolveType(blockScope);
        if (this.valueIfFalse instanceof CastExpression) {
            this.valueIfFalse.bits |= 0x20;
        }
        TypeBinding typeBinding3 = this.valueIfFalse.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null || typeBinding3 == null) {
            return null;
        }
        Object object3 = typeBinding2;
        Object object4 = typeBinding3;
        if (bl && object3 != object4) {
            if (((TypeBinding)object3).isBaseType()) {
                if (((TypeBinding)object4).isBaseType()) {
                    if (object3 == TypeBinding.NULL) {
                        object4 = lookupEnvironment.computeBoxingType((TypeBinding)object4);
                    } else if (object4 == TypeBinding.NULL) {
                        object3 = lookupEnvironment.computeBoxingType((TypeBinding)object3);
                    }
                } else {
                    Object object5 = object2 = ((TypeBinding)object4).isBaseType() ? object4 : lookupEnvironment.computeBoxingType((TypeBinding)object4);
                    if (((TypeBinding)object3).isNumericType() && ((TypeBinding)object2).isNumericType()) {
                        object4 = object2;
                    } else if (object3 != TypeBinding.NULL) {
                        object4 = lookupEnvironment.computeBoxingType((TypeBinding)object4);
                    }
                }
            } else if (((TypeBinding)object4).isBaseType()) {
                Object object6 = object2 = ((TypeBinding)object3).isBaseType() ? object3 : lookupEnvironment.computeBoxingType((TypeBinding)object3);
                if (((TypeBinding)object2).isNumericType() && ((TypeBinding)object4).isNumericType()) {
                    object3 = object2;
                } else if (object4 != TypeBinding.NULL) {
                    object3 = lookupEnvironment.computeBoxingType((TypeBinding)object3);
                }
            } else {
                object2 = lookupEnvironment.computeBoxingType((TypeBinding)object3);
                object = lookupEnvironment.computeBoxingType((TypeBinding)object4);
                if (((TypeBinding)object2).isNumericType() && ((TypeBinding)object).isNumericType()) {
                    object3 = object2;
                    object4 = object;
                }
            }
        }
        if ((object2 = this.condition.constant) != Constant.NotAConstant && (object = this.valueIfTrue.constant) != Constant.NotAConstant && (constant = this.valueIfFalse.constant) != Constant.NotAConstant) {
            Object object7 = this.constant = ((Constant)object2).booleanValue() ? object : constant;
        }
        if (object3 == object4) {
            this.valueIfTrue.computeConversion(blockScope, (TypeBinding)object3, typeBinding2);
            this.valueIfFalse.computeConversion(blockScope, (TypeBinding)object4, typeBinding3);
            if (object3 == TypeBinding.BOOLEAN) {
                this.optimizedIfTrueConstant = this.valueIfTrue.optimizedBooleanConstant();
                this.optimizedIfFalseConstant = this.valueIfFalse.optimizedBooleanConstant();
                if (this.optimizedIfTrueConstant != Constant.NotAConstant && this.optimizedIfFalseConstant != Constant.NotAConstant && this.optimizedIfTrueConstant.booleanValue() == this.optimizedIfFalseConstant.booleanValue()) {
                    this.optimizedBooleanConstant = this.optimizedIfTrueConstant;
                } else {
                    object2 = this.condition.optimizedBooleanConstant();
                    if (object2 != Constant.NotAConstant) {
                        this.optimizedBooleanConstant = ((Constant)object2).booleanValue() ? this.optimizedIfTrueConstant : this.optimizedIfFalseConstant;
                    }
                }
            }
            this.resolvedType = object3;
            return this.resolvedType;
        }
        if (((TypeBinding)object3).isNumericType() && ((TypeBinding)object4).isNumericType()) {
            if (object3 == TypeBinding.BYTE && object4 == TypeBinding.SHORT || object3 == TypeBinding.SHORT && object4 == TypeBinding.BYTE) {
                this.valueIfTrue.computeConversion(blockScope, TypeBinding.SHORT, typeBinding2);
                this.valueIfFalse.computeConversion(blockScope, TypeBinding.SHORT, typeBinding3);
                this.resolvedType = TypeBinding.SHORT;
                return this.resolvedType;
            }
            if ((object3 == TypeBinding.BYTE || object3 == TypeBinding.SHORT || object3 == TypeBinding.CHAR) && object4 == TypeBinding.INT && this.valueIfFalse.isConstantValueOfTypeAssignableToType((TypeBinding)object4, (TypeBinding)object3)) {
                this.valueIfTrue.computeConversion(blockScope, (TypeBinding)object3, typeBinding2);
                this.valueIfFalse.computeConversion(blockScope, (TypeBinding)object3, typeBinding3);
                this.resolvedType = object3;
                return this.resolvedType;
            }
            if ((object4 == TypeBinding.BYTE || object4 == TypeBinding.SHORT || object4 == TypeBinding.CHAR) && object3 == TypeBinding.INT && this.valueIfTrue.isConstantValueOfTypeAssignableToType((TypeBinding)object3, (TypeBinding)object4)) {
                this.valueIfTrue.computeConversion(blockScope, (TypeBinding)object4, typeBinding2);
                this.valueIfFalse.computeConversion(blockScope, (TypeBinding)object4, typeBinding3);
                this.resolvedType = object4;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(((TypeBinding)object3).id, 10) && BaseTypeBinding.isNarrowing(((TypeBinding)object4).id, 10)) {
                this.valueIfTrue.computeConversion(blockScope, TypeBinding.INT, typeBinding2);
                this.valueIfFalse.computeConversion(blockScope, TypeBinding.INT, typeBinding3);
                this.resolvedType = TypeBinding.INT;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(((TypeBinding)object3).id, 7) && BaseTypeBinding.isNarrowing(((TypeBinding)object4).id, 7)) {
                this.valueIfTrue.computeConversion(blockScope, TypeBinding.LONG, typeBinding2);
                this.valueIfFalse.computeConversion(blockScope, TypeBinding.LONG, typeBinding3);
                this.resolvedType = TypeBinding.LONG;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(((TypeBinding)object3).id, 9) && BaseTypeBinding.isNarrowing(((TypeBinding)object4).id, 9)) {
                this.valueIfTrue.computeConversion(blockScope, TypeBinding.FLOAT, typeBinding2);
                this.valueIfFalse.computeConversion(blockScope, TypeBinding.FLOAT, typeBinding3);
                this.resolvedType = TypeBinding.FLOAT;
                return this.resolvedType;
            }
            this.valueIfTrue.computeConversion(blockScope, TypeBinding.DOUBLE, typeBinding2);
            this.valueIfFalse.computeConversion(blockScope, TypeBinding.DOUBLE, typeBinding3);
            this.resolvedType = TypeBinding.DOUBLE;
            return this.resolvedType;
        }
        if (((TypeBinding)object3).isBaseType() && object3 != TypeBinding.NULL) {
            if (bl) {
                object3 = lookupEnvironment.computeBoxingType((TypeBinding)object3);
            } else {
                blockScope.problemReporter().conditionalArgumentsIncompatibleTypes(this, (TypeBinding)object3, (TypeBinding)object4);
                return null;
            }
        }
        if (((TypeBinding)object4).isBaseType() && object4 != TypeBinding.NULL) {
            if (bl) {
                object4 = lookupEnvironment.computeBoxingType((TypeBinding)object4);
            } else {
                blockScope.problemReporter().conditionalArgumentsIncompatibleTypes(this, (TypeBinding)object3, (TypeBinding)object4);
                return null;
            }
        }
        if (bl) {
            Object object8 = null;
            object8 = object3 == TypeBinding.NULL ? object4 : (object4 == TypeBinding.NULL ? object3 : blockScope.lowerUpperBound(new TypeBinding[]{object3, object4}));
            if (object8 != null) {
                this.valueIfTrue.computeConversion(blockScope, (TypeBinding)object8, typeBinding2);
                this.valueIfFalse.computeConversion(blockScope, (TypeBinding)object8, typeBinding3);
                this.resolvedType = ((TypeBinding)object8).capture(blockScope, this.sourceEnd);
                return this.resolvedType;
            }
        } else {
            if (((TypeBinding)object4).isCompatibleWith((TypeBinding)object3)) {
                this.valueIfTrue.computeConversion(blockScope, (TypeBinding)object3, typeBinding2);
                this.valueIfFalse.computeConversion(blockScope, (TypeBinding)object3, typeBinding3);
                this.resolvedType = object3;
                return this.resolvedType;
            }
            if (((TypeBinding)object3).isCompatibleWith((TypeBinding)object4)) {
                this.valueIfTrue.computeConversion(blockScope, (TypeBinding)object4, typeBinding2);
                this.valueIfFalse.computeConversion(blockScope, (TypeBinding)object4, typeBinding3);
                this.resolvedType = object4;
                return this.resolvedType;
            }
        }
        blockScope.problemReporter().conditionalArgumentsIncompatibleTypes(this, (TypeBinding)object3, (TypeBinding)object4);
        return null;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.condition.traverse(aSTVisitor, blockScope);
            this.valueIfTrue.traverse(aSTVisitor, blockScope);
            this.valueIfFalse.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

