/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class RawTypeBinding
extends ParameterizedTypeBinding {
    public RawTypeBinding(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, LookupEnvironment lookupEnvironment) {
        super(referenceBinding, null, referenceBinding2, lookupEnvironment);
        ParameterizedTypeBinding parameterizedTypeBinding;
        this.tagBits &= 0xFFFFFFFFFFFFFF7FL;
        if ((referenceBinding.tagBits & 0x80L) != 0L) {
            if (referenceBinding instanceof MissingTypeBinding) {
                this.tagBits |= 0x80L;
            } else if (referenceBinding instanceof ParameterizedTypeBinding && (parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding).genericType() instanceof MissingTypeBinding) {
                this.tagBits |= 0x80L;
            }
        }
        if (referenceBinding2 != null && (referenceBinding2.tagBits & 0x80L) != 0L) {
            if (referenceBinding2 instanceof MissingTypeBinding) {
                this.tagBits |= 0x80L;
            } else if (referenceBinding2 instanceof ParameterizedTypeBinding && (parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding2).genericType() instanceof MissingTypeBinding) {
                this.tagBits |= 0x80L;
            }
        }
        if (referenceBinding2 == null || (referenceBinding2.modifiers & 0x40000000) == 0) {
            this.modifiers &= 0xBFFFFFFF;
        }
    }

    public char[] computeUniqueKey(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType() && this.enclosingType().isParameterizedType()) {
            char[] cArray = this.enclosingType().computeUniqueKey(false);
            stringBuffer.append(cArray, 0, cArray.length - 1);
            stringBuffer.append('.').append(this.sourceName()).append('<').append('>').append(';');
        } else {
            stringBuffer.append(this.genericType().computeUniqueKey(false));
            stringBuffer.insert(stringBuffer.length() - 1, "<>");
        }
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public ParameterizedMethodBinding createParameterizedMethod(MethodBinding methodBinding) {
        if (methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES || methodBinding.isStatic()) {
            return super.createParameterizedMethod(methodBinding);
        }
        return this.environment.createParameterizedGenericMethod(methodBinding, this);
    }

    public int kind() {
        return 1028;
    }

    public String debugName() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.actualType().sourceName()).append("#RAW");
        return stringBuffer.toString();
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            if ((this.modifiers & 0x40000000) == 0) {
                this.genericTypeSignature = this.genericType().signature();
            } else {
                Object object;
                StringBuffer stringBuffer = new StringBuffer(10);
                if (this.isMemberType()) {
                    object = this.enclosingType();
                    char[] cArray = ((TypeBinding)object).genericTypeSignature();
                    stringBuffer.append(cArray, 0, cArray.length - 1);
                    if ((((ReferenceBinding)object).modifiers & 0x40000000) != 0) {
                        stringBuffer.append('.');
                    } else {
                        stringBuffer.append('$');
                    }
                    stringBuffer.append(this.sourceName());
                } else {
                    object = this.genericType().signature();
                    stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
                }
                stringBuffer.append(';');
                int n = stringBuffer.length();
                this.genericTypeSignature = new char[n];
                stringBuffer.getChars(0, n, this.genericTypeSignature, 0);
            }
        }
        return this.genericTypeSignature;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding || this.erasure() == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: 
            case 1028: 
            case 2052: {
                return this.erasure() == typeBinding.erasure();
            }
        }
        return false;
    }

    public boolean isProvablyDistinct(TypeBinding typeBinding) {
        if (this == typeBinding || this.erasure() == typeBinding) {
            return false;
        }
        if (typeBinding == null) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 260: 
            case 1028: 
            case 2052: {
                return this.erasure() != typeBinding.erasure();
            }
        }
        return true;
    }

    protected void initializeArguments() {
        TypeVariableBinding[] typeVariableBindingArray = this.genericType().typeVariables();
        int n = typeVariableBindingArray.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        for (int i = 0; i < n; ++i) {
            typeBindingArray[i] = this.environment.convertToRawType(typeVariableBindingArray[i].erasure(), false);
        }
        this.arguments = typeBindingArray;
    }

    public char[] readableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.actualType().compoundName, '.');
        return cArray;
    }

    public char[] shortReadableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.actualType().sourceName;
        return cArray;
    }
}

