/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class Assignment
extends Expression {
    public Expression lhs;
    public Expression expression;

    public Assignment(Expression expression, Expression expression2, int n) {
        this.lhs = expression;
        expression.bits |= 0x2000;
        this.expression = expression2;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = n;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        LocalVariableBinding localVariableBinding = this.lhs.localVariableBinding();
        if ((this.expression.implicitConversion & 0x400) != 0) {
            this.expression.checkNPE(blockScope, flowContext, flowInfo);
        }
        flowInfo = ((Reference)this.lhs).analyseAssignment(blockScope, flowContext, flowInfo, this, false).unconditionalInits();
        int n = this.expression.nullStatus(flowInfo);
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L && n == 2) {
            flowContext.recordUsingNullReference(blockScope, localVariableBinding, this.lhs, 769, flowInfo);
        }
        n = this.checkAgainstNullAnnotation(blockScope, localVariableBinding, n);
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L) {
            flowInfo.markNullStatus(localVariableBinding, n);
            if (flowContext.initsOnFinally != null) {
                flowContext.initsOnFinally.markNullStatus(localVariableBinding, n);
            }
        }
        return flowInfo;
    }

    void checkAssignment(BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        FieldBinding fieldBinding = this.getLastField(this.lhs);
        if (fieldBinding != null && typeBinding2 != TypeBinding.NULL && typeBinding.kind() == 516 && ((WildcardBinding)typeBinding).boundKind != 2) {
            blockScope.problemReporter().wildcardAssignment(typeBinding, typeBinding2, this.expression);
        } else if (fieldBinding != null && !fieldBinding.isStatic() && fieldBinding.declaringClass != null && fieldBinding.declaringClass.isRawType()) {
            blockScope.problemReporter().unsafeRawFieldAssignment(fieldBinding, typeBinding2, this.lhs);
        } else if (typeBinding2.needsUncheckedConversion(typeBinding)) {
            blockScope.problemReporter().unsafeTypeConversion(this.expression, typeBinding2, typeBinding);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        ((Reference)this.lhs).generateAssignment(blockScope, codeStream, this, bl);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    FieldBinding getLastField(Expression expression) {
        if (expression instanceof SingleNameReference) {
            if ((expression.bits & 7) == 1) {
                return (FieldBinding)((SingleNameReference)expression).binding;
            }
        } else {
            if (expression instanceof FieldReference) {
                return ((FieldReference)expression).binding;
            }
            if (expression instanceof QualifiedNameReference) {
                QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)expression;
                if (qualifiedNameReference.otherBindings == null) {
                    if ((expression.bits & 7) == 1) {
                        return (FieldBinding)qualifiedNameReference.binding;
                    }
                } else {
                    return qualifiedNameReference.otherBindings[qualifiedNameReference.otherBindings.length - 1];
                }
            }
        }
        return null;
    }

    public int nullStatus(FlowInfo flowInfo) {
        return this.expression.nullStatus(flowInfo);
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Assignment.printIndent(n, stringBuffer);
        return this.printExpressionNoParenthesis(n, stringBuffer);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        return this.printExpressionNoParenthesis(0, stringBuffer).append(')');
    }

    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        this.lhs.printExpression(n, stringBuffer).append(" = ");
        return this.expression.printExpression(0, stringBuffer);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer).append(';');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        LocalVariableBinding localVariableBinding;
        this.constant = Constant.NotAConstant;
        if (!(this.lhs instanceof Reference) || this.lhs.isThis()) {
            blockScope.problemReporter().expressionShouldBeAVariable(this.lhs);
            return null;
        }
        TypeBinding typeBinding = this.lhs.resolveType(blockScope);
        this.expression.setExpectedType(typeBinding);
        if (typeBinding != null) {
            this.resolvedType = typeBinding.capture(blockScope, this.sourceEnd);
        }
        if ((localVariableBinding = this.lhs.localVariableBinding()) != null) {
            localVariableBinding.tagBits &= 0xFFFFFFFFFFFFF7FFL;
        }
        TypeBinding typeBinding2 = this.expression.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null) {
            return null;
        }
        Binding binding = Assignment.getDirectBinding(this.lhs);
        if (binding != null && !binding.isVolatile() && binding == Assignment.getDirectBinding(this.expression)) {
            blockScope.problemReporter().assignmentHasNoEffect(this, binding.shortReadableName());
        }
        if (typeBinding != typeBinding2) {
            blockScope.compilationUnitScope().recordTypeConversion(typeBinding, typeBinding2);
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) || typeBinding2.isCompatibleWith(typeBinding)) {
            this.expression.computeConversion(blockScope, typeBinding, typeBinding2);
            this.checkAssignment(blockScope, typeBinding, typeBinding2);
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4000) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.expression);
            }
            return this.resolvedType;
        }
        if (this.isBoxingCompatible(typeBinding2, typeBinding, this.expression, blockScope)) {
            this.expression.computeConversion(blockScope, typeBinding, typeBinding2);
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4000) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.expression);
            }
            return this.resolvedType;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this.expression, (ASTNode)this.lhs);
        return typeBinding;
    }

    public TypeBinding resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        TypeBinding typeBinding2 = super.resolveTypeExpecting(blockScope, typeBinding);
        if (typeBinding2 == null) {
            return null;
        }
        TypeBinding typeBinding3 = this.resolvedType;
        TypeBinding typeBinding4 = this.expression.resolvedType;
        if (typeBinding == TypeBinding.BOOLEAN && typeBinding3 == TypeBinding.BOOLEAN && (this.lhs.bits & 0x2000) != 0) {
            blockScope.problemReporter().possibleAccidentalBooleanAssignment(this);
        }
        this.checkAssignment(blockScope, typeBinding3, typeBinding4);
        return typeBinding2;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.lhs.traverse(aSTVisitor, blockScope);
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public LocalVariableBinding localVariableBinding() {
        return this.lhs.localVariableBinding();
    }
}

